/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.client;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.client.AMQPClientConnectionFactory;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASLFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonClientConnectionManager
implements BaseConnectionLifeCycleListener<ProtonProtocolManager>,
BufferHandler {
    private final Map<Object, ActiveMQProtonRemotingConnection> connectionMap = new ConcurrentHashMap<Object, ActiveMQProtonRemotingConnection>();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPClientConnectionFactory connectionFactory;
    private final Optional<EventHandler> eventHandler;
    private final ClientSASLFactory clientSASLFactory;

    public ProtonClientConnectionManager(AMQPClientConnectionFactory connectionFactory, Optional<EventHandler> eventHandler, ClientSASLFactory clientSASLFactory) {
        this.connectionFactory = connectionFactory;
        this.eventHandler = eventHandler;
        this.clientSASLFactory = clientSASLFactory;
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, ProtonProtocolManager protocolManager) {
        ActiveMQProtonRemotingConnection amqpConnection = this.connectionFactory.createConnection(protocolManager, connection, this.eventHandler, this.clientSASLFactory);
        this.connectionMap.put(connection.getID(), amqpConnection);
        amqpConnection.open();
        logger.info("Connection {} created", (Object)amqpConnection.getRemoteAddress());
    }

    public void connectionDestroyed(Object connectionID, boolean failed) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.remove(connectionID);
        if (connection != null) {
            logger.info("Connection {} destroyed", (Object)connection.getRemoteAddress());
            connection.fail((ActiveMQException)new ActiveMQRemoteDisconnectException());
        } else {
            logger.error("Connection with id {} not found in connectionDestroyed", connectionID);
        }
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.get(connectionID);
        if (connection != null) {
            logger.info("Connection {} exception: {}", (Object)connection.getRemoteAddress(), (Object)me.getMessage());
            connection.fail(me);
        } else {
            logger.error("Connection with id {} not found in connectionException", connectionID);
        }
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.get(connectionID);
        if (connection != null) {
            logger.info("Connection {} ready", (Object)connection.getRemoteAddress());
            connection.getTransportConnection().fireReady(true);
        } else {
            logger.error("Connection with id {} not found in connectionReadyForWrites()!", connectionID);
        }
    }

    public void stop() {
        for (RemotingConnection remotingConnection : this.connectionMap.values()) {
            remotingConnection.destroy();
        }
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
        RemotingConnection connection = (RemotingConnection)this.connectionMap.get(connectionID);
        if (connection != null) {
            connection.bufferReceived(connectionID, buffer);
        } else {
            logger.error("Connection with id {} not found in bufferReceived()!", connectionID);
        }
    }

    public RemotingConnection getConnection(Object connectionId) {
        return (RemotingConnection)this.connectionMap.get(connectionId);
    }
}

