/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.HashMap;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.ParseException;

class ExpressionUtils {
    ExpressionUtils() {
    }

    static void parsePath(ASTPath pathExp, String path) throws ParseException {
        if (path == null || !path.contains("#")) {
            pathExp.setPath(path);
            return;
        }
        CharSequence[] pathSegments = path.split("\\.");
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (int i = 0; i < pathSegments.length; ++i) {
            String previousAlias;
            if (!pathSegments[i].contains("#")) continue;
            String[] splitSegment = ((String)pathSegments[i]).split("#");
            if (splitSegment[1].endsWith("+")) {
                splitSegment[0] = splitSegment[0] + '+';
                splitSegment[1] = splitSegment[1].substring(0, splitSegment[1].length() - 1);
            }
            if ((previousAlias = aliasMap.putIfAbsent(splitSegment[1], splitSegment[0])) != null && !previousAlias.equals(splitSegment[0])) {
                throw new ParseException("Can't add the same alias to different path segments.");
            }
            pathSegments[i] = splitSegment[1];
        }
        pathExp.setPath(String.join((CharSequence)".", pathSegments));
        pathExp.setPathAliases(aliasMap);
    }
}

