/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.AbstractIndexExtractorTest;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public abstract class AbstractHasherTest
extends AbstractIndexExtractorTest {
    @Override
    protected IndexExtractor createEmptyExtractor() {
        return this.createEmptyHasher().indices(this.getTestShape());
    }

    protected abstract Hasher createEmptyHasher();

    @Override
    protected IndexExtractor createExtractor() {
        return this.createHasher().indices(this.getTestShape());
    }

    protected abstract Hasher createHasher();

    protected abstract int getHasherSize(Hasher var1);

    protected final Shape getTestShape() {
        return Shape.fromKM((int)17, (int)72);
    }

    @ParameterizedTest
    @CsvSource(value={"17, 72", "3, 14", "5, 67868", "75, 10"})
    public void testHashing(int k, int m) {
        int[] count = new int[]{0};
        Hasher hasher = this.createHasher();
        hasher.indices(Shape.fromKM((int)k, (int)m)).processIndices(i -> {
            Assertions.assertTrue((i >= 0 && i < m ? 1 : 0) != 0, () -> "Out of range: " + i + ", m=" + m);
            count[0] = count[0] + 1;
            return true;
        });
        Assertions.assertEquals((int)(k * this.getHasherSize(hasher)), (int)count[0], () -> String.format("Did not produce k=%d * m=%d indices", k, this.getHasherSize(hasher)));
        count[0] = 0;
        hasher.indices(Shape.fromKM((int)k, (int)m)).processIndices(i -> {
            Assertions.assertTrue((i >= 0 && i < m ? 1 : 0) != 0, () -> "Out of range: " + i + ", m=" + m);
            count[0] = count[0] + 1;
            return false;
        });
        Assertions.assertEquals((int)1, (int)count[0], (String)"did not exit early");
    }
}

