/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.comparators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.comparators.AbstractComparatorTest;
import org.apache.commons.collections4.comparators.BooleanComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BooleanComparatorTest
extends AbstractComparatorTest<Boolean> {
    protected void allTests(boolean trueFirst, BooleanComparator comp) {
        this.orderIndependentTests(comp);
        if (trueFirst) {
            this.trueFirstTests(comp);
        } else {
            this.falseFirstTests(comp);
        }
    }

    protected void falseFirstTests(BooleanComparator comp) {
        Assertions.assertNotNull((Object)comp);
        Assertions.assertEquals((int)0, (int)comp.compare(Boolean.valueOf(true), Boolean.valueOf(true)));
        Assertions.assertEquals((int)0, (int)comp.compare(Boolean.valueOf(false), Boolean.valueOf(false)));
        Assertions.assertTrue((comp.compare(Boolean.valueOf(false), Boolean.valueOf(true)) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((comp.compare(Boolean.valueOf(true), Boolean.valueOf(false)) > 0 ? 1 : 0) != 0);
    }

    @Override
    public List<Boolean> getComparableObjectsOrdered() {
        return new ArrayList<Boolean>(Arrays.asList(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, true));
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public Comparator<Boolean> makeObject() {
        return new BooleanComparator();
    }

    protected void nullArgumentTests(BooleanComparator comp) {
        Assertions.assertNotNull((Object)comp);
        Assertions.assertThrows(NullPointerException.class, () -> comp.compare(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> comp.compare(Boolean.TRUE, null));
        Assertions.assertThrows(NullPointerException.class, () -> comp.compare(Boolean.FALSE, null));
        Assertions.assertThrows(NullPointerException.class, () -> comp.compare(null, Boolean.TRUE));
        Assertions.assertThrows(NullPointerException.class, () -> comp.compare(null, Boolean.FALSE));
    }

    protected void orderIndependentTests(BooleanComparator comp) {
        this.nullArgumentTests(comp);
    }

    @Test
    public void testConstructors() {
        this.allTests(false, new BooleanComparator());
        this.allTests(false, new BooleanComparator(false));
        this.allTests(true, new BooleanComparator(true));
    }

    @Test
    public void testEqualsCompatibleInstance() {
        Assertions.assertEquals((Object)new BooleanComparator(), (Object)new BooleanComparator(false));
        Assertions.assertEquals((Object)new BooleanComparator(false), (Object)new BooleanComparator(false));
        Assertions.assertEquals((Object)new BooleanComparator(false), (Object)BooleanComparator.getFalseFirstComparator());
        Assertions.assertSame((Object)BooleanComparator.getFalseFirstComparator(), (Object)BooleanComparator.booleanComparator((boolean)false));
        Assertions.assertEquals((Object)new BooleanComparator(true), (Object)new BooleanComparator(true));
        Assertions.assertEquals((Object)new BooleanComparator(true), (Object)BooleanComparator.getTrueFirstComparator());
        Assertions.assertSame((Object)BooleanComparator.getTrueFirstComparator(), (Object)BooleanComparator.booleanComparator((boolean)true));
        Assertions.assertNotEquals((Object)new BooleanComparator(), (Object)new BooleanComparator(true));
        Assertions.assertNotEquals((Object)new BooleanComparator(true), (Object)new BooleanComparator(false));
    }

    @Test
    public void testStaticFactoryMethods() {
        this.allTests(false, BooleanComparator.getFalseFirstComparator());
        this.allTests(false, BooleanComparator.booleanComparator((boolean)false));
        this.allTests(true, BooleanComparator.getTrueFirstComparator());
        this.allTests(true, BooleanComparator.booleanComparator((boolean)true));
    }

    protected void trueFirstTests(BooleanComparator comp) {
        Assertions.assertNotNull((Object)comp);
        Assertions.assertEquals((int)0, (int)comp.compare(Boolean.valueOf(true), Boolean.valueOf(true)));
        Assertions.assertEquals((int)0, (int)comp.compare(Boolean.valueOf(false), Boolean.valueOf(false)));
        Assertions.assertTrue((comp.compare(Boolean.valueOf(false), Boolean.valueOf(true)) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((comp.compare(Boolean.valueOf(true), Boolean.valueOf(false)) < 0 ? 1 : 0) != 0);
    }
}

