/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.AbstractHashedMap;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultiKeyMapTest<K, V>
extends AbstractIterableMapTest<MultiKey<? extends K>, V> {
    static final Integer I1 = 1;
    static final Integer I2 = 2;
    static final Integer I3 = 3;
    static final Integer I4 = 4;
    static final Integer I5 = 5;
    static final Integer I6 = 6;
    static final Integer I7 = 7;
    static final Integer I8 = 8;

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public MultiKeyMap<K, V> getMap() {
        return (MultiKeyMap)super.getMap();
    }

    private MultiKey<K>[] getMultiKeyKeys() {
        return new MultiKey[]{new MultiKey((Object)I1, (Object)I2), new MultiKey((Object)I2, (Object)I3), new MultiKey((Object)I3, (Object)I4), new MultiKey((Object)I1, (Object)I1, (Object)I2), new MultiKey((Object)I2, (Object)I3, (Object)I4), new MultiKey((Object)I3, (Object)I7, (Object)I6), new MultiKey((Object)I1, (Object)I1, (Object)I2, (Object)I3), new MultiKey((Object)I2, (Object)I4, (Object)I5, (Object)I6), new MultiKey((Object)I3, (Object)I6, (Object)I7, (Object)I8), new MultiKey((Object)I1, (Object)I1, (Object)I2, (Object)I3, (Object)I4), new MultiKey((Object)I2, (Object)I3, (Object)I4, (Object)I5, (Object)I6), new MultiKey((Object)I3, (Object)I5, (Object)I6, (Object)I7, (Object)I8)};
    }

    @Override
    public V[] getNewSampleValues() {
        return new Object[]{"1a", "1b", "1c", "2d", "2e", "2f", "3g", "3h", "3i", "4j", "4k", "4l"};
    }

    public MultiKey<K>[] getOtherKeys() {
        return new MultiKey[]{new MultiKey((Object)I1, (Object)I7), new MultiKey((Object)I1, (Object)I8), new MultiKey((Object)I2, (Object)I4), new MultiKey((Object)I2, (Object)I5)};
    }

    public MultiKey<K>[] getSampleKeys() {
        return this.getMultiKeyKeys();
    }

    @Override
    public V[] getSampleValues() {
        return new Object[]{"2A", "2B", "2C", "3D", "3E", "3F", "4G", "4H", "4I", "5J", "5K", "5L"};
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public MultiKeyMap<K, V> makeObject() {
        return new MultiKeyMap();
    }

    @Test
    public void testClone() {
        MultiKeyMap map = new MultiKeyMap();
        map.put(new MultiKey((Object)I1, (Object)I2), (Object)"1-2");
        MultiKeyMap cloned = map.clone();
        Assertions.assertEquals((int)map.size(), (int)cloned.size());
        Assertions.assertSame((Object)map.get((Object)new MultiKey((Object)I1, (Object)I2)), cloned.get(new MultiKey((Object)I1, (Object)I2)));
    }

    @Test
    public void testCompress872() {
        AtomicReference<String> k1 = new AtomicReference<String>("K1v1");
        AtomicReference<String> k2 = new AtomicReference<String>("K2v1");
        MultiKeyMap<K, V> map = this.makeObject();
        Assertions.assertNull((Object)map.put(k1, k2, (Object)"V"));
        Assertions.assertEquals((Object)"V", (Object)map.get(k1, k2));
        k1.set("K1v2");
        Assertions.assertEquals((Object)"V", (Object)map.get(k1, k2));
        Assertions.assertEquals((Object)"V", (Object)map.get(k1, k2));
    }

    @Test
    public void testLRUMultiKeyMap() {
        MultiKeyMap map = MultiKeyMap.multiKeyMap((AbstractHashedMap)new LRUMap(2));
        map.put((Object)I1, (Object)I2, (Object)"1-2");
        map.put((Object)I1, (Object)I3, (Object)"1-1");
        Assertions.assertEquals((int)2, (int)map.size());
        map.put((Object)I1, (Object)I4, (Object)"1-4");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey((Object)I1, (Object)I3));
        Assertions.assertTrue((boolean)map.containsKey((Object)I1, (Object)I4));
        Assertions.assertFalse((boolean)map.containsKey((Object)I1, (Object)I2));
        MultiKeyMap cloned = map.clone();
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertTrue((boolean)cloned.containsKey((Object)I1, (Object)I3));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)I1, (Object)I4));
        Assertions.assertFalse((boolean)cloned.containsKey((Object)I1, (Object)I2));
        cloned.put((Object)I1, (Object)I5, (Object)"1-5");
        Assertions.assertEquals((int)2, (int)cloned.size());
        Assertions.assertTrue((boolean)cloned.containsKey((Object)I1, (Object)I4));
        Assertions.assertTrue((boolean)cloned.containsKey((Object)I1, (Object)I5));
    }

    @Test
    public void testMultiKeyContainsKey() {
        MultiKey<K>[] keys;
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        block6: for (MultiKey<K> key : keys = this.getMultiKeyKeys()) {
            switch (key.size()) {
                case 2: {
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    Assertions.assertFalse((boolean)multimap.containsKey(null, key.getKey(1)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), null));
                    Assertions.assertFalse((boolean)multimap.containsKey(null, null));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null, null));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null, null, null));
                    continue block6;
                }
                case 3: {
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    Assertions.assertFalse((boolean)multimap.containsKey(null, key.getKey(1), key.getKey(2)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), null, key.getKey(2)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null));
                    Assertions.assertFalse((boolean)multimap.containsKey(null, null, null));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), null, null));
                    continue block6;
                }
                case 4: {
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertFalse((boolean)multimap.containsKey(null, key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), null, key.getKey(2), key.getKey(3)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null, key.getKey(3)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    Assertions.assertFalse((boolean)multimap.containsKey(null, null, null, null));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    continue block6;
                }
                case 5: {
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertFalse((boolean)multimap.containsKey(null, key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), null, key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), null, key.getKey(3), key.getKey(4)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), null, key.getKey(4)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    Assertions.assertFalse((boolean)multimap.containsKey(null, null, null, null, null));
                    continue block6;
                }
                default: {
                    Assertions.fail((String)"Invalid key size");
                }
            }
        }
    }

    @Test
    public void testMultiKeyGet() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        MultiKey<K>[] keys = this.getMultiKeyKeys();
        V[] values = this.getSampleValues();
        block6: for (int i = 0; i < keys.length; ++i) {
            MultiKey<K> key = keys[i];
            V value = values[i];
            switch (key.size()) {
                case 2: {
                    Assertions.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1)));
                    Assertions.assertNull((Object)multimap.get(null, key.getKey(1)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), null));
                    Assertions.assertNull((Object)multimap.get(null, null));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), null));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), null, null));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), null, null, null));
                    continue block6;
                }
                case 3: {
                    Assertions.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2)));
                    Assertions.assertNull((Object)multimap.get(null, key.getKey(1), key.getKey(2)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), null, key.getKey(2)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), null));
                    Assertions.assertNull((Object)multimap.get(null, null, null));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), null, null));
                    continue block6;
                }
                case 4: {
                    Assertions.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertNull((Object)multimap.get(null, key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), null, key.getKey(2), key.getKey(3)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), null, key.getKey(3)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    Assertions.assertNull((Object)multimap.get(null, null, null, null));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    continue block6;
                }
                case 5: {
                    Assertions.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertNull((Object)multimap.get(null, key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), null, key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), null, key.getKey(3), key.getKey(4)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), null, key.getKey(4)));
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    Assertions.assertNull((Object)multimap.get(null, null, null, null, null));
                    continue block6;
                }
                default: {
                    Assertions.fail((String)"Invalid key size");
                }
            }
        }
    }

    @Test
    public void testMultiKeyPut() {
        MultiKey<K>[] keys = this.getMultiKeyKeys();
        V[] values = this.getSampleValues();
        block6: for (int i = 0; i < keys.length; ++i) {
            MultiKeyMap multimap = new MultiKeyMap();
            MultiKey<K> key = keys[i];
            V value = values[i];
            switch (key.size()) {
                case 2: {
                    Assertions.assertNull((Object)multimap.put(key.getKey(0), key.getKey(1), value));
                    Assertions.assertEquals((int)1, (int)multimap.size());
                    Assertions.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1)));
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    Assertions.assertTrue((boolean)multimap.containsKey((Object)new MultiKey(key.getKey(0), key.getKey(1))));
                    Assertions.assertEquals(value, (Object)multimap.put(key.getKey(0), key.getKey(1), null));
                    Assertions.assertEquals((int)1, (int)multimap.size());
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1)));
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    continue block6;
                }
                case 3: {
                    Assertions.assertNull((Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), value));
                    Assertions.assertEquals((int)1, (int)multimap.size());
                    Assertions.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2)));
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    Assertions.assertTrue((boolean)multimap.containsKey((Object)new MultiKey(key.getKey(0), key.getKey(1), key.getKey(2))));
                    Assertions.assertEquals(value, (Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), null));
                    Assertions.assertEquals((int)1, (int)multimap.size());
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2)));
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    continue block6;
                }
                case 4: {
                    Assertions.assertNull((Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), value));
                    Assertions.assertEquals((int)1, (int)multimap.size());
                    Assertions.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertTrue((boolean)multimap.containsKey((Object)new MultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3))));
                    Assertions.assertEquals(value, (Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), null));
                    Assertions.assertEquals((int)1, (int)multimap.size());
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    continue block6;
                }
                case 5: {
                    Assertions.assertNull((Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4), value));
                    Assertions.assertEquals((int)1, (int)multimap.size());
                    Assertions.assertEquals(value, (Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertTrue((boolean)multimap.containsKey((Object)new MultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4))));
                    Assertions.assertEquals(value, (Object)multimap.put(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4), null));
                    Assertions.assertEquals((int)1, (int)multimap.size());
                    Assertions.assertNull((Object)multimap.get(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    continue block6;
                }
                default: {
                    Assertions.fail((String)"Invalid key size");
                }
            }
        }
    }

    @Test
    public void testMultiKeyPutWithNullKey() {
        MultiKeyMap map = new MultiKeyMap();
        map.put((Object)"a", null, (Object)"value1");
        map.put((Object)"b", null, (Object)"value2");
        map.put((Object)"c", null, (Object)"value3");
        map.put((Object)"a", (Object)"z", (Object)"value4");
        map.put((Object)"a", null, (Object)"value5");
        map.put(null, (Object)"a", (Object)"value6");
        map.put(null, null, (Object)"value7");
        Assertions.assertEquals((int)6, (int)map.size());
        Assertions.assertEquals((Object)"value5", (Object)map.get((Object)"a", null));
        Assertions.assertEquals((Object)"value4", (Object)map.get((Object)"a", (Object)"z"));
        Assertions.assertEquals((Object)"value6", (Object)map.get(null, (Object)"a"));
    }

    @Test
    public void testMultiKeyRemove() {
        MultiKey<K>[] keys = this.getMultiKeyKeys();
        V[] values = this.getSampleValues();
        block6: for (int i = 0; i < keys.length; ++i) {
            this.resetFull();
            MultiKeyMap<K, V> multimap = this.getMap();
            int size = multimap.size();
            MultiKey<K> key = keys[i];
            V value = values[i];
            switch (key.size()) {
                case 2: {
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    Assertions.assertEquals(value, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    Assertions.assertEquals((int)(size - 1), (int)multimap.size());
                    Assertions.assertNull((Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1)));
                    continue block6;
                }
                case 3: {
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    Assertions.assertEquals(value, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    Assertions.assertEquals((int)(size - 1), (int)multimap.size());
                    Assertions.assertNull((Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2)));
                    continue block6;
                }
                case 4: {
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertEquals(value, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertEquals((int)(size - 1), (int)multimap.size());
                    Assertions.assertNull((Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3)));
                    continue block6;
                }
                case 5: {
                    Assertions.assertTrue((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertEquals(value, (Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertEquals((int)(size - 1), (int)multimap.size());
                    Assertions.assertNull((Object)multimap.removeMultiKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    Assertions.assertFalse((boolean)multimap.containsKey(key.getKey(0), key.getKey(1), key.getKey(2), key.getKey(3), key.getKey(4)));
                    continue block6;
                }
                default: {
                    Assertions.fail((String)"Invalid key size");
                }
            }
        }
    }

    @Test
    public void testMultiKeyRemoveAll1() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        Assertions.assertEquals((int)12, (int)multimap.size());
        multimap.removeAll((Object)I1);
        Assertions.assertEquals((int)8, (int)multimap.size());
        MapIterator it = multimap.mapIterator();
        while (it.hasNext()) {
            MultiKey key = (MultiKey)it.next();
            Assertions.assertFalse((boolean)I1.equals(key.getKey(0)));
        }
    }

    @Test
    public void testMultiKeyRemoveAll2() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        Assertions.assertEquals((int)12, (int)multimap.size());
        multimap.removeAll((Object)I2, (Object)I3);
        Assertions.assertEquals((int)9, (int)multimap.size());
        MapIterator it = multimap.mapIterator();
        while (it.hasNext()) {
            MultiKey key = (MultiKey)it.next();
            Assertions.assertFalse((I2.equals(key.getKey(0)) && I3.equals(key.getKey(1)) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiKeyRemoveAll3() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        Assertions.assertEquals((int)12, (int)multimap.size());
        multimap.removeAll((Object)I1, (Object)I1, (Object)I2);
        Assertions.assertEquals((int)9, (int)multimap.size());
        MapIterator it = multimap.mapIterator();
        while (it.hasNext()) {
            MultiKey key = (MultiKey)it.next();
            Assertions.assertFalse((I1.equals(key.getKey(0)) && I1.equals(key.getKey(1)) && I2.equals(key.getKey(2)) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiKeyRemoveAll4() {
        this.resetFull();
        MultiKeyMap<K, V> multimap = this.getMap();
        Assertions.assertEquals((int)12, (int)multimap.size());
        multimap.removeAll((Object)I1, (Object)I1, (Object)I2, (Object)I3);
        Assertions.assertEquals((int)10, (int)multimap.size());
        MapIterator it = multimap.mapIterator();
        while (it.hasNext()) {
            MultiKey key = (MultiKey)it.next();
            Assertions.assertFalse((I1.equals(key.getKey(0)) && I1.equals(key.getKey(1)) && I2.equals(key.getKey(2)) && key.size() >= 4 && I3.equals(key.getKey(3)) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNullHandling() {
        this.resetFull();
        Assertions.assertNull((Object)((IterableMap)this.map).get(null));
        Assertions.assertFalse((boolean)((IterableMap)this.map).containsKey(null));
        Assertions.assertFalse((boolean)((IterableMap)this.map).containsValue(null));
        Assertions.assertNull((Object)((IterableMap)this.map).remove(null));
        Assertions.assertFalse((boolean)((IterableMap)this.map).entrySet().contains(null));
        Assertions.assertFalse((boolean)((IterableMap)this.map).containsKey(null));
        Assertions.assertFalse((boolean)((IterableMap)this.map).containsValue(null));
        Assertions.assertThrows(NullPointerException.class, () -> ((IterableMap)this.map).put(null, null));
        Assertions.assertNull((Object)((IterableMap)this.map).put((Object)new MultiKey(null, null), null));
        Assertions.assertThrows(NullPointerException.class, () -> ((IterableMap)this.map).put(null, new Object()));
    }
}

