/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multiset;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMultiSetTest<T>
extends AbstractCollectionTest<T> {
    public BulkTest bulkTestMultiSetUniqueSet() {
        return new TestMultiSetUniqueSet();
    }

    @Override
    public MultiSet<T> getCollection() {
        return (MultiSet)super.getCollection();
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        Collection<T> coll = this.makeConfirmedCollection();
        coll.addAll(Arrays.asList(this.getFullElements()));
        return coll;
    }

    @Override
    public MultiSet<T> makeFullCollection() {
        MultiSet<T> multiset = this.makeObject();
        multiset.addAll(Arrays.asList(this.getFullElements()));
        return multiset;
    }

    @Override
    public abstract MultiSet<T> makeObject();

    @Override
    public void resetEmpty() {
        this.setCollection(this.makeObject());
        this.setConfirmed(this.makeConfirmedCollection());
    }

    @Override
    public void resetFull() {
        this.setCollection(this.makeFullCollection());
        this.setConfirmed(this.makeConfirmedFullCollection());
    }

    @Test
    public void testEmptyMultiSetCompatibility() throws IOException, ClassNotFoundException {
        MultiSet<T> multiset = this.makeObject();
        if (multiset instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            MultiSet multiset2 = (MultiSet)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(multiset));
            Assertions.assertTrue((boolean)multiset2.isEmpty(), (String)"MultiSet is empty");
            Assertions.assertEquals(multiset, (Object)multiset2);
        }
    }

    @Test
    public void testFullMultiSetCompatibility() throws IOException, ClassNotFoundException {
        MultiSet<T> multiset = this.makeFullCollection();
        if (multiset instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            MultiSet multiset2 = (MultiSet)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(multiset));
            Assertions.assertEquals((int)multiset.size(), (int)multiset2.size(), (String)"MultiSet is the right size");
            Assertions.assertEquals(multiset, (Object)multiset2);
        }
    }

    @Test
    public void testMultiSetAdd() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        Assertions.assertTrue((boolean)multiset.contains((Object)"A"), (String)"Should contain 'A'");
        Assertions.assertEquals((int)1, (int)multiset.getCount((Object)"A"), (String)"Should have count of 1");
        multiset.add((Object)"A");
        Assertions.assertTrue((boolean)multiset.contains((Object)"A"), (String)"Should contain 'A'");
        Assertions.assertEquals((int)2, (int)multiset.getCount((Object)"A"), (String)"Should have count of 2");
        multiset.add((Object)"B");
        Assertions.assertTrue((boolean)multiset.contains((Object)"A"));
        Assertions.assertTrue((boolean)multiset.contains((Object)"B"));
    }

    @Test
    public void testMultiSetContains() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        Assertions.assertFalse((boolean)multiset.contains((Object)"A"), (String)"MultiSet does not have at least 1 'A'");
        Assertions.assertFalse((boolean)multiset.contains((Object)"B"), (String)"MultiSet does not have at least 1 'B'");
        multiset.add((Object)"A");
        Assertions.assertTrue((boolean)multiset.contains((Object)"A"), (String)"MultiSet has at least 1 'A'");
        Assertions.assertFalse((boolean)multiset.contains((Object)"B"), (String)"MultiSet does not have at least 1 'B'");
        multiset.add((Object)"A");
        Assertions.assertTrue((boolean)multiset.contains((Object)"A"), (String)"MultiSet has at least 1 'A'");
        Assertions.assertFalse((boolean)multiset.contains((Object)"B"), (String)"MultiSet does not have at least 1 'B'");
        multiset.add((Object)"B");
        Assertions.assertTrue((boolean)multiset.contains((Object)"A"), (String)"MultiSet has at least 1 'A'");
        Assertions.assertTrue((boolean)multiset.contains((Object)"B"), (String)"MultiSet has at least 1 'B'");
    }

    @Test
    public void testMultiSetContainsAll() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        ArrayList known = new ArrayList();
        ArrayList<String> known1A = new ArrayList<String>();
        known1A.add("A");
        ArrayList<String> known2A = new ArrayList<String>();
        known2A.add("A");
        known2A.add("A");
        ArrayList<String> known1B = new ArrayList<String>();
        known1B.add("B");
        ArrayList<String> known1A1B = new ArrayList<String>();
        known1A1B.add("A");
        known1A1B.add("B");
        Assertions.assertTrue((boolean)multiset.containsAll(known), (String)"MultiSet containsAll of empty");
        Assertions.assertFalse((boolean)multiset.containsAll(known1A), (String)"MultiSet does not containsAll of 1 'A'");
        Assertions.assertFalse((boolean)multiset.containsAll(known2A), (String)"MultiSet does not containsAll of 2 'A'");
        Assertions.assertFalse((boolean)multiset.containsAll(known1B), (String)"MultiSet does not containsAll of 1 'B'");
        Assertions.assertFalse((boolean)multiset.containsAll(known1A1B), (String)"MultiSet does not containsAll of 1 'A' 1 'B'");
        multiset.add((Object)"A");
        Assertions.assertTrue((boolean)multiset.containsAll(known), (String)"MultiSet containsAll of empty");
        Assertions.assertTrue((boolean)multiset.containsAll(known1A), (String)"MultiSet containsAll of 1 'A'");
        Assertions.assertTrue((boolean)multiset.containsAll(known2A), (String)"MultiSet does not containsAll 'A'");
        Assertions.assertFalse((boolean)multiset.containsAll(known1B), (String)"MultiSet does not containsAll of 1 'B'");
        Assertions.assertFalse((boolean)multiset.containsAll(known1A1B), (String)"MultiSet does not containsAll of 1 'A' 1 'B'");
        multiset.add((Object)"A");
        Assertions.assertTrue((boolean)multiset.containsAll(known), (String)"MultiSet containsAll of empty");
        Assertions.assertTrue((boolean)multiset.containsAll(known1A), (String)"MultiSet containsAll of 1 'A'");
        Assertions.assertTrue((boolean)multiset.containsAll(known2A), (String)"MultiSet containsAll of 2 'A'");
        Assertions.assertFalse((boolean)multiset.containsAll(known1B), (String)"MultiSet does not containsAll of 1 'B'");
        Assertions.assertFalse((boolean)multiset.containsAll(known1A1B), (String)"MultiSet does not containsAll of 1 'A' 1 'B'");
        multiset.add((Object)"A");
        Assertions.assertTrue((boolean)multiset.containsAll(known), (String)"MultiSet containsAll of empty");
        Assertions.assertTrue((boolean)multiset.containsAll(known1A), (String)"MultiSet containsAll of 1 'A'");
        Assertions.assertTrue((boolean)multiset.containsAll(known2A), (String)"MultiSet containsAll of 2 'A'");
        Assertions.assertFalse((boolean)multiset.containsAll(known1B), (String)"MultiSet does not containsAll of 1 'B'");
        Assertions.assertFalse((boolean)multiset.containsAll(known1A1B), (String)"MultiSet does not containsAll of 1 'A' 1 'B'");
        multiset.add((Object)"B");
        Assertions.assertTrue((boolean)multiset.containsAll(known), (String)"MultiSet containsAll of empty");
        Assertions.assertTrue((boolean)multiset.containsAll(known1A), (String)"MultiSet containsAll of 1 'A'");
        Assertions.assertTrue((boolean)multiset.containsAll(known2A), (String)"MultiSet containsAll of 2 'A'");
        Assertions.assertTrue((boolean)multiset.containsAll(known1B), (String)"MultiSet containsAll of 1 'B'");
        Assertions.assertTrue((boolean)multiset.containsAll(known1A1B), (String)"MultiSet containsAll of 1 'A' 1 'B'");
    }

    @Test
    public void testMultiSetEntrySetUpdatedToZero() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        MultiSet.Entry entry = (MultiSet.Entry)multiset.entrySet().iterator().next();
        Assertions.assertEquals((int)2, (int)entry.getCount());
        multiset.remove((Object)"A");
        Assertions.assertEquals((int)1, (int)entry.getCount());
        multiset.remove((Object)"A");
        Assertions.assertEquals((int)0, (int)entry.getCount());
    }

    @Test
    public void testMultiSetEquals() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        MultiSet<T> multiset2 = this.makeObject();
        Assertions.assertTrue((boolean)multiset.equals(multiset2));
        multiset.add((Object)"A");
        Assertions.assertFalse((boolean)multiset.equals(multiset2));
        multiset2.add((Object)"A");
        Assertions.assertTrue((boolean)multiset.equals(multiset2));
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        multiset2.add((Object)"A");
        multiset2.add((Object)"B");
        multiset2.add((Object)"B");
        multiset2.add((Object)"C");
        Assertions.assertTrue((boolean)multiset.equals(multiset2));
    }

    @Test
    public void testMultiSetEqualsHashMultiSet() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        HashMultiSet multiset2 = new HashMultiSet();
        Assertions.assertTrue((boolean)multiset.equals((Object)multiset2));
        multiset.add((Object)"A");
        Assertions.assertFalse((boolean)multiset.equals((Object)multiset2));
        multiset2.add((Object)"A");
        Assertions.assertTrue((boolean)multiset.equals((Object)multiset2));
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        multiset2.add((Object)"A");
        multiset2.add((Object)"B");
        multiset2.add((Object)"B");
        multiset2.add((Object)"C");
        Assertions.assertTrue((boolean)multiset.equals((Object)multiset2));
    }

    @Test
    public void testMultiSetEqualsSelf() {
        MultiSet<T> multiset = this.makeObject();
        Assertions.assertEquals(multiset, multiset);
        if (!this.isAddSupported()) {
            return;
        }
        multiset.add((Object)"elt");
        Assertions.assertEquals(multiset, multiset);
        multiset.add((Object)"elt");
        Assertions.assertEquals(multiset, multiset);
        multiset.add((Object)"elt2");
        Assertions.assertEquals(multiset, multiset);
    }

    @Test
    public void testMultiSetHashCode() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        MultiSet<T> multiset2 = this.makeObject();
        Assertions.assertEquals((int)0, (int)multiset.hashCode());
        Assertions.assertEquals((int)0, (int)multiset2.hashCode());
        Assertions.assertEquals((int)multiset.hashCode(), (int)multiset2.hashCode());
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        multiset2.add((Object)"A");
        multiset2.add((Object)"A");
        multiset2.add((Object)"B");
        multiset2.add((Object)"B");
        multiset2.add((Object)"C");
        Assertions.assertEquals((int)multiset.hashCode(), (int)multiset2.hashCode());
        int total = 0;
        total += "A".hashCode() ^ 2;
        total += "B".hashCode() ^ 2;
        Assertions.assertEquals((int)(total += "C".hashCode() ^ 1), (int)multiset.hashCode());
        Assertions.assertEquals((int)total, (int)multiset2.hashCode());
    }

    @Test
    public void testMultiSetIterator() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        Assertions.assertEquals((int)3, (int)multiset.size(), (String)"MultiSet should have 3 items");
        Iterator i = multiset.iterator();
        boolean foundA = false;
        while (i.hasNext()) {
            String element = (String)i.next();
            if (!element.equals("A")) continue;
            if (!foundA) {
                foundA = true;
                continue;
            }
            i.remove();
        }
        Assertions.assertTrue((boolean)multiset.contains((Object)"A"), (String)"MultiSet should still contain 'A'");
        Assertions.assertEquals((int)2, (int)multiset.size(), (String)"MultiSet should have 2 items");
        Assertions.assertEquals((int)1, (int)multiset.getCount((Object)"A"), (String)"MultiSet should have 1 'A'");
    }

    @Test
    public void testMultiSetIteratorFail() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        Iterator it = multiset.iterator();
        it.next();
        multiset.remove((Object)"A");
        Assertions.assertThrows(ConcurrentModificationException.class, () -> it.next(), (String)"Should throw ConcurrentModificationException");
    }

    @Test
    public void testMultiSetIteratorFailDoubleRemove() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        Iterator it = multiset.iterator();
        it.next();
        it.next();
        Assertions.assertEquals((int)3, (int)multiset.size());
        it.remove();
        Assertions.assertEquals((int)2, (int)multiset.size());
        Assertions.assertThrows(IllegalStateException.class, () -> it.remove(), (String)"Should throw IllegalStateException");
        Assertions.assertEquals((int)2, (int)multiset.size());
        it.next();
        it.remove();
        Assertions.assertEquals((int)1, (int)multiset.size());
    }

    @Test
    public void testMultiSetIteratorFailNoMore() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        Iterator it = multiset.iterator();
        it.next();
        it.next();
        it.next();
        Assertions.assertThrows(NoSuchElementException.class, () -> it.next(), (String)"Should throw NoSuchElementException");
    }

    @Test
    public void testMultiSetIteratorRemoveProtectsInvariants() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        Assertions.assertEquals((int)2, (int)multiset.size());
        Iterator it = multiset.iterator();
        Assertions.assertEquals((Object)"A", it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        it.remove();
        Assertions.assertEquals((int)1, (int)multiset.size());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"A", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        it.remove();
        Assertions.assertEquals((int)0, (int)multiset.size());
        Assertions.assertFalse((boolean)it.hasNext());
        Iterator it2 = multiset.iterator();
        Assertions.assertFalse((boolean)it2.hasNext());
    }

    @Test
    public void testMultiSetRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        Assertions.assertEquals((int)1, (int)multiset.getCount((Object)"A"), (String)"Should have count of 1");
        multiset.remove((Object)"A");
        Assertions.assertEquals((int)0, (int)multiset.getCount((Object)"A"), (String)"Should have count of 0");
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        Assertions.assertEquals((int)4, (int)multiset.getCount((Object)"A"), (String)"Should have count of 4");
        multiset.remove((Object)"A", 0);
        Assertions.assertEquals((int)4, (int)multiset.getCount((Object)"A"), (String)"Should have count of 4");
        multiset.remove((Object)"A", 2);
        Assertions.assertEquals((int)2, (int)multiset.getCount((Object)"A"), (String)"Should have count of 2");
        multiset.remove((Object)"A");
        Assertions.assertEquals((int)1, (int)multiset.getCount((Object)"A"), (String)"Should have count of 1");
    }

    @Test
    public void testMultiSetRemoveAll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A", 2);
        Assertions.assertEquals((int)2, (int)multiset.getCount((Object)"A"), (String)"Should have count of 2");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        Assertions.assertEquals((int)4, (int)multiset.size(), (String)"Should have count of 4");
        ArrayList<String> delete = new ArrayList<String>();
        delete.add("A");
        delete.add("B");
        multiset.removeAll(delete);
        Assertions.assertEquals((int)0, (int)multiset.getCount((Object)"A"), (String)"Should have count of 0");
        Assertions.assertEquals((int)0, (int)multiset.getCount((Object)"B"), (String)"Should have count of 0");
        Assertions.assertEquals((int)1, (int)multiset.getCount((Object)"C"), (String)"Should have count of 1");
        Assertions.assertEquals((int)1, (int)multiset.size(), (String)"Should have count of 1");
    }

    @Test
    public void testMultiSetRetainAll() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        ArrayList<String> retains = new ArrayList<String>();
        retains.add("B");
        retains.add("C");
        multiset.retainAll(retains);
        Assertions.assertEquals((int)3, (int)multiset.size(), (String)"Should have 3 total items");
    }

    @Test
    public void testMultiSetSize() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        Assertions.assertEquals((int)0, (int)multiset.size(), (String)"Should have 0 total items");
        multiset.add((Object)"A");
        Assertions.assertEquals((int)1, (int)multiset.size(), (String)"Should have 1 total items");
        multiset.add((Object)"A");
        Assertions.assertEquals((int)2, (int)multiset.size(), (String)"Should have 2 total items");
        multiset.add((Object)"A");
        Assertions.assertEquals((int)3, (int)multiset.size(), (String)"Should have 3 total items");
        multiset.add((Object)"B");
        Assertions.assertEquals((int)4, (int)multiset.size(), (String)"Should have 4 total items");
        multiset.add((Object)"B");
        Assertions.assertEquals((int)5, (int)multiset.size(), (String)"Should have 5 total items");
        multiset.remove((Object)"A", 2);
        Assertions.assertEquals((int)1, (int)multiset.getCount((Object)"A"), (String)"Should have 1 'A'");
        Assertions.assertEquals((int)3, (int)multiset.size(), (String)"Should have 3 total items");
        multiset.remove((Object)"B");
        Assertions.assertEquals((int)2, (int)multiset.size(), (String)"Should have 2 total item");
    }

    @Test
    public void testMultiSetToArray() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        Object[] array = multiset.toArray();
        int a = 0;
        int b = 0;
        int c = 0;
        for (Object element : array) {
            a += element.equals("A") ? 1 : 0;
            b += element.equals("B") ? 1 : 0;
            c += element.equals("C") ? 1 : 0;
        }
        Assertions.assertEquals((int)2, (int)a);
        Assertions.assertEquals((int)2, (int)b);
        Assertions.assertEquals((int)1, (int)c);
    }

    @Test
    public void testMultiSetToArrayPopulate() {
        if (!this.isAddSupported()) {
            return;
        }
        MultiSet<T> multiset = this.makeObject();
        multiset.add((Object)"A");
        multiset.add((Object)"A");
        multiset.add((Object)"B");
        multiset.add((Object)"B");
        multiset.add((Object)"C");
        String[] array = (String[])multiset.toArray((Object[])ArrayUtils.EMPTY_STRING_ARRAY);
        int a = 0;
        int b = 0;
        int c = 0;
        for (String element : array) {
            a += element.equals("A") ? 1 : 0;
            b += element.equals("B") ? 1 : 0;
            c += element.equals("C") ? 1 : 0;
        }
        Assertions.assertEquals((int)2, (int)a);
        Assertions.assertEquals((int)2, (int)b);
        Assertions.assertEquals((int)1, (int)c);
    }

    public class TestMultiSetUniqueSet
    extends AbstractSetTest<T> {
        @Override
        public T[] getFullElements() {
            return AbstractMultiSetTest.this.getFullElements();
        }

        @Override
        protected int getIterationBehaviour() {
            return AbstractMultiSetTest.this.getIterationBehaviour();
        }

        @Override
        public T[] getOtherElements() {
            return AbstractMultiSetTest.this.getOtherElements();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isNullSupported() {
            return AbstractMultiSetTest.this.isNullSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return AbstractMultiSetTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public Set<T> makeFullCollection() {
            return AbstractMultiSetTest.this.makeFullCollection().uniqueSet();
        }

        @Override
        public Set<T> makeObject() {
            return AbstractMultiSetTest.this.makeObject().uniqueSet();
        }

        @Override
        public void resetEmpty() {
            AbstractMultiSetTest.this.resetEmpty();
            this.setCollection(AbstractMultiSetTest.this.getCollection().uniqueSet());
            this.setConfirmed(new HashSet(AbstractMultiSetTest.this.getConfirmed()));
        }

        @Override
        public void resetFull() {
            AbstractMultiSetTest.this.resetFull();
            this.setCollection(AbstractMultiSetTest.this.getCollection().uniqueSet());
            this.setConfirmed(new HashSet(AbstractMultiSetTest.this.getConfirmed()));
        }

        @Override
        public void verify() {
            super.verify();
        }
    }
}

