/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.properties;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.collections4.properties.AbstractPropertiesFactory;
import org.apache.commons.collections4.properties.PropertiesFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractPropertiesFactoryTest<T extends Properties> {
    private final AbstractPropertiesFactory<T> factory;

    public static Stream<Arguments> getParameters() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{".properties"}), Arguments.arguments((Object[])new Object[]{".xml"}));
    }

    protected AbstractPropertiesFactoryTest(AbstractPropertiesFactory<T> factory) {
        this.factory = factory;
    }

    private void assertContents(T properties) {
        Assertions.assertEquals((Object)"value1", (Object)((Properties)properties).getProperty("key1"));
        Assertions.assertEquals((Object)"value2", (Object)((Properties)properties).getProperty("key2"));
        Assertions.assertEquals((Object)"value3", (Object)((Properties)properties).getProperty("key3"));
        Assertions.assertEquals((Object)"value4", (Object)((Properties)properties).getProperty("key4"));
        Assertions.assertEquals((Object)"value5", (Object)((Properties)properties).getProperty("key5"));
        Assertions.assertEquals((Object)"value6", (Object)((Properties)properties).getProperty("key6"));
        Assertions.assertEquals((Object)"value7", (Object)((Properties)properties).getProperty("key7"));
        Assertions.assertEquals((Object)"value8", (Object)((Properties)properties).getProperty("key8"));
        Assertions.assertEquals((Object)"value9", (Object)((Properties)properties).getProperty("key9"));
        Assertions.assertEquals((Object)"value10", (Object)((Properties)properties).getProperty("key10"));
        Assertions.assertEquals((Object)"value11", (Object)((Properties)properties).getProperty("key11"));
    }

    private String getPathString(String fileExtension) {
        return "src/test/resources/org/apache/commons/collections4/properties/test" + fileExtension;
    }

    private boolean isXmlTest(String fileExtension) {
        return ".xml".equals(fileExtension);
    }

    @Test
    public void testInstance() {
        Assertions.assertNotNull((Object)PropertiesFactory.INSTANCE);
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testLoadClassLoaderMissingResource(String fileExtension) throws Exception {
        Assertions.assertNull((Object)this.factory.load(ClassLoader.getSystemClassLoader(), "missing/test" + fileExtension));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testLoadClassLoaderResource(String fileExtension) throws Exception {
        this.assertContents(this.factory.load(ClassLoader.getSystemClassLoader(), "org/apache/commons/collections4/properties/test" + fileExtension));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testLoadFile(String fileExtension) throws Exception {
        this.assertContents(this.factory.load(Paths.get(this.getPathString(fileExtension), new String[0]).toFile()));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testLoadFileName(String fileExtension) throws Exception {
        this.assertContents(this.factory.load(this.getPathString(fileExtension)));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testLoadInputStream(String fileExtension) throws Exception {
        Assumptions.assumeFalse((boolean)this.isXmlTest(fileExtension));
        try (InputStream inputStream = Files.newInputStream(Paths.get(this.getPathString(fileExtension), new String[0]), new OpenOption[0]);){
            this.assertContents(this.factory.load(inputStream));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testLoadPath(String fileExtension) throws Exception {
        this.assertContents(this.factory.load(Paths.get(this.getPathString(fileExtension), new String[0])));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testLoadReader(String fileExtension) throws Exception {
        Assumptions.assumeFalse((boolean)this.isXmlTest(fileExtension));
        try (BufferedReader inputStream = Files.newBufferedReader(Paths.get(this.getPathString(fileExtension), new String[0]));){
            this.assertContents(this.factory.load((Reader)inputStream));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testLoadUri(String fileExtension) throws Exception {
        this.assertContents(this.factory.load(Paths.get(this.getPathString(fileExtension), new String[0]).toUri()));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameters"})
    public void testLoadUrl(String fileExtension) throws Exception {
        this.assertContents(this.factory.load(Paths.get(this.getPathString(fileExtension), new String[0]).toUri().toURL()));
    }
}

