/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.queue.AbstractQueueTest;
import org.apache.commons.collections4.queue.UnmodifiableQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableQueueTest<E>
extends AbstractQueueTest<E> {
    @Override
    public Queue<E> getCollection() {
        return super.getCollection();
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new LinkedList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        return new LinkedList(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Queue<E> makeFullCollection() {
        LinkedList queue = new LinkedList(Arrays.asList(this.getFullElements()));
        return UnmodifiableQueue.unmodifiableQueue(queue);
    }

    @Override
    public Queue<E> makeObject() {
        return UnmodifiableQueue.unmodifiableQueue(new LinkedList());
    }

    @Test
    public void testDecorateFactory() {
        Collection queue = this.makeFullCollection();
        Assertions.assertSame((Object)queue, (Object)UnmodifiableQueue.unmodifiableQueue((Queue)queue));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableQueue.unmodifiableQueue(null));
    }

    @Test
    public void testOffer() {
        Collection queue = this.makeFullCollection();
        Object e = null;
        Assertions.assertThrows(UnsupportedOperationException.class, () -> UnmodifiableQueueTest.lambda$testOffer$1((Queue)queue, e));
    }

    @Test
    public void testPoll() {
        Collection queue = this.makeFullCollection();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> UnmodifiableQueueTest.lambda$testPoll$2((Queue)queue));
    }

    @Override
    @Test
    public void testQueueRemove() {
        this.resetEmpty();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.getCollection().remove());
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }

    private static /* synthetic */ void lambda$testPoll$2(Queue queue) throws Throwable {
        queue.poll();
    }

    private static /* synthetic */ void lambda$testOffer$1(Queue queue, Object e) throws Throwable {
        queue.offer(e);
    }
}

