/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.interpol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.DefaultLookups;
import org.apache.commons.configuration2.interpol.InterpolatorSpecification;
import org.apache.commons.configuration2.interpol.Lookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestConfigurationInterpolator {
    private static final String TEST_NAME = "varname";
    private static final String TEST_PREFIX = "prefix";
    private static final String TEST_VALUE = "TestVariableValue";
    private ConfigurationInterpolator interpolator;

    private static void assertMappedLookups(Map<String, Lookup> lookupMap, String ... keys) {
        HashSet<String> remainingKeys = new HashSet<String>(lookupMap.keySet());
        for (String key : keys) {
            Assertions.assertNotNull((Object)key, (String)("Expected map to contain string lookup for key " + key));
            remainingKeys.remove(key);
        }
        Assertions.assertEquals(Collections.emptySet(), remainingKeys);
    }

    private static void checkDefaultPrefixLookupsHolder(Properties props, String ... keys) {
        ConfigurationInterpolator.DefaultPrefixLookupsHolder holder = new ConfigurationInterpolator.DefaultPrefixLookupsHolder(props);
        Map lookupMap = holder.getDefaultPrefixLookups();
        TestConfigurationInterpolator.assertMappedLookups(lookupMap, keys);
    }

    public static void main(String[] args) {
        System.out.println("Default lookups");
        for (String key : ConfigurationInterpolator.getDefaultPrefixLookups().keySet()) {
            System.out.println("- " + key);
        }
    }

    private static Lookup setUpTestLookup() {
        return TestConfigurationInterpolator.setUpTestLookup(TEST_NAME, TEST_VALUE);
    }

    private static Lookup setUpTestLookup(String var, Object value) {
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        Mockito.when((Object)lookup.lookup((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            if (var.equals(invocation.getArgument(0))) {
                return value;
            }
            return null;
        });
        return lookup;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.interpolator = new ConfigurationInterpolator();
    }

    @Test
    void testAddDefaultLookups() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        lookups.add(TestConfigurationInterpolator.setUpTestLookup());
        lookups.add(TestConfigurationInterpolator.setUpTestLookup("test", "value"));
        this.interpolator.addDefaultLookups(lookups);
        List lookups2 = this.interpolator.getDefaultLookups();
        Assertions.assertEquals(lookups, (Object)lookups2);
    }

    @Test
    void testAddDefaultLookupsNull() {
        this.interpolator.addDefaultLookups(null);
        Assertions.assertTrue((boolean)this.interpolator.getDefaultLookups().isEmpty());
    }

    @Test
    void testDefaultStringLookupsHolderAllLookups() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.configuration2.interpol.ConfigurationInterpolator.defaultPrefixLookups", "BASE64_DECODER BASE64_ENCODER const, date, dns, environment file ,java, local_host properties, resource_bundle,script,system_properties url url_decoder  , url_encoder, xml");
        TestConfigurationInterpolator.checkDefaultPrefixLookupsHolder(props, "base64", "base64Decoder", "base64Encoder", "const", "date", "env", "file", "java", "localhost", "properties", "resourceBundle", "sys", "urlDecoder", "urlEncoder", "xml", "dns", "url", "script");
    }

    @Test
    void testDefaultStringLookupsHolderGivenSingleLookup() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.configuration2.interpol.ConfigurationInterpolator.defaultPrefixLookups", "base64_encoder");
        TestConfigurationInterpolator.checkDefaultPrefixLookupsHolder(props, "base64", "base64Encoder");
    }

    @Test
    void testDefaultStringLookupsHolderGivenSingleLookupWeirdString() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.configuration2.interpol.ConfigurationInterpolator.defaultPrefixLookups", " \n \t  ,, DnS , , ");
        TestConfigurationInterpolator.checkDefaultPrefixLookupsHolder(props, "dns");
    }

    @Test
    void testDefaultStringLookupsHolderInvalidLookupsDefinition() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.configuration2.interpol.ConfigurationInterpolator.defaultPrefixLookups", "base64_encoder nope");
        Exception exc = (Exception)Assertions.assertThrows(Exception.class, () -> new ConfigurationInterpolator.DefaultPrefixLookupsHolder(props));
        Assertions.assertEquals((Object)"Invalid default lookups definition: base64_encoder nope", (Object)exc.getMessage());
    }

    @Test
    void testDefaultStringLookupsHolderLookupsPropertyEmptyAndBlank() {
        Properties propsWithNull = new Properties();
        propsWithNull.setProperty("org.apache.commons.configuration2.interpol.ConfigurationInterpolator.defaultPrefixLookups", "");
        TestConfigurationInterpolator.checkDefaultPrefixLookupsHolder(propsWithNull, new String[0]);
        Properties propsWithBlank = new Properties();
        propsWithBlank.setProperty("org.apache.commons.configuration2.interpol.ConfigurationInterpolator.defaultPrefixLookups", " ");
        TestConfigurationInterpolator.checkDefaultPrefixLookupsHolder(propsWithBlank, new String[0]);
    }

    @Test
    void testDefaultStringLookupsHolderLookupsPropertyNotPresent() {
        TestConfigurationInterpolator.checkDefaultPrefixLookupsHolder(new Properties(), "base64", "base64Decoder", "base64Encoder", "const", "date", "env", "file", "java", "localhost", "properties", "resourceBundle", "sys", "urlDecoder", "urlEncoder", "xml");
    }

    @Test
    void testDefaultStringLookupsHolderMultipleLookups() {
        Properties props = new Properties();
        props.setProperty("org.apache.commons.configuration2.interpol.ConfigurationInterpolator.defaultPrefixLookups", "dns, url script ");
        TestConfigurationInterpolator.checkDefaultPrefixLookupsHolder(props, "dns", "url", "script");
    }

    @Test
    void testDeregisterLookup() {
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        this.interpolator.registerLookup(TEST_PREFIX, lookup);
        Assertions.assertTrue((boolean)this.interpolator.deregisterLookup(TEST_PREFIX));
        Assertions.assertFalse((boolean)this.interpolator.prefixSet().contains(TEST_PREFIX));
        Assertions.assertTrue((boolean)this.interpolator.getLookups().isEmpty());
    }

    @Test
    void testDeregisterLookupNonExisting() {
        Assertions.assertFalse((boolean)this.interpolator.deregisterLookup(TEST_PREFIX));
    }

    @Test
    void testEnableSubstitutionInVariables() {
        Assertions.assertFalse((boolean)this.interpolator.isEnableSubstitutionInVariables());
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("java.version", "1.4"));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("jre-1.4", "C:\\java\\1.4"));
        String var = "${jre-${java.version}}";
        Assertions.assertEquals((Object)"${jre-${java.version}}", (Object)this.interpolator.interpolate((Object)"${jre-${java.version}}"));
        this.interpolator.setEnableSubstitutionInVariables(true);
        Assertions.assertTrue((boolean)this.interpolator.isEnableSubstitutionInVariables());
        Assertions.assertEquals((Object)"C:\\java\\1.4", (Object)this.interpolator.interpolate((Object)"${jre-${java.version}}"));
    }

    @Test
    void testFromSpecificationInterpolator() {
        ConfigurationInterpolator ci = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        InterpolatorSpecification spec = new InterpolatorSpecification.Builder().withDefaultLookup((Lookup)Mockito.mock(Lookup.class)).withParentInterpolator(this.interpolator).withInterpolator(ci).create();
        Assertions.assertSame((Object)ci, (Object)ConfigurationInterpolator.fromSpecification((InterpolatorSpecification)spec));
    }

    @Test
    void testFromSpecificationNewInstance() {
        Lookup defLookup = (Lookup)Mockito.mock(Lookup.class);
        Lookup preLookup = (Lookup)Mockito.mock(Lookup.class);
        Function<Object, String> stringConverter = obj -> Objects.toString(obj, null);
        InterpolatorSpecification spec = new InterpolatorSpecification.Builder().withDefaultLookup(defLookup).withPrefixLookup("p", preLookup).withParentInterpolator(this.interpolator).withStringConverter(stringConverter).create();
        ConfigurationInterpolator ci = ConfigurationInterpolator.fromSpecification((InterpolatorSpecification)spec);
        Assertions.assertEquals(Arrays.asList(defLookup), (Object)ci.getDefaultLookups());
        Assertions.assertEquals((int)1, (int)ci.getLookups().size());
        Assertions.assertSame((Object)preLookup, ci.getLookups().get("p"));
        Assertions.assertSame((Object)this.interpolator, (Object)ci.getParentInterpolator());
        Assertions.assertSame(stringConverter, (Object)ci.getStringConverter());
    }

    @Test
    void testFromSpecificationNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConfigurationInterpolator.fromSpecification(null));
    }

    @Test
    void testGetDefaultLookupsModify() {
        List lookups = this.interpolator.getDefaultLookups();
        lookups.add(TestConfigurationInterpolator.setUpTestLookup());
        Assertions.assertTrue((boolean)this.interpolator.getDefaultLookups().isEmpty());
    }

    @Test
    void testGetDefaultPrefixLookups() {
        EnumSet<DefaultLookups> excluded = EnumSet.of(DefaultLookups.DNS, DefaultLookups.URL, DefaultLookups.SCRIPT);
        EnumSet<DefaultLookups> included = EnumSet.complementOf(excluded);
        Map lookups = ConfigurationInterpolator.getDefaultPrefixLookups();
        Assertions.assertEquals((int)included.size(), (int)lookups.size());
        for (DefaultLookups l : included) {
            Assertions.assertSame((Object)l.getLookup(), lookups.get(l.getPrefix()), (String)("Wrong entry for " + l));
        }
        for (DefaultLookups l : excluded) {
            Assertions.assertNull(lookups.get(l.getPrefix()), (String)("Unexpected entry for " + l));
        }
    }

    @Test
    void testGetDefaultPrefixLookupsModify() {
        Map lookups = ConfigurationInterpolator.getDefaultPrefixLookups();
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> lookups.put("test", lookup));
        Mockito.verifyNoInteractions((Object[])new Object[]{lookup});
    }

    @Test
    void testGetLookupsModify() {
        Map lookups = this.interpolator.getLookups();
        lookups.put(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assertions.assertTrue((boolean)this.interpolator.getLookups().isEmpty());
    }

    @Test
    void testInit() {
        Assertions.assertTrue((boolean)this.interpolator.getDefaultLookups().isEmpty());
        Assertions.assertTrue((boolean)this.interpolator.getLookups().isEmpty());
        Assertions.assertNull((Object)this.interpolator.getParentInterpolator());
        Assertions.assertNotNull((Object)this.interpolator.getStringConverter());
        Assertions.assertEquals((Object)"1", this.interpolator.getStringConverter().apply(Arrays.asList(1, 2)));
    }

    @Test
    void testInterpolateArray() {
        int[] value = new int[]{1, 2};
        Assertions.assertSame((Object)value, (Object)this.interpolator.interpolate((Object)value));
    }

    @Test
    void testInterpolateBlankVariable() {
        String value = "${ }";
        Assertions.assertEquals((Object)"${ }", (Object)this.interpolator.interpolate((Object)"${ }"));
    }

    @Test
    void testInterpolateCollection() {
        List<Integer> value = Arrays.asList(1, 2);
        Assertions.assertSame(value, (Object)this.interpolator.interpolate(value));
    }

    @Test
    void testInterpolateEmptyVariable() {
        String value = "${}";
        Assertions.assertEquals((Object)"${}", (Object)this.interpolator.interpolate((Object)"${}"));
    }

    @Test
    void testInterpolateObject() {
        Integer value = 42;
        Assertions.assertSame((Object)value, (Object)this.interpolator.interpolate((Object)value));
    }

    @Test
    void testInterpolateString() {
        String value = "${prefix:varname}";
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.interpolator.interpolate((Object)"${prefix:varname}"));
    }

    @Test
    void testInterpolateStringUnknownVariable() {
        String value = "${unknownVariable}";
        Assertions.assertEquals((Object)"${unknownVariable}", (Object)this.interpolator.interpolate((Object)"${unknownVariable}"));
    }

    @Test
    void testInterpolationBeginningAndEndingRiskyVariableLookups() {
        this.interpolator.registerLookups(ConfigurationInterpolator.getDefaultPrefixLookups());
        String result = (String)this.interpolator.interpolate((Object)"${date:yyyy-MM}-${date:dd}");
        Assertions.assertTrue((boolean)result.matches("\\d{4}-\\d{2}-\\d{2}"));
    }

    @Test
    void testInterpolationMultipleArrayVariables() {
        String value = "${single}bc${multi}23${empty}${null}";
        int[] multi = new int[]{1, 0, 0};
        String[] single = new String[]{"a"};
        int[] empty = new int[]{};
        Object[] containsNull = new Object[]{null};
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("multi", multi));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("single", single));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("empty", empty));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("null", containsNull));
        Assertions.assertEquals((Object)"abc123${empty}${null}", (Object)this.interpolator.interpolate((Object)"${single}bc${multi}23${empty}${null}"));
    }

    @Test
    void testInterpolationMultipleCollectionVariables() {
        String value = "${single}bc${multi}23${empty}${null}${multiIt}${emptyIt}${nullIt}";
        List<Integer> multi = Arrays.asList(1, 0, 0);
        List<String> single = Arrays.asList("a");
        List empty = Collections.emptyList();
        List<Object> containsNull = Arrays.asList(new Object[]{null});
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("multi", multi));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("multiIt", multi.iterator()));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("single", single));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("empty", empty));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("emptyIt", empty.iterator()));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("null", containsNull));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("nullIt", containsNull.iterator()));
        Assertions.assertEquals((Object)"abc123${empty}${null}1${emptyIt}${nullIt}", (Object)this.interpolator.interpolate((Object)"${single}bc${multi}23${empty}${null}${multiIt}${emptyIt}${nullIt}"));
    }

    @Test
    void testInterpolationMultipleSimpleNonStringVariables() {
        String value = "${x} = ${y} is ${result}";
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("x", 1));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("y", 2));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("result", false));
        Assertions.assertEquals((Object)"1 = 2 is false", (Object)this.interpolator.interpolate((Object)"${x} = ${y} is ${result}"));
    }

    @Test
    void testInterpolationMultipleVariables() {
        String value = "The ${subject} jumps over ${object}.";
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("subject", "quick brown fox"));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("object", "the lazy dog"));
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)this.interpolator.interpolate((Object)"The ${subject} jumps over ${object}."));
    }

    @Test
    void testInterpolationSingleArrayVariable() {
        int[] value = new int[]{42, -1};
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup(TEST_NAME, value));
        Assertions.assertEquals((Object)value, (Object)this.interpolator.interpolate((Object)"${varname}"));
    }

    @Test
    void testInterpolationSingleCollectionVariable() {
        List<Integer> value = Arrays.asList(42);
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup(TEST_NAME, value));
        Assertions.assertEquals(value, (Object)this.interpolator.interpolate((Object)"${varname}"));
    }

    @Test
    void testInterpolationSingleVariable() {
        Integer value = 42;
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup(TEST_NAME, value));
        Assertions.assertEquals((Object)value, (Object)this.interpolator.interpolate((Object)"${varname}"));
    }

    @Test
    void testInterpolationSingleVariableDefaultValue() {
        Integer value = 42;
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup(TEST_NAME, value));
        Assertions.assertEquals((Object)"${I_am_not_defined}", (Object)this.interpolator.interpolate((Object)"${I_am_not_defined}"));
        Assertions.assertEquals((Object)"42", (Object)this.interpolator.interpolate((Object)"${I_am_not_defined:-42}"));
        Assertions.assertEquals((Object)"", (Object)this.interpolator.interpolate((Object)"${I_am_not_defined:-}"));
    }

    @Test
    void testInterpolationVariableIncomplete() {
        String value = "${varname";
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup(TEST_NAME, "someValue"));
        Assertions.assertEquals((Object)"${varname", (Object)this.interpolator.interpolate((Object)"${varname"));
    }

    @Test
    void testNullSafeLookupExisting() {
        Lookup look = (Lookup)Mockito.mock(Lookup.class);
        Assertions.assertSame((Object)look, (Object)ConfigurationInterpolator.nullSafeLookup((Lookup)look));
    }

    @Test
    void testNullSafeLookupNull() {
        Lookup lookup = ConfigurationInterpolator.nullSafeLookup(null);
        Assertions.assertNull((Object)lookup.lookup("someVar"));
    }

    @Test
    void testPrefixSetModify() {
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Iterator it = this.interpolator.prefixSet().iterator();
        it.next();
        Assertions.assertThrows(UnsupportedOperationException.class, it::remove);
    }

    @Test
    void testRegisterLookup() {
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        this.interpolator.registerLookup(TEST_PREFIX, lookup);
        Assertions.assertSame((Object)lookup, this.interpolator.getLookups().get(TEST_PREFIX));
        Assertions.assertTrue((boolean)this.interpolator.prefixSet().contains(TEST_PREFIX));
        Assertions.assertTrue((boolean)this.interpolator.getDefaultLookups().isEmpty());
    }

    @Test
    void testRegisterLookupNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.interpolator.registerLookup(TEST_PREFIX, null));
    }

    @Test
    void testRegisterLookupNullPrefix() {
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.interpolator.registerLookup(null, lookup));
        Mockito.verifyNoInteractions((Object[])new Object[]{lookup});
    }

    @Test
    void testRegisterLookups() {
        Lookup l1 = TestConfigurationInterpolator.setUpTestLookup();
        Lookup l2 = TestConfigurationInterpolator.setUpTestLookup("someVar", "someValue");
        HashMap<String, Lookup> lookups = new HashMap<String, Lookup>();
        lookups.put(TEST_PREFIX, l1);
        String prefix2 = "prefix_other";
        lookups.put("prefix_other", l2);
        this.interpolator.registerLookups(lookups);
        Map lookups2 = this.interpolator.getLookups();
        HashMap<String, Lookup> expected = new HashMap<String, Lookup>();
        expected.put(TEST_PREFIX, l1);
        expected.put("prefix_other", l2);
        Assertions.assertEquals(expected, (Object)lookups2);
    }

    @Test
    void testRegisterLookupsNull() {
        this.interpolator.registerLookups(null);
        Assertions.assertTrue((boolean)this.interpolator.getLookups().isEmpty());
    }

    @Test
    void testRemoveDefaultLookup() {
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        lookups.add(TestConfigurationInterpolator.setUpTestLookup());
        lookups.add(TestConfigurationInterpolator.setUpTestLookup("test", "value"));
        this.interpolator.addDefaultLookups(lookups);
        Assertions.assertTrue((boolean)this.interpolator.removeDefaultLookup((Lookup)lookups.get(0)));
        Assertions.assertFalse((boolean)this.interpolator.getDefaultLookups().contains(lookups.get(0)));
        Assertions.assertEquals((int)1, (int)this.interpolator.getDefaultLookups().size());
    }

    @Test
    void testRemoveDefaultLookupNonExisting() {
        Assertions.assertFalse((boolean)this.interpolator.removeDefaultLookup(TestConfigurationInterpolator.setUpTestLookup()));
    }

    @Test
    void testResolveDefault() {
        Lookup l1 = (Lookup)Mockito.mock(Lookup.class);
        Lookup l2 = (Lookup)Mockito.mock(Lookup.class);
        Lookup l3 = (Lookup)Mockito.mock(Lookup.class);
        Mockito.when((Object)l1.lookup(TEST_NAME)).thenReturn(null);
        Mockito.when((Object)l2.lookup(TEST_NAME)).thenReturn((Object)TEST_VALUE);
        this.interpolator.addDefaultLookups(Arrays.asList(l1, l2, l3));
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.interpolator.resolve(TEST_NAME));
        ((Lookup)Mockito.verify((Object)l1)).lookup(TEST_NAME);
        ((Lookup)Mockito.verify((Object)l2)).lookup(TEST_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{l1, l2, l3});
    }

    @Test
    void testResolveDefaultAfterPrefixFails() {
        String varName = "prefix:varname2";
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("prefix:varname2", TEST_VALUE));
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.interpolator.resolve("prefix:varname2"));
    }

    @Test
    void testResolveDefaultEmptyVarName() {
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("", TEST_VALUE));
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.interpolator.resolve(""));
    }

    @Test
    void testResolveEmptyPrefix() {
        this.interpolator.registerLookup("", TestConfigurationInterpolator.setUpTestLookup());
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.interpolator.resolve(":varname"));
    }

    @Test
    void testResolveEmptyVarName() {
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup("", TEST_VALUE));
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.interpolator.resolve("prefix:"));
    }

    @Test
    void testResolveNoDefault() {
        Assertions.assertNull((Object)this.interpolator.resolve(TEST_NAME));
    }

    @Test
    void testResolveNull() {
        Assertions.assertNull((Object)this.interpolator.resolve(null));
    }

    @Test
    void testResolveParentVariableFound() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        this.interpolator.setParentInterpolator(parent);
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.interpolator.resolve("prefix:varname"));
    }

    @Test
    void testResolveParentVariableNotFound() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        Mockito.when((Object)parent.resolve(TEST_NAME)).thenReturn((Object)TEST_VALUE);
        this.interpolator.setParentInterpolator(parent);
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.interpolator.resolve(TEST_NAME));
        ((ConfigurationInterpolator)Mockito.verify((Object)parent)).resolve(TEST_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{parent});
    }

    @Test
    void testResolveWithPrefix() {
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assertions.assertEquals((Object)TEST_VALUE, (Object)this.interpolator.resolve("prefix:varname"));
    }

    @Test
    void testResolveWithUnknownPrefix() {
        this.interpolator.registerLookup(TEST_PREFIX, TestConfigurationInterpolator.setUpTestLookup());
        Assertions.assertNull((Object)this.interpolator.resolve("UnknownPrefix:varname"));
        Assertions.assertNull((Object)this.interpolator.resolve(":varname"));
    }

    @Test
    void testSetStringConverter() {
        Function<Object, String> stringConverter = obj -> "'" + obj + "'";
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("x", Arrays.asList(1, 2)));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("y", "abc"));
        this.interpolator.setStringConverter(stringConverter);
        Assertions.assertSame(stringConverter, (Object)this.interpolator.getStringConverter());
        Assertions.assertEquals((Object)"'abc': '[1, 2]'", (Object)this.interpolator.interpolate((Object)"${y}: ${x}"));
    }

    @Test
    void testSetStringConverterNullArgumentUsesDefault() {
        Function<Object, String> stringConverter = obj -> "'" + obj + "'";
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("x", Arrays.asList(1, 2)));
        this.interpolator.addDefaultLookup(TestConfigurationInterpolator.setUpTestLookup("y", "abc"));
        this.interpolator.setStringConverter(stringConverter);
        this.interpolator.setStringConverter(null);
        Assertions.assertNotSame(stringConverter, (Object)this.interpolator.getStringConverter());
        Assertions.assertEquals((Object)"abc: 1", (Object)this.interpolator.interpolate((Object)"${y}: ${x}"));
    }
}

