/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AssignTest
extends JexlTestCase {
    public AssignTest() {
        super("AssignTest", new JexlBuilder().cache(512).strict(true).silent(false).create());
    }

    @Test
    void testAmbiguous() {
        JexlExpression assign = this.JEXL.createExpression("froboz.nosuchbean = 10");
        MapContext jc = new MapContext();
        Froboz froboz = new Froboz(-169);
        jc.set("froboz", (Object)froboz);
        RuntimeException xrt = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> AssignTest.lambda$testAmbiguous$0(assign, (JexlContext)jc));
        Assertions.assertTrue((boolean)xrt.toString().contains("nosuchbean"));
    }

    @Test
    void testAntish() {
        JexlExpression assign = this.JEXL.createExpression("froboz.value = 10");
        JexlExpression check = this.JEXL.createExpression("froboz.value");
        MapContext jc = new MapContext();
        Object o = assign.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testAntishInteger() {
        JexlExpression assign = this.JEXL.createExpression("froboz.0 = 10");
        JexlExpression check = this.JEXL.createExpression("froboz.0");
        MapContext jc = new MapContext();
        Object o = assign.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testArray() {
        JexlExpression assign = this.JEXL.createExpression("froboz[\"value\"] = 10");
        JexlExpression check = this.JEXL.createExpression("froboz[\"value\"]");
        MapContext jc = new MapContext();
        Froboz froboz = new Froboz(0);
        jc.set("froboz", (Object)froboz);
        Object o = assign.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testBeanish() {
        JexlExpression assign = this.JEXL.createExpression("froboz.value = 10");
        JexlExpression check = this.JEXL.createExpression("froboz.value");
        MapContext jc = new MapContext();
        Froboz froboz = new Froboz(-169);
        jc.set("froboz", (Object)froboz);
        Object o = assign.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testGetInError1() {
        JexlException.Property e = (JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> this.JEXL.getProperty((Object)"the_x_value", "y"));
        Assertions.assertEquals((Object)"y", (Object)e.getProperty());
        Assertions.assertThrows(JexlException.class, () -> this.JEXL.getProperty(null, "y"));
    }

    @Test
    void testMini() {
        MapContext jc = new MapContext();
        JexlExpression assign = this.JEXL.createExpression("quux = 10");
        Object o = assign.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testMore() {
        MapContext jc = new MapContext();
        jc.set("quuxClass", Quux.class);
        JexlExpression create = this.JEXL.createExpression("quux = new(quuxClass, 'xuuq', 100)");
        JexlExpression assign = this.JEXL.createExpression("quux.froboz.value = 10");
        JexlExpression check = this.JEXL.createExpression("quux[\"froboz\"].value");
        Quux quux = (Quux)create.evaluate((JexlContext)jc);
        Assertions.assertNotNull((Object)quux, (String)"quux is null");
        Object o = assign.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
        o = check.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testPropertyInError0() {
        for (String op : Arrays.asList(" = ", "+= ", " -= ", " *= ", " /= ", " %= ", " &= ", " |= ", " ^= ", " <<= ", " >>= ", " >>>= ")) {
            JexlScript script = this.JEXL.createScript("x -> x.y " + op + "42");
            JexlException.Property xprop = (JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> script.execute(null, new Object[]{"the_x_value"}));
            Assertions.assertEquals((Object)"y", (Object)xprop.getProperty());
        }
        JexlScript script = this.JEXL.createScript("x -> x.y ");
        JexlException.Property xprop = (JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> script.execute(null, new Object[]{"the_x_value"}));
        Assertions.assertEquals((Object)"y", (Object)xprop.getProperty());
    }

    @Test
    void testRejectLocal() {
        MapContext jc = new MapContext();
        JexlScript assign = this.JEXL.createScript("var quux = null; quux.froboz.value = 10");
        Assertions.assertNotNull((Object)((JexlException)Assertions.assertThrows(JexlException.class, () -> AssignTest.lambda$testRejectLocal$0(assign, (JexlContext)jc))).toString());
        JexlScript assign2 = this.JEXL.createScript("quux.froboz.value = 10");
        Object o = assign2.execute((JexlContext)jc);
        Assertions.assertEquals((Object)10, (Object)o);
    }

    @Test
    void testSetInError1() {
        JexlException.Property xprop = (JexlException.Property)Assertions.assertThrows(JexlException.Property.class, () -> this.JEXL.setProperty((Object)"the_x_value", "y", (Object)42));
        Assertions.assertEquals((Object)"y", (Object)xprop.getProperty());
        Assertions.assertThrows(JexlException.Property.class, () -> this.JEXL.setProperty(null, "y", (Object)42));
    }

    @Test
    void testUtil() {
        Quux quux = (Quux)this.JEXL.newInstance(Quux.class, new Object[]{"xuuq", 100});
        Assertions.assertNotNull((Object)quux);
        this.JEXL.setProperty((Object)quux, "froboz.value", (Object)100);
        Object o = this.JEXL.getProperty((Object)quux, "froboz.value");
        Assertions.assertEquals((Object)100, (Object)o);
        this.JEXL.setProperty((Object)quux, "['froboz'].value", (Object)1000);
        o = this.JEXL.getProperty((Object)quux, "['froboz']['value']");
        Assertions.assertEquals((Object)1000, (Object)o);
    }

    private static /* synthetic */ void lambda$testRejectLocal$0(JexlScript assign, JexlContext jc) throws Throwable {
        assign.execute(jc);
    }

    private static /* synthetic */ void lambda$testAmbiguous$0(JexlExpression assign, JexlContext jc) throws Throwable {
        assign.evaluate(jc);
    }

    public static class Froboz {
        int value;

        public Froboz(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int v) {
            this.value = v;
        }
    }

    public static class Quux {
        String str;
        Froboz froboz;

        public Quux(String str, int fro) {
            this.str = str;
            this.froboz = new Froboz(fro);
        }

        public Froboz getFroboz() {
            return this.froboz;
        }

        public String getStr() {
            return this.str;
        }

        public void setFroboz(Froboz froboz) {
            this.froboz = froboz;
        }

        public void setStr(String str) {
            this.str = str;
        }
    }
}

