/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.junit.Asserter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BitwiseOperatorTest
extends JexlTestCase {
    private Asserter asserter;

    public BitwiseOperatorTest() {
        super("BitwiseOperatorTest");
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
        this.asserter.setStrict(false, false);
    }

    @Test
    void testAndSimple() throws Exception {
        this.asserter.assertExpression("15 & 3", 3L, new Object[0]);
    }

    @Test
    void testAndVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", 15);
        this.asserter.setVariable("y", (short)7);
        this.asserter.assertExpression("x & y", 7L, new Object[0]);
    }

    @Test
    void testAndVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", 15);
        this.asserter.setVariable("y", "7");
        this.asserter.assertExpression("x & y", 7L, new Object[0]);
    }

    @Test
    void testAndWithLeftNull() throws Exception {
        this.asserter.assertExpression("null & 1", 0L, new Object[0]);
    }

    @Test
    void testAndWithRightNull() throws Exception {
        this.asserter.assertExpression("1 & null", 0L, new Object[0]);
    }

    @Test
    void testAndWithTwoNulls() throws Exception {
        this.asserter.assertExpression("null & null", 0L, new Object[0]);
    }

    @Test
    void testComplementSimple() throws Exception {
        this.asserter.assertExpression("~128", -129L, new Object[0]);
    }

    @Test
    void testComplementVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", 15);
        this.asserter.assertExpression("~x", -16L, new Object[0]);
    }

    @Test
    void testComplementVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", "15");
        this.asserter.assertExpression("~x", -16L, new Object[0]);
    }

    @Test
    void testComplementWithNull() throws Exception {
        this.asserter.assertExpression("~null", -1L, new Object[0]);
    }

    @Test
    void testOrSimple() throws Exception {
        this.asserter.assertExpression("12 | 3", 15L, new Object[0]);
    }

    @Test
    void testOrVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", 12);
        this.asserter.setVariable("y", (short)3);
        this.asserter.assertExpression("x | y", 15L, new Object[0]);
    }

    @Test
    void testOrVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", 12);
        this.asserter.setVariable("y", "3");
        this.asserter.assertExpression("x | y", 15L, new Object[0]);
    }

    @Test
    void testOrWithLeftNull() throws Exception {
        this.asserter.assertExpression("null | 1", 1L, new Object[0]);
    }

    @Test
    void testOrWithRightNull() throws Exception {
        this.asserter.assertExpression("1 | null", 1L, new Object[0]);
    }

    @Test
    void testOrWithTwoNulls() throws Exception {
        this.asserter.assertExpression("null | null", 0L, new Object[0]);
    }

    @Test
    void testParenthesized() throws Exception {
        this.asserter.assertExpression("(2 | 1) & 3", 3L, new Object[0]);
        this.asserter.assertExpression("(2 & 1) | 3", 3L, new Object[0]);
        this.asserter.assertExpression("~(120 | 42)", -123L, new Object[0]);
    }

    @Test
    void testXorSimple() throws Exception {
        this.asserter.assertExpression("1 ^ 3", 2L, new Object[0]);
    }

    @Test
    void testXorVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", 1);
        this.asserter.setVariable("y", (short)3);
        this.asserter.assertExpression("x ^ y", 2L, new Object[0]);
    }

    @Test
    void testXorVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", 1);
        this.asserter.setVariable("y", "3");
        this.asserter.assertExpression("x ^ y", 2L, new Object[0]);
    }

    @Test
    void testXorWithLeftNull() throws Exception {
        this.asserter.assertExpression("null ^ 1", 1L, new Object[0]);
    }

    @Test
    void testXorWithRightNull() throws Exception {
        this.asserter.assertExpression("1 ^ null", 1L, new Object[0]);
    }

    @Test
    void testXorWithTwoNulls() throws Exception {
        this.asserter.assertExpression("null ^ null", 0L, new Object[0]);
    }
}

