/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.AccelMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AccelMgrImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class AccelMgrFactory {
    private static final String CLS_NM = AccelMgrFactory.class.getName();

    public static AccelMgr createInstance() throws SecurityException {
        return AccelMgrFactory.createInstance("HOME");
    }

    public static AccelMgr createInstance(String contextId) throws SecurityException {
        String accelClassName = Config.getInstance().getProperty("accelmgr.implementation");
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        AccelMgr accelMgr = StringUtils.isEmpty((String)accelClassName) ? new AccelMgrImpl() : (AccelMgr)ClassUtil.createInstance(accelClassName);
        accelMgr.setContextId(contextId);
        return accelMgr;
    }
}

