/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AdminRoleDAO;
import org.apache.directory.fortress.core.impl.OrgUnitP;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.util.ConstraintValidator;
import org.apache.directory.fortress.core.util.VUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AdminRoleP {
    private static final String CLS_NM = AdminRoleP.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private AdminRoleDAO rDao = new AdminRoleDAO();
    private OrgUnitP op = new OrgUnitP();
    private static final ConstraintValidator constraintValidator = VUtil.getConstraintValidator();

    AdminRoleP() {
    }

    AdminRole read(AdminRole adminRole) throws SecurityException {
        return this.rDao.getRole(adminRole);
    }

    List<AdminRole> search(AdminRole adminRole) throws SecurityException {
        return this.rDao.findRoles(adminRole);
    }

    List<String> search(AdminRole adminRole, int limit) throws SecurityException {
        return this.rDao.findRoles(adminRole, limit);
    }

    List<Graphable> getAllDescendants(String contextId) throws SecurityException {
        return this.rDao.getAllDescendants(contextId);
    }

    AdminRole add(AdminRole entity) throws SecurityException {
        this.validate(entity);
        return this.rDao.create(entity);
    }

    AdminRole update(AdminRole entity) throws SecurityException {
        this.validate(entity);
        AdminRole updateEntity = this.rDao.update(entity);
        return this.read(updateEntity);
    }

    void deleteParent(AdminRole entity) throws SecurityException {
        this.validate(entity);
        this.rDao.deleteParent(entity);
    }

    AdminRole assign(AdminRole entity, String userDn) throws SecurityException {
        return this.rDao.assign(entity, userDn);
    }

    void addOccupant(List<UserAdminRole> uRoles, String userDn, String contextId) throws SecurityException {
        if (CollectionUtils.isNotEmpty(uRoles)) {
            for (UserAdminRole uRole : uRoles) {
                AdminRole role = new AdminRole(uRole.getName());
                role.setContextId(contextId);
                this.assign(role, userDn);
            }
        }
    }

    void removeOccupant(String userDn, String contextId) throws SecurityException {
        try {
            List<String> list = this.rDao.findAssignedRoles(userDn, contextId);
            for (String roleNm : list) {
                AdminRole role = new AdminRole(roleNm);
                role.setContextId(contextId);
                this.deassign(role, userDn);
            }
        }
        catch (FinderException fe) {
            String error = "removeOccupant userDn [" + userDn + "] caught FinderException=" + fe;
            throw new SecurityException(9027, error, fe);
        }
    }

    AdminRole deassign(AdminRole entity, String userDn) throws SecurityException {
        return this.rDao.deassign(entity, userDn);
    }

    void delete(AdminRole entity) throws SecurityException {
        try {
            this.rDao.remove(entity);
        }
        catch (RemoveException re) {
            String error = "delete name [" + entity.getName() + "] caught RemoveException=" + re;
            LOG.error(error);
            throw new SecurityException(9004, error, re);
        }
    }

    private void validate(AdminRole entity) throws SecurityException {
        VUtil.safeText(entity.getName(), 40);
        if (StringUtils.isNotEmpty((String)entity.getBeginRange()) && StringUtils.isNotEmpty((String)entity.getEndRange())) {
            VUtil.safeText(entity.getBeginRange(), 40);
            VUtil.safeText(entity.getEndRange(), 40);
            if (!(!entity.getBeginRange().equalsIgnoreCase(entity.getEndRange()) || entity.isBeginInclusive() && entity.isEndInclusive())) {
                String error = "validate invalid range detected for role name [" + entity.getName() + "] non inclusive endpoint for identical range [" + entity.getBeginRange() + "] begin inclusive [" + entity.isBeginInclusive() + "] end inclusive [" + entity.isEndInclusive() + "]";
                LOG.warn(error);
                throw new SecurityException(9013, error);
            }
            if (!RoleUtil.getInstance().isParent(entity.getBeginRange(), entity.getEndRange(), entity.getContextId()) && !entity.getBeginRange().equalsIgnoreCase(entity.getEndRange())) {
                String error = "validate invalid range detected for role name [" + entity.getName() + "] begin range [" + entity.getBeginRange() + "] end range [" + entity.getEndRange() + "]";
                LOG.warn(error);
                throw new SecurityException(9012, error);
            }
        } else {
            if (StringUtils.isEmpty((String)entity.getBeginRange()) && StringUtils.isNotEmpty((String)entity.getEndRange())) {
                String error = "validate role name [" + entity.getName() + "] begin range value null or empty.";
                LOG.warn(error);
                throw new SecurityException(9011, error);
            }
            if (StringUtils.isNotEmpty((String)entity.getBeginRange()) && StringUtils.isEmpty((String)entity.getEndRange())) {
                String error = "validate role name [" + entity.getName() + "] end range value null or empty.";
                LOG.warn(error);
                throw new SecurityException(9029, error);
            }
        }
        if (StringUtils.isNotEmpty((String)entity.getDescription())) {
            VUtil.description(entity.getDescription());
        }
        if (entity.getTimeout() >= 0) {
            constraintValidator.timeout(entity.getTimeout());
        }
        if (StringUtils.isNotEmpty((String)entity.getBeginTime())) {
            constraintValidator.beginTime(entity.getBeginTime());
        }
        if (StringUtils.isNotEmpty((String)entity.getEndTime())) {
            constraintValidator.endTime(entity.getEndTime());
        }
        if (StringUtils.isNotEmpty((String)entity.getBeginDate())) {
            constraintValidator.beginDate(entity.getBeginDate());
        }
        if (StringUtils.isNotEmpty((String)entity.getEndDate())) {
            constraintValidator.endDate(entity.getEndDate());
        }
        if (StringUtils.isNotEmpty((String)entity.getDayMask())) {
            constraintValidator.dayMask(entity.getDayMask());
        }
        if (StringUtils.isNotEmpty((String)entity.getBeginLockDate())) {
            constraintValidator.beginDate(entity.getBeginDate());
        }
        if (StringUtils.isNotEmpty((String)entity.getEndLockDate())) {
            constraintValidator.endDate(entity.getEndLockDate());
        }
        if (CollectionUtils.isNotEmpty(entity.getOsUSet())) {
            this.validateOrgs(entity.getOsUSet(), OrgUnit.Type.USER, entity.getContextId());
        }
        if (CollectionUtils.isNotEmpty(entity.getOsPSet())) {
            this.validateOrgs(entity.getOsPSet(), OrgUnit.Type.PERM, entity.getContextId());
        }
    }

    private void validateOrgs(Set<String> orgs, OrgUnit.Type type, String contextId) throws SecurityException {
        for (String ou : orgs) {
            OrgUnit inOe = new OrgUnit(ou);
            inOe.setType(type);
            inOe.setContextId(contextId);
            this.op.read(inOe);
        }
    }
}

