/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.AdminUtil;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.VUtil;

public abstract class Manageable
implements org.apache.directory.fortress.core.Manageable {
    protected Session adminSess;
    protected String contextId;

    @Override
    public final void setAdmin(Session session) {
        this.adminSess = session;
    }

    @Override
    public final void setContextId(String contextId) {
        this.contextId = contextId;
    }

    protected final void setEntitySession(String className, String opName, FortEntity entity) throws SecurityException {
        entity.setContextId(this.contextId);
        if (this.adminSess != null) {
            Permission perm = new Permission(className, opName);
            perm.setContextId(this.contextId);
            AdminUtil.setEntitySession(this.adminSess, perm, entity, this.contextId);
        }
    }

    protected final void checkAccess(String className, String opName) throws SecurityException {
        if (this.adminSess != null) {
            Permission perm = new Permission(className, opName);
            perm.setContextId(this.contextId);
            AdminUtil.checkAccess(this.adminSess, perm, this.contextId);
        }
    }

    protected final void setAdminData(String className, String opName, FortEntity entity) {
        if (this.adminSess != null) {
            Permission perm = new Permission(className, opName);
            entity.setAdminSession(this.adminSess);
            entity.setModCode(AdminUtil.getObjName(perm.getObjName()) + "." + perm.getOpName());
        }
        entity.setContextId(this.contextId);
    }

    protected final void assertContext(String className, String opName, FortEntity entity, int errorCode) throws ValidationException {
        VUtil.assertNotNull(entity, errorCode, this.getFullMethodName(className, opName));
        entity.setContextId(this.contextId);
    }

    protected final void assertContext(String methodName, FortEntity entity, int errorCode) throws ValidationException {
        VUtil.assertNotNull(entity, errorCode, methodName);
        entity.setContextId(this.contextId);
    }

    protected final String getFullMethodName(String className, String opName) {
        return className + "." + opName;
    }
}

