/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.RoleP;
import org.apache.directory.fortress.core.impl.SdDAO;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.util.VUtil;

final class SdP {
    private SdDAO sdDao = new SdDAO();

    SdP() {
    }

    SDSet add(SDSet entity) throws SecurityException {
        this.validate(entity);
        return this.sdDao.create(entity);
    }

    SDSet update(SDSet entity) throws SecurityException {
        this.validate(entity);
        return this.sdDao.update(entity);
    }

    SDSet delete(SDSet entity) throws SecurityException {
        return this.sdDao.remove(entity);
    }

    SDSet read(SDSet entity) throws SecurityException {
        SDSet.SDType type = entity.getType();
        SDSet sde = this.sdDao.getSD(entity);
        sde.setType(type);
        return sde;
    }

    List<SDSet> search(SDSet sdSet) throws SecurityException {
        return this.sdDao.search(sdSet);
    }

    List<SDSet> search(Role role, SDSet.SDType type) throws SecurityException {
        return this.sdDao.search(role, type);
    }

    Set<SDSet> search(Set<String> rls, SDSet sdSet) throws SecurityException {
        return this.sdDao.search(rls, sdSet);
    }

    private void validate(SDSet entity) throws SecurityException {
        Set<String> roles;
        VUtil.safeText(entity.getName(), 40);
        if (StringUtils.isNotEmpty((String)entity.getDescription())) {
            VUtil.description(entity.getDescription());
        }
        if ((roles = entity.getMembers()) != null) {
            RoleP rp = new RoleP();
            for (String key : roles) {
                if (key.equalsIgnoreCase("none")) continue;
                Role role = new Role(key);
                role.setContextId(entity.getContextId());
                rp.readConstraints(role);
            }
        }
    }
}

