/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermListModel
extends Model<SerializableList<Permission>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private ReviewMgr reviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)PermListModel.class.getName());
    private Permission perm;
    private SerializableList<Permission> perms = null;
    private boolean isAdmin;

    public PermListModel(boolean isAdmin, Session session) {
        Injector.get().inject((Object)this);
        this.isAdmin = isAdmin;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.reviewMgr.setAdmin(session);
        }
    }

    public PermListModel(Permission perm, boolean isAdmin, Session session) {
        Injector.get().inject((Object)this);
        this.isAdmin = isAdmin;
        this.perm = perm;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.reviewMgr.setAdmin(session);
        }
    }

    public SerializableList<Permission> getObject() {
        if (this.perms != null) {
            LOG.debug(".getObject count: " + this.perms.size());
            return this.perms;
        }
        if (this.perm == null) {
            LOG.debug(".getObject null ");
            this.perms = new SerializableList(new ArrayList());
        } else {
            LOG.debug(" .getObject perm objectNm: " + this.perm.getObjName());
            LOG.debug(" .getObject perm opNm: " + this.perm.getOpName());
            this.perms = new SerializableList(this.getList(this.perm));
        }
        return this.perms;
    }

    public void setObject(SerializableList<Permission> object) {
        LOG.debug(".setObject count: " + object.size());
        this.perms = object;
    }

    public void detach() {
        this.perms = null;
        this.perm = null;
    }

    private List<Permission> getList(Permission perm) {
        List permsList = null;
        if (perm == null) {
            throw new RuntimeException("Invalid permission state");
        }
        try {
            String szObjectNm = perm.getObjName();
            String szOpNm = perm.getOpName();
            LOG.debug(".getList objectNm: " + szObjectNm + " opNm: " + szOpNm);
            perm.setAdmin(this.isAdmin);
            permsList = this.reviewMgr.findPermissions(perm);
            if (CollectionUtils.isNotEmpty((Collection)permsList)) {
                Collections.sort(permsList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return permsList;
    }
}

