/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.googlecode.wicket.jquery.ui.form.spinner.Spinner;
import com.googlecode.wicket.kendo.ui.form.datetime.DatePicker;
import com.googlecode.wicket.kendo.ui.form.datetime.TimePicker;
import java.util.Calendar;
import java.util.Date;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.web.panel.ConstraintPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintBasePanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final String CLS_NM = ConstraintPanel.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    protected static final String TIMEOUT = "timeout";
    protected static final String SUNDAY = "sunday";
    protected static final String MONDAY = "monday";
    protected static final String TUESDAY = "tuesday";
    protected static final String WEDNESDAY = "wednesday";
    protected static final String THURSDAY = "thursday";
    protected static final String FRIDAY = "friday";
    protected static final String SATURDAY = "saturday";
    protected static final String BEGIN_TIME = "beginTime";
    protected static final String END_TIME = "endTime";
    protected static final String BEGIN_DATE = "beginDate";
    protected static final String END_DATE = "endDate";
    protected static final String BEGIN_LOCK_DATE = "beginLockDate";
    protected static final String END_LOCK_DATE = "endLockDate";
    protected static final String DAY1 = "1";
    protected static final String DAY2 = "2";
    protected static final String DAY3 = "3";
    protected static final String DAY4 = "4";
    protected static final String DAY5 = "5";
    protected static final String DAY6 = "6";
    protected static final String DAY7 = "7";
    protected Date beginTime;
    protected Date beginDate;
    protected Date endTime;
    protected Date endDate;
    protected Date beginLockDate;
    protected Date endLockDate;
    protected TimePicker beginTimeTP;
    protected TimePicker endTimeTP;
    protected DatePicker beginDateDP;
    protected DatePicker endDateDP;
    protected DatePicker beginLockDateDP;
    protected DatePicker endLockDateDP;
    protected CheckBox sundayCB;
    protected CheckBox mondayCB;
    protected CheckBox tuesdayCB;
    protected CheckBox wednesdayCB;
    protected CheckBox thursdayCB;
    protected CheckBox fridayCB;
    protected CheckBox saturdayCB;
    protected Boolean sunday = false;
    protected Boolean monday = false;
    protected Boolean tuesday = false;
    protected Boolean wednesday = false;
    protected Boolean thursday = false;
    protected Boolean friday = false;
    protected Boolean saturday = false;

    public ConstraintBasePanel(String id, IModel constraint) {
        super(id, constraint);
        Spinner timeout = new Spinner(TIMEOUT);
        timeout.setRequired(false);
        this.add(new Component[]{timeout});
        this.sundayCB = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{this.sundayCB});
        this.mondayCB = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{this.mondayCB});
        this.tuesdayCB = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{this.tuesdayCB});
        this.wednesdayCB = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{this.wednesdayCB});
        this.thursdayCB = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{this.thursdayCB});
        this.fridayCB = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{this.fridayCB});
        this.saturdayCB = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{this.saturdayCB});
    }

    public void convertInput() {
        Constraint constraint = (Constraint)this.getDefaultModelObject();
        if (constraint != null) {
            constraint.setBeginTime(this.convertTime(this.beginTimeTP));
            constraint.setEndTime(this.convertTime(this.endTimeTP));
            constraint.setBeginDate(this.convertDate(this.beginDateDP));
            constraint.setEndDate(this.convertDate(this.endDateDP));
            constraint.setBeginLockDate(this.convertDate(this.beginLockDateDP));
            constraint.setEndLockDate(this.convertDate(this.endLockDateDP));
            this.setSunday((Boolean)this.sundayCB.getConvertedInput());
            this.setMonday((Boolean)this.mondayCB.getConvertedInput());
            this.setTuesday((Boolean)this.tuesdayCB.getConvertedInput());
            this.setWednesday((Boolean)this.wednesdayCB.getConvertedInput());
            this.setThursday((Boolean)this.thursdayCB.getConvertedInput());
            this.setFriday((Boolean)this.fridayCB.getConvertedInput());
            this.setSaturday((Boolean)this.saturdayCB.getConvertedInput());
            Object szDayMask = "";
            if (this.sunday.booleanValue()) {
                szDayMask = (String)szDayMask + DAY1;
            }
            if (this.monday.booleanValue()) {
                szDayMask = (String)szDayMask + DAY2;
            }
            if (this.tuesday.booleanValue()) {
                szDayMask = (String)szDayMask + DAY3;
            }
            if (this.wednesday.booleanValue()) {
                szDayMask = (String)szDayMask + DAY4;
            }
            if (this.thursday.booleanValue()) {
                szDayMask = (String)szDayMask + DAY5;
            }
            if (this.friday.booleanValue()) {
                szDayMask = (String)szDayMask + DAY6;
            }
            if (this.saturday.booleanValue()) {
                szDayMask = (String)szDayMask + DAY7;
            }
            constraint.setDayMask((String)szDayMask);
            this.setConvertedInput((Object)constraint);
        } else {
            LOG.warn("constraint was null");
        }
    }

    protected boolean isDayOfWeek(Constraint constraint, String szDay) {
        boolean isSet = false;
        if (constraint != null && constraint.getDayMask() != null && (constraint.getDayMask().contains(szDay) || constraint.getDayMask().equals("all"))) {
            isSet = true;
        }
        return isSet;
    }

    protected String convertTime(TimePicker time) {
        Date localDate;
        String szTime = null;
        if (time != null && (localDate = (Date)time.getConvertedInput()) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(localDate);
            LOG.debug("localDate=" + localDate.toString());
            szTime = calendar.get(11) < 10 ? "0" + calendar.get(11) : "" + calendar.get(11);
            szTime = calendar.get(12) < 10 ? szTime + "0" + calendar.get(12) : szTime + calendar.get(12);
        }
        return szTime;
    }

    protected String convertDate(DatePicker date) {
        Date localDate;
        String szDate = null;
        if (date != null && (localDate = (Date)date.getConvertedInput()) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(localDate);
            LOG.debug("localDate=" + localDate.toString());
            szDate = "" + calendar.get(1);
            szDate = calendar.get(2) + 1 < 10 ? szDate + "0" + (calendar.get(2) + 1) : szDate + (calendar.get(2) + 1);
            szDate = calendar.get(5) < 10 ? szDate + "0" + calendar.get(5) : szDate + calendar.get(5);
        }
        return szDate;
    }

    protected Date renderTime(Date date, String szTime) {
        if (szTime != null) {
            Calendar calendar = Calendar.getInstance();
            try {
                int hours = Integer.valueOf(szTime.substring(0, 2));
                int minutes = Integer.valueOf(szTime.substring(2, 4));
                if (hours == 0) {
                    hours = 24;
                }
                calendar.set(0, 0, 0, hours, minutes);
                date = calendar.getTime();
            }
            catch (StringIndexOutOfBoundsException e) {
                String warning = CLS_NM + ".renderTime bad time: " + szTime;
                LOG.warn(warning);
            }
        } else {
            date = null;
        }
        return date;
    }

    protected Date renderDate(Date date, String szDate) {
        if (szDate != null && !szDate.equalsIgnoreCase("none")) {
            Calendar calendar = Calendar.getInstance();
            try {
                int years = Integer.valueOf(szDate.substring(0, 4));
                int months = Integer.valueOf(szDate.substring(4, 6));
                int days = Integer.valueOf(szDate.substring(6, 8));
                calendar.set(years, --months, days, 0, 0);
                date = calendar.getTime();
            }
            catch (StringIndexOutOfBoundsException e) {
                String warning = CLS_NM + ".renderDate bad date: " + szDate;
                LOG.warn(warning);
            }
        } else {
            date = null;
        }
        return date;
    }

    protected Boolean getSunday() {
        return this.sunday;
    }

    protected void setSunday(Boolean sunday) {
        this.sunday = sunday;
    }

    protected Boolean getMonday() {
        return this.monday;
    }

    protected void setMonday(Boolean monday) {
        this.monday = monday;
    }

    protected Boolean getTuesday() {
        return this.tuesday;
    }

    protected void setTuesday(Boolean tuesday) {
        this.tuesday = tuesday;
    }

    protected Boolean getWednesday() {
        return this.wednesday;
    }

    protected void setWednesday(Boolean wednesday) {
        this.wednesday = wednesday;
    }

    protected Boolean getThursday() {
        return this.thursday;
    }

    protected void setThursday(Boolean thursday) {
        this.thursday = thursday;
    }

    protected Boolean getFriday() {
        return this.friday;
    }

    protected void setFriday(Boolean friday) {
        this.friday = friday;
    }

    protected Boolean getSaturday() {
        return this.saturday;
    }

    protected void setSaturday(Boolean saturday) {
        this.saturday = saturday;
    }
}

