/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.event.SaveModelEvent;
import org.apache.directory.fortress.web.modal.ModalWindow;
import org.apache.directory.fortress.web.model.PermListModel;
import org.apache.directory.fortress.web.panel.ObjectSearchModalPanel;
import org.apache.directory.fortress.web.panel.PermListPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermListPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)PermListPanel.class.getName());
    private Form<?> listForm;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private String permOperation;
    private String permObject;
    private TextField permObjectFld;
    private boolean isAdmin;

    public PermListPanel(String id, boolean isAdmin) {
        super(id);
        this.isAdmin = isAdmin;
        PermListModel permListModel = new PermListModel(new Permission("", ""), isAdmin, SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)permListModel);
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        PropertyColumn objName = new PropertyColumn((IModel)new Model((Serializable)((Object)"Object Name")), "userObject.ObjName");
        objName.setInitialSize(350);
        columns.add(objName);
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)"Object Id")), "userObject.ObjId"));
        columns.add(new PropertyColumn((IModel)new Model((Serializable)((Object)"Operation Name")), "userObject.OpName"));
        PropertyColumn description = new PropertyColumn((IModel)new Model((Serializable)((Object)"Description")), "userObject.Description");
        description.setInitialSize(300);
        columns.add(description);
        String roleAssignLabel = isAdmin ? "Admin Role Assignments" : "RBAC Role Assignments";
        PropertyColumn roles = new PropertyColumn((IModel)new Model((Serializable)((Object)roleAssignLabel)), "userObject.Roles");
        roles.setInitialSize(500);
        columns.add(roles);
        List perms = (List)this.getDefaultModel().getObject();
        this.treeModel = this.createTreeModel(perms);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        this.listForm = new Form("form");
        this.listForm.add(new Component[]{this.grid});
        this.grid.setOutputMarkupId(true);
        this.add(new Component[]{this.listForm});
        this.permObjectFld = new TextField("permObject", (IModel)new PropertyModel((Object)this, "permObject"));
        this.permObjectFld.setOutputMarkupId(true);
        2 ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.permObjectFld.add(new Behavior[]{ajaxUpdater});
        this.listForm.add(new Component[]{this.permObjectFld});
        TextField permOperationFld = new TextField("permOperation", (IModel)new PropertyModel((Object)this, "permOperation"));
        this.listForm.add(new Component[]{permOperationFld});
        this.addObjectSearchModal();
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void addObjectSearchModal() {
        Component[] componentArray = new Component[1];
        ModalWindow objectsModalWindow = new ModalWindow("objectsearchmodal");
        componentArray[0] = objectsModalWindow;
        this.listForm.add(componentArray);
        ObjectSearchModalPanel objectSearchModalPanel = new ObjectSearchModalPanel(objectsModalWindow.getContentId(), objectsModalWindow, this.isAdmin);
        objectsModalWindow.setContent((Component)objectSearchModalPanel);
        objectsModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        String modalLabel = this.isAdmin ? "Admin Permission Object Search Modal" : "RBAC Permission Object Search Modal";
        objectsModalWindow.setTitle(modalLabel);
        objectsModalWindow.setInitialWidth(700);
        objectsModalWindow.setInitialHeight(450);
        objectsModalWindow.setCookieName("objects-modal");
    }

    public void onEvent(IEvent event) {
        if (event.getPayload() instanceof SaveModelEvent) {
            SaveModelEvent modelEvent = (SaveModelEvent)event.getPayload();
            switch (6.$SwitchMap$org$apache$directory$fortress$web$event$SaveModelEvent$Operations[modelEvent.getOperation().ordinal()]) {
                case 1: {
                    this.add(modelEvent.getEntity());
                    break;
                }
                case 2: {
                    this.modelChanged();
                    break;
                }
                case 3: {
                    this.prune();
                    break;
                }
                case 4: {
                    this.setDefaultModel((IModel)new PermListModel((Permission)modelEvent.getEntity(), this.isAdmin, SecUtils.getSession((Component)this)));
                    this.treeModel.reload();
                    this.rootNode.removeAllChildren();
                    for (Permission perm : (List)this.getDefaultModelObject()) {
                        this.rootNode.add(new DefaultMutableTreeNode(perm));
                    }
                    break;
                }
            }
            AjaxRequestTarget target = ((SaveModelEvent)event.getPayload()).getAjaxRequestTarget();
            target.add(new Component[]{this.grid});
            LOG.debug(".onEvent SaveModelEvent: " + target.toString());
        }
    }

    private void removeSelectedItems(TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid) {
        Collection selected = grid.getSelectedItems();
        for (IModel model : selected) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getObject();
            this.treeModel.removeNodeFromParent(node);
            Permission perm = (Permission)node.getUserObject();
            LOG.debug(".removeSelectedItems perm objNm: " + perm.getObjName() + " opNm: " + perm.getOpName());
            List perms = (List)this.getDefaultModel().getObject();
            perms.remove(perm);
        }
    }

    private DefaultTreeModel createTreeModel(List<Permission> perms) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (perms == null) {
            LOG.debug(".createTreeModel no Perms found");
        } else {
            LOG.debug(".createTreeModel Perms found:" + perms.size());
            for (Permission perm : perms) {
                this.rootNode.add(new DefaultMutableTreeNode(perm));
            }
        }
        return model;
    }

    public void add(FortEntity entity) {
        if (this.getDefaultModelObject() != null) {
            List perms = (List)this.getDefaultModelObject();
            perms.add((Permission)entity);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(entity), this.rootNode, 0);
        }
    }

    public void prune() {
        this.removeSelectedItems(this.grid);
    }
}

