/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.codec.standalone.StandaloneLdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.fortress.core.CfgRuntimeException;
import org.apache.directory.fortress.core.ldap.LdapClientTrustStoreManager;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.EncryptUtil;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.ValidatingPoolableLdapConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnectionProvider {
    private static final String CLS_NM = LdapConnectionProvider.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static LdapConnectionPool adminPool;
    private static LdapConnectionPool logPool;
    private static LdapConnectionPool userPool;
    private static volatile LdapConnectionProvider sINSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LdapConnectionProvider getInstance() {
        if (sINSTANCE != null) return sINSTANCE;
        Class<LdapConnectionProvider> clazz = LdapConnectionProvider.class;
        synchronized (LdapConnectionProvider.class) {
            if (sINSTANCE != null) return sINSTANCE;
            sINSTANCE = new LdapConnectionProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sINSTANCE;
        }
    }

    private LdapConnectionProvider() {
        this.init();
    }

    private void init() {
        boolean IS_TLS = Config.getInstance().getBoolean("enable.ldap.starttls", false);
        boolean IS_SSL = Config.getInstance().getBoolean("enable.ldap.ssl", false);
        String host = Config.getInstance().getProperty("host", "localhost");
        int port = Config.getInstance().getInt("port", 389);
        int min = Config.getInstance().getInt("min.admin.conn", 1);
        int max = Config.getInstance().getInt("max.admin.conn", 10);
        int logmin = Config.getInstance().getInt("min.log.conn", 1);
        int logmax = Config.getInstance().getInt("max.log.conn", 10);
        boolean testOnBorrow = Config.getInstance().getBoolean("validate.conn.borrow", false);
        boolean testWhileIdle = Config.getInstance().getBoolean("validate.conn.idle", false);
        boolean isBlockOnMaxConnection = Config.getInstance().getBoolean("max.conn.block", true);
        int maxConnBlockTime = Config.getInstance().getInt("max.conn.block.time", 5000);
        int timeBetweenEvictionRunMillis = Config.getInstance().getInt("admin.conn.evict.run.millis", 1800000);
        int logTimeBetweenEvictionRunMillis = Config.getInstance().getInt("log.conn.evict.run.millis", 1800000);
        LOG.info("LDAP POOL:  host=[{}], port=[{}], min=[{}], max=[{}]", new Object[]{host, port, min, max});
        LdapConnectionConfig config = new LdapConnectionConfig();
        config.setLdapHost(host);
        config.setLdapPort(port);
        config.setName(Config.getInstance().getProperty("admin.user", ""));
        config.setEnabledProtocols(this.getDefaultProtocols());
        if ((IS_TLS || IS_SSL) && StringUtils.isNotEmpty((CharSequence)Config.getInstance().getProperty("trust.store")) && StringUtils.isNotEmpty((CharSequence)Config.getInstance().getProperty("trust.store.password", true))) {
            if (IS_SSL && IS_TLS) {
                throw new CfgRuntimeException(135, " enable.ldap.starttls and enable.ldap.ssl cannot be used simultaneously");
            }
            config.setUseTls(IS_TLS);
            config.setUseSsl(IS_SSL);
            config.setTrustManagers(new TrustManager[]{new LdapClientTrustStoreManager(Config.getInstance().getProperty("trust.store"), Config.getInstance().getProperty("trust.store.password", true).toCharArray(), null, true)});
        }
        String adminPw = EncryptUtil.isEnabled() ? EncryptUtil.getInstance().decrypt(Config.getInstance().getProperty("admin.pw", true)) : Config.getInstance().getProperty("admin.pw", true);
        config.setCredentials(adminPw);
        try {
            ArrayList<String> listExOps = new ArrayList<String>();
            listExOps.add("org.openldap.accelerator.impl.createSession.RbacCreateSessionFactory");
            listExOps.add("org.openldap.accelerator.impl.checkAccess.RbacCheckAccessFactory");
            listExOps.add("org.openldap.accelerator.impl.addRole.RbacAddRoleFactory");
            listExOps.add("org.openldap.accelerator.impl.dropRole.RbacDropRoleFactory");
            listExOps.add("org.openldap.accelerator.impl.deleteSession.RbacDeleteSessionFactory");
            listExOps.add("org.openldap.accelerator.impl.sessionRoles.RbacSessionRolesFactory");
            StandaloneLdapApiService ldapApiService = new StandaloneLdapApiService(new ArrayList(), new ArrayList(), listExOps, new ArrayList());
            if (!LdapApiServiceFactory.isInitialized()) {
                LdapApiServiceFactory.initialize((LdapApiService)ldapApiService);
            }
            config.setLdapApiService((LdapApiService)ldapApiService);
        }
        catch (Exception ex) {
            String error = "Exception caught initializing Admin Pool: " + ex;
            throw new CfgRuntimeException(135, error, ex);
        }
        ValidatingPoolableLdapConnectionFactory poolFactory = new ValidatingPoolableLdapConnectionFactory(config);
        adminPool = new LdapConnectionPool((PooledObjectFactory)poolFactory);
        adminPool.setTestOnBorrow(testOnBorrow);
        adminPool.setMaxTotal(max);
        adminPool.setBlockWhenExhausted(isBlockOnMaxConnection);
        adminPool.setMaxWaitMillis((long)maxConnBlockTime);
        adminPool.setMinIdle(min);
        adminPool.setMaxIdle(-1);
        adminPool.setTestWhileIdle(testWhileIdle);
        adminPool.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunMillis);
        userPool = new LdapConnectionPool((PooledObjectFactory)poolFactory);
        userPool.setTestOnBorrow(testOnBorrow);
        userPool.setMaxTotal(max);
        userPool.setBlockWhenExhausted(isBlockOnMaxConnection);
        userPool.setMaxWaitMillis((long)maxConnBlockTime);
        userPool.setMinIdle(min);
        userPool.setMaxIdle(-1);
        userPool.setTestWhileIdle(testWhileIdle);
        userPool.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunMillis);
        if (StringUtils.isNotEmpty((CharSequence)"log.admin.user") && StringUtils.isNotEmpty((CharSequence)"log.admin.pw")) {
            LdapConnectionConfig logConfig = new LdapConnectionConfig();
            logConfig.setLdapHost(host);
            logConfig.setLdapPort(port);
            logConfig.setName(Config.getInstance().getProperty("admin.user", ""));
            logConfig.setEnabledProtocols(this.getDefaultProtocols());
            logConfig.setUseSsl(IS_SSL);
            if (IS_SSL && StringUtils.isNotEmpty((CharSequence)Config.getInstance().getProperty("trust.store")) && StringUtils.isNotEmpty((CharSequence)Config.getInstance().getProperty("trust.store.password", true))) {
                logConfig.setTrustManagers(new TrustManager[]{new LdapClientTrustStoreManager(Config.getInstance().getProperty("trust.store"), Config.getInstance().getProperty("trust.store.password", true).toCharArray(), null, true)});
            }
            logConfig.setName(Config.getInstance().getProperty("log.admin.user", ""));
            String logPw = EncryptUtil.isEnabled() ? EncryptUtil.getInstance().decrypt(Config.getInstance().getProperty("log.admin.pw", true)) : Config.getInstance().getProperty("log.admin.pw", true);
            logConfig.setCredentials(logPw);
            poolFactory = new ValidatingPoolableLdapConnectionFactory(logConfig);
            logPool = new LdapConnectionPool((PooledObjectFactory)poolFactory);
            logPool.setTestOnBorrow(testOnBorrow);
            logPool.setMaxTotal(logmax);
            logPool.setBlockWhenExhausted(isBlockOnMaxConnection);
            logPool.setMaxWaitMillis((long)maxConnBlockTime);
            logPool.setMinIdle(logmin);
            logPool.setTestWhileIdle(testWhileIdle);
            logPool.setTimeBetweenEvictionRunsMillis((long)logTimeBetweenEvictionRunMillis);
        }
    }

    public void closeAdminConnection(LdapConnection connection) {
        try {
            adminPool.releaseConnection(connection);
        }
        catch (Exception e) {
            LOG.warn("Error closing admin connection: " + e);
        }
    }

    public void closeLogConnection(LdapConnection connection) {
        try {
            logPool.releaseConnection(connection);
        }
        catch (Exception e) {
            LOG.warn("Error closing log connection: " + e);
        }
    }

    public void closeUserConnection(LdapConnection connection) {
        try {
            userPool.releaseConnection(connection);
        }
        catch (Exception e) {
            LOG.warn("Error closing user connection: " + e);
        }
    }

    public LdapConnection getAdminConnection() throws LdapException {
        try {
            return adminPool.getConnection();
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    public LdapConnection getLogConnection() throws LdapException {
        try {
            return logPool.getConnection();
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    public LdapConnection getUserConnection() throws LdapException {
        try {
            return userPool.getConnection();
        }
        catch (Exception e) {
            throw new LdapException((Throwable)e);
        }
    }

    public static void closeAllConnectionPools() {
        try {
            LOG.info("Closing admin pool");
            adminPool.close();
        }
        catch (Exception e) {
            LOG.warn("Error closing admin pool: " + e);
        }
        try {
            LOG.info("Closing user pool");
            userPool.close();
        }
        catch (Exception e) {
            LOG.warn("Error closing user pool: " + e);
        }
        try {
            LOG.info("Closing log pool");
            logPool.close();
        }
        catch (Exception e) {
            LOG.warn("Error closing log pool: " + e);
        }
    }

    private String[] getDefaultProtocols() {
        Object[] protocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        List<Object> props = Config.getInstance().getList("tls.enabled.protocols");
        if (props != null && props.size() > 0) {
            protocols = new String[props.size()];
            int i = 0;
            for (Object val : props) {
                protocols[i++] = val.toString();
            }
            LOG.info("Override Default TLS protocols:" + Arrays.toString(protocols));
        } else {
            LOG.info("Use Default TLS protocols:" + Arrays.toString(protocols));
        }
        return protocols;
    }

    static {
        sINSTANCE = null;
    }
}

