/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.realm.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public final class CpUtil {
    private static final String CLS_NM = CpUtil.class.getName();
    private static final Logger LOG = Logger.getLogger(CLS_NM);
    private static final String PATH_SEPARATOR = "path.separator";
    private static final String FILE_PREFIX = "file:/";
    private static final String UNIX_SLASH = "/";
    private static final String WIN_SLASH = "\\";
    private static final String UNIX_SEPARATOR = ":";

    private CpUtil() {
    }

    public static URL[] parseRealmClasspath(String classpath) {
        URL[] urls = null;
        try {
            String slash;
            Object filePrefix = FILE_PREFIX;
            String pathSeparator = System.getProperty(PATH_SEPARATOR);
            if (UNIX_SEPARATOR.compareTo(pathSeparator) == 0) {
                filePrefix = (String)filePrefix + UNIX_SLASH;
                slash = UNIX_SLASH;
            } else {
                slash = WIN_SLASH;
            }
            LOG.info(CLS_NM + ".parseRealmClasspath <" + classpath + ">");
            StringTokenizer st = new StringTokenizer(classpath, pathSeparator, false);
            int size = st.countTokens();
            urls = new URL[size];
            for (int i = 0; i < size; ++i) {
                String resource = st.nextToken();
                resource = CpUtil.getResource(resource, slash);
                String file = (String)filePrefix + resource;
                urls[i] = new URL(file);
                LOG.info(CLS_NM + ".parseRealmClasspath path" + i + " <" + urls[i] + ">");
            }
        }
        catch (MalformedURLException me) {
            String error = CLS_NM + ".parseRealmClasspath caught MalformedURLException=" + me;
            LOG.severe(error);
            error = CLS_NM + ".parseRealmClasspath check your Fortress REALM_CLASSPATH setting.";
            LOG.severe(error);
        }
        return urls;
    }

    public static URL[] getRealmClasspath(String cpProp) {
        URL[] urls = null;
        try {
            String slash;
            Object filePrefix = FILE_PREFIX;
            String classpath = System.getProperty(cpProp);
            String pathSeparator = System.getProperty(PATH_SEPARATOR);
            if (classpath == null || classpath.length() == 0) {
                String error = CLS_NM + ".parseRealmClasspath invalid realm classpath detected";
                LOG.severe(error);
                throw new RuntimeException(error);
            }
            if (pathSeparator == null || pathSeparator.length() == 0) {
                String error = CLS_NM + ".parseRealmClasspath invalid classpath detected";
                LOG.severe(error);
                throw new RuntimeException(error);
            }
            if (pathSeparator.compareTo(UNIX_SEPARATOR) == 0) {
                filePrefix = (String)filePrefix + UNIX_SLASH;
                slash = UNIX_SLASH;
            } else {
                slash = WIN_SLASH;
            }
            LOG.info(CLS_NM + ".parseRealmClasspath <" + classpath + ">");
            StringTokenizer st = new StringTokenizer(classpath, pathSeparator, false);
            int size = st.countTokens();
            urls = new URL[size];
            for (int i = 0; i < size; ++i) {
                String resource = st.nextToken();
                resource = CpUtil.getResource(resource, slash);
                String file = (String)filePrefix + resource;
                urls[i] = new URL(file);
                LOG.info(CLS_NM + ".parseRealmClasspath path" + i + " <" + urls[i] + ">");
            }
        }
        catch (MalformedURLException me) {
            String error = CLS_NM + ".parseRealmClasspath caught MalformedURLException=" + me;
            LOG.severe(error);
            throw new RuntimeException(error);
        }
        return urls;
    }

    private static String getResource(String name, String slash) {
        File rFile = new File((String)name);
        if (rFile.isDirectory() && ((String)name).lastIndexOf(slash) != ((String)name).length() - 1) {
            name = (String)name + slash;
            LOG.info(CLS_NM + ".getResource slash added to dir path");
        }
        return name;
    }
}

