/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.operator.queue;

import java.util.HashMap;
import java.util.Map;

public class KeySegment {
    private final Map<Object, Integer> keyReferenceCounts = new HashMap<Object, Integer>();

    public void incrementKeyReference(Object key) {
        this.keyReferenceCounts.merge(key, 1, Integer::sum);
    }

    public void decrementKeyReference(Object key) {
        this.keyReferenceCounts.computeIfPresent(key, (k, count) -> {
            if (count <= 1) {
                return null;
            }
            return count - 1;
        });
    }

    public boolean hasActiveKey(Object key) {
        return this.keyReferenceCounts.containsKey(key);
    }

    public boolean isEmpty() {
        return this.keyReferenceCounts.isEmpty();
    }

    Map<Object, Integer> getKeyReferenceCounts() {
        return this.keyReferenceCounts;
    }
}

