/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.file;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.file.Authorization;
import org.apache.guacamole.auth.file.UserMapping;
import org.apache.guacamole.auth.file.UserMappingTagHandler;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.simple.SimpleAuthenticationProvider;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.xml.DocumentHandler;
import org.apache.guacamole.xml.TagHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FileAuthenticationProvider
extends SimpleAuthenticationProvider {
    private final Logger logger = LoggerFactory.getLogger(FileAuthenticationProvider.class);
    private long lastModified = Long.MIN_VALUE;
    private UserMapping cachedUserMapping;
    private final Environment environment = LocalEnvironment.getInstance();
    public static final String USER_MAPPING_FILENAME = "user-mapping.xml";

    public String getIdentifier() {
        return "default";
    }

    private UserMapping getUserMapping() {
        File userMappingFile = new File(this.environment.getGuacamoleHome(), USER_MAPPING_FILENAME);
        if (!userMappingFile.exists()) {
            this.logger.debug("User mapping file \"{}\" does not exist and will not be read.", (Object)userMappingFile);
            return null;
        }
        if (this.lastModified < userMappingFile.lastModified()) {
            SAXParser parser;
            this.logger.debug("Reading user mapping file: \"{}\"", (Object)userMappingFile);
            try {
                parser = SAXParserFactory.newInstance().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                this.logger.error("Unable to create XML parser for reading \"{}\": {}", (Object)USER_MAPPING_FILENAME, (Object)e.getMessage());
                this.logger.debug("An instance of SAXParser could not be created.", (Throwable)e);
                return null;
            }
            catch (SAXException e) {
                this.logger.error("Unable to create XML parser for reading \"{}\": {}", (Object)USER_MAPPING_FILENAME, (Object)e.getMessage());
                this.logger.debug("An instance of SAXParser could not be created.", (Throwable)e);
                return null;
            }
            try {
                UserMappingTagHandler userMappingHandler = new UserMappingTagHandler();
                DocumentHandler contentHandler = new DocumentHandler("user-mapping", (TagHandler)userMappingHandler);
                parser.parse(userMappingFile, (DefaultHandler)contentHandler);
                this.lastModified = userMappingFile.lastModified();
                this.cachedUserMapping = userMappingHandler.asUserMapping();
            }
            catch (IOException e) {
                this.logger.warn("Unable to read user mapping file \"{}\": {}", (Object)userMappingFile, (Object)e.getMessage());
                this.logger.debug("Error reading user mapping file.", (Throwable)e);
                return null;
            }
            catch (SAXException e) {
                this.logger.warn("User mapping file \"{}\" is not valid: {}", (Object)userMappingFile, (Object)e.getMessage());
                this.logger.debug("Error parsing user mapping file.", (Throwable)e);
                return null;
            }
        }
        return this.cachedUserMapping;
    }

    public Map<String, GuacamoleConfiguration> getAuthorizedConfigurations(Credentials credentials) throws GuacamoleException {
        UserMapping userMapping = this.getUserMapping();
        if (userMapping == null) {
            return null;
        }
        Authorization auth = userMapping.getAuthorization(credentials.getUsername());
        if (auth != null && auth.validate(credentials.getUsername(), credentials.getPassword())) {
            return auth.getConfigurations();
        }
        return null;
    }
}

