/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.extension;

import java.lang.reflect.InvocationTargetException;
import org.apache.guacamole.GuacamoleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProviderFactory.class);

    ProviderFactory() {
    }

    static <T> T newInstance(String typeName, Class<? extends T> providerClass) {
        T instance = null;
        try {
            instance = providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error("The {} extension in use is not properly defined. Please contact the developers of the extension or, if you are the developer, turn on debug-level logging.", (Object)typeName);
            logger.debug("{} is missing a default constructor.", (Object)providerClass.getName(), (Object)e);
        }
        catch (SecurityException e) {
            logger.error("The Java security manager is preventing extensions from being loaded. Please check the configuration of Java or your servlet container.");
            logger.debug("Creation of {} disallowed by security manager.", (Object)providerClass.getName(), (Object)e);
        }
        catch (InstantiationException e) {
            logger.error("The {} extension in use is not properly defined. Please contact the developers of the extension or, if you are the developer, turn on debug-level logging.", (Object)typeName);
            logger.debug("{} cannot be instantiated.", (Object)providerClass.getName(), (Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error("The {} extension in use is not properly defined. Please contact the developers of the extension or, if you are the developer, turn on debug-level logging.");
            logger.debug("Default constructor of {} is not public.", (Object)typeName, (Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("The {} extension in use is not properly defined. Please contact the developers of the extension or, if you are the developer, turn on debug-level logging.", (Object)typeName);
            logger.debug("Default constructor of {} cannot accept zero arguments.", (Object)providerClass.getName(), (Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = new GuacamoleException("Error encountered during initialization.");
            }
            logger.error("{} extension failed to start: {}", (Object)typeName, (Object)cause.getMessage());
            logger.debug("{} instantiation failed.", (Object)providerClass.getName(), (Object)e);
        }
        return instance;
    }
}

