/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.ws.rs.core.MultivaluedMap;

public class APIRequest
extends HttpServletRequestWrapper {
    private final Map<String, String[]> parameters;
    private final String remoteHost;
    private final String remoteAddr;

    public APIRequest(HttpServletRequest request, MultivaluedMap<String, String> parameters) {
        super(request);
        this.remoteHost = request.getRemoteHost();
        this.remoteAddr = request.getRemoteAddr();
        this.parameters = new HashMap(parameters.size());
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            List values = (List)entry.getValue();
            this.parameters.put(name, values.toArray(new String[values.size()]));
        }
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }
}

