/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import java.io.Closeable;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.apache.guacamole.tunnel.GuacamoleStreamException;

public class InterceptedStream<T extends Closeable> {
    private final String index;
    private final T stream;
    private GuacamoleException streamError = null;

    public InterceptedStream(String index, T stream) {
        this.index = index;
        this.stream = stream;
    }

    public String getIndex() {
        return this.index;
    }

    public T getStream() {
        return (T)this.stream;
    }

    public void setStreamError(GuacamoleException streamError) {
        this.streamError = streamError;
    }

    public void setStreamError(int code, String message) {
        GuacamoleStatus status = GuacamoleStatus.fromGuacamoleStatusCode((int)code);
        if (status == null) {
            status = GuacamoleStatus.SERVER_ERROR;
        }
        this.setStreamError((GuacamoleException)new GuacamoleStreamException(status, message));
    }

    public boolean hasStreamError() {
        return this.streamError != null;
    }

    public GuacamoleException getStreamError() {
        return this.streamError;
    }
}

