/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.ir;

import java.util.Map;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.ExpressionTreeRewriter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;

public class ReplaceSymbolInExpression {
    private ReplaceSymbolInExpression() {
    }

    public static Expression transform(Expression expression, Map<Symbol, ColumnSchema> tableAssignments) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(), expression, new Context(tableAssignments));
    }

    private static class Visitor
    extends ExpressionRewriter<Context> {
        private Visitor() {
        }

        @Override
        public Expression rewriteSymbolReference(SymbolReference node, Context context, ExpressionTreeRewriter<Context> treeRewriter) {
            return new SymbolReference(context.tableAssignments.get(Symbol.of(node.getName())).getName());
        }
    }

    public static class Context {
        Map<Symbol, ColumnSchema> tableAssignments;

        public Context(Map<Symbol, ColumnSchema> tableAssignments) {
            this.tableAssignments = tableAssignments;
        }
    }
}

