/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.ternary;

import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ternary.CompareTernaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TransformUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class BetweenColumnTransformer
extends CompareTernaryColumnTransformer {
    private final boolean isNotBetween;

    public BetweenColumnTransformer(Type returnType, ColumnTransformer firstColumnTransformer, ColumnTransformer secondColumnTransformer, ColumnTransformer thirdColumnTransformer, boolean isNotBetween) {
        super(returnType, firstColumnTransformer, secondColumnTransformer, thirdColumnTransformer);
        this.isNotBetween = isNotBetween;
    }

    @Override
    protected void doTransform(Column firstColumn, Column secondColumn, Column thirdColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!(firstColumn.isNull(i) || secondColumn.isNull(i) || thirdColumn.isNull(i))) {
                this.transform(firstColumn, secondColumn, thirdColumn, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column firstColumn, Column secondColumn, Column thirdColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i] && !firstColumn.isNull(i) && !secondColumn.isNull(i) && !thirdColumn.isNull(i)) {
                this.transform(firstColumn, secondColumn, thirdColumn, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(Column firstColumn, Column secondColumn, Column thirdColumn, ColumnBuilder builder, int i) {
        boolean flag = TableMetadataImpl.isCharType(this.firstColumnTransformer.getType()) || TableMetadataImpl.isBlobType(this.firstColumnTransformer.getType()) ? (TransformUtils.compare(this.firstColumnTransformer.getType().getBinary(firstColumn, i), this.secondColumnTransformer.getType().getBinary(secondColumn, i)) >= 0 && TransformUtils.compare(this.firstColumnTransformer.getType().getBinary(firstColumn, i), this.thirdColumnTransformer.getType().getBinary(thirdColumn, i)) <= 0) ^ this.isNotBetween : (TableMetadataImpl.isBool(this.firstColumnTransformer.getType()) ? (Boolean.compare(this.firstColumnTransformer.getType().getBoolean(firstColumn, i), this.secondColumnTransformer.getType().getBoolean(secondColumn, i)) >= 0 && Boolean.compare(this.firstColumnTransformer.getType().getBoolean(firstColumn, i), this.thirdColumnTransformer.getType().getBoolean(thirdColumn, i)) <= 0) ^ this.isNotBetween : (Double.compare(this.firstColumnTransformer.getType().getDouble(firstColumn, i), this.secondColumnTransformer.getType().getDouble(secondColumn, i)) >= 0 && Double.compare(this.firstColumnTransformer.getType().getDouble(firstColumn, i), this.thirdColumnTransformer.getType().getDouble(thirdColumn, i)) <= 0) ^ this.isNotBetween);
        this.returnType.writeBoolean(builder, flag);
    }
}

