/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AddColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AliasedRelation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AllColumns;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateView;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Delete;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExcludedPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Explain;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExplainAnalyze;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Extract;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Fill;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupingElement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GroupingSets;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Insert;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Join;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinOn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Limit;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternAlternation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternConcatenation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternPermutation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternVariable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuerySpecification;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Select;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SelectItem;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetOperation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetProperties;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleGroupBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SingleColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SortItem;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableSubquery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Trim;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Update;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.UpdateAssignment;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Values;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.With;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WithQuery;

public abstract class DefaultTraversalVisitor<C>
extends AstVisitor<Void, C> {
    @Override
    protected Void visitExtract(Extract node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected Void visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected Void visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    protected Void visitCoalesceExpression(CoalesceExpression node, C context) {
        for (Expression operand : node.getOperands()) {
            this.process(operand, context);
        }
        return null;
    }

    @Override
    protected Void visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected Void visitQuery(Query node, C context) {
        if (node.getWith().isPresent()) {
            this.process(node.getWith().get(), context);
        }
        this.process(node.getQueryBody(), context);
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        if (node.getOffset().isPresent()) {
            this.process(node.getOffset().get(), context);
        }
        if (node.getLimit().isPresent()) {
            this.process(node.getLimit().get(), context);
        }
        return null;
    }

    @Override
    protected Void visitExplain(Explain node, C context) {
        this.process(node.getStatement(), context);
        return null;
    }

    @Override
    protected Void visitExplainAnalyze(ExplainAnalyze node, C context) {
        this.process(node.getStatement(), context);
        return null;
    }

    @Override
    protected Void visitWith(With node, C context) {
        for (WithQuery query : node.getQueries()) {
            this.process(query, context);
        }
        return null;
    }

    @Override
    protected Void visitWithQuery(WithQuery node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitSelect(Select node, C context) {
        for (SelectItem item : node.getSelectItems()) {
            this.process(item, context);
        }
        return null;
    }

    @Override
    protected Void visitFill(Fill node, C context) {
        node.getFillValue().ifPresent(this::process);
        return null;
    }

    @Override
    protected Void visitOrderBy(OrderBy node, C context) {
        for (SortItem sortItem : node.getSortItems()) {
            this.process(sortItem, context);
        }
        return null;
    }

    @Override
    protected Void visitOffset(Offset node, C context) {
        this.process(node.getRowCount());
        return null;
    }

    @Override
    protected Void visitLimit(Limit node, C context) {
        this.process(node.getRowCount());
        return null;
    }

    @Override
    protected Void visitQuerySpecification(QuerySpecification node, C context) {
        this.process(node.getSelect(), context);
        if (node.getFrom().isPresent()) {
            this.process(node.getFrom().get(), context);
        }
        if (node.getWhere().isPresent()) {
            this.process(node.getWhere().get(), context);
        }
        if (node.getGroupBy().isPresent()) {
            this.process(node.getGroupBy().get(), context);
        }
        if (node.getHaving().isPresent()) {
            this.process(node.getHaving().get(), context);
        }
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        if (node.getOffset().isPresent()) {
            this.process(node.getOffset().get(), context);
        }
        if (node.getLimit().isPresent()) {
            this.process(node.getLimit().get(), context);
        }
        return null;
    }

    @Override
    protected Void visitSetOperation(SetOperation node, C context) {
        for (Relation relation : node.getRelations()) {
            this.process(relation, context);
        }
        return null;
    }

    @Override
    protected Void visitWhenClause(WhenClause node, C context) {
        this.process(node.getOperand(), context);
        this.process(node.getResult(), context);
        return null;
    }

    @Override
    protected Void visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getValueList(), context);
        return null;
    }

    @Override
    protected Void visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        return null;
    }

    @Override
    protected Void visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitInListExpression(InListExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        return null;
    }

    @Override
    protected Void visitDereferenceExpression(DereferenceExpression node, C context) {
        this.process(node.getBase(), context);
        return null;
    }

    @Override
    protected Void visitTrim(Trim node, C context) {
        this.process(node.getTrimSource(), context);
        node.getTrimCharacter().ifPresent(trimChar -> this.process((Node)trimChar, context));
        return null;
    }

    @Override
    protected Void visitIfExpression(IfExpression node, C context) {
        this.process(node.getCondition(), context);
        this.process(node.getTrueValue(), context);
        if (node.getFalseValue().isPresent()) {
            this.process(node.getFalseValue().get(), context);
        }
        return null;
    }

    @Override
    protected Void visitNullIfExpression(NullIfExpression node, C context) {
        this.process(node.getFirst(), context);
        this.process(node.getSecond(), context);
        return null;
    }

    @Override
    protected Void visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitNotExpression(NotExpression node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitSingleColumn(SingleColumn node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected Void visitAllColumns(AllColumns node, C context) {
        node.getTarget().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitLikePredicate(LikePredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getPattern(), context);
        node.getEscape().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitIsNullPredicate(IsNullPredicate node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitLogicalExpression(LogicalExpression node, C context) {
        for (Node node2 : node.getTerms()) {
            this.process(node2, context);
        }
        return null;
    }

    @Override
    protected Void visitSubqueryExpression(SubqueryExpression node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitSortItem(SortItem node, C context) {
        this.process(node.getSortKey(), context);
        return null;
    }

    @Override
    protected Void visitValues(Values node, C context) {
        for (Expression row : node.getRows()) {
            this.process(row, context);
        }
        return null;
    }

    @Override
    protected Void visitRow(Row node, C context) {
        for (Expression expression : node.getItems()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected Void visitTableSubquery(TableSubquery node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitAliasedRelation(AliasedRelation node, C context) {
        this.process(node.getRelation(), context);
        return null;
    }

    @Override
    protected Void visitJoin(Join node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        node.getCriteria().filter(JoinOn.class::isInstance).ifPresent(criteria -> {
            Expression expression = ((JoinOn)criteria).getExpression();
            if (expression != null) {
                this.process(expression, context);
            }
        });
        return null;
    }

    @Override
    protected Void visitExists(ExistsPredicate node, C context) {
        this.process(node.getSubquery(), context);
        return null;
    }

    @Override
    protected Void visitCast(Cast node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected Void visitCreateDB(CreateDB node, C context) {
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected Void visitAlterDB(AlterDB node, C context) {
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected Void visitCreateTable(CreateTable node, C context) {
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected Void visitCreateView(CreateView node, C context) {
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected Void visitProperty(Property node, C context) {
        this.process(node.getName(), context);
        if (!node.isSetToDefault()) {
            this.process(node.getNonDefaultValue(), context);
        }
        return null;
    }

    @Override
    protected Void visitSetProperties(SetProperties node, C context) {
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected Void visitAddColumn(AddColumn node, C context) {
        this.process(node.getColumn(), context);
        return null;
    }

    @Override
    protected Void visitInsert(Insert node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitDelete(Delete node, C context) {
        this.process(node.getTable(), context);
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    @Override
    protected Void visitUpdate(Update node, C context) {
        this.process(node.getTable(), context);
        node.getAssignments().forEach(value -> this.process((Node)value, context));
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    @Override
    protected Void visitUpdateAssignment(UpdateAssignment node, C context) {
        this.process(node.getName(), context);
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitGroupBy(GroupBy node, C context) {
        for (GroupingElement groupingElement : node.getGroupingElements()) {
            this.process(groupingElement, context);
        }
        return null;
    }

    @Override
    protected Void visitGroupingSets(GroupingSets node, C context) {
        for (Expression expression : node.getExpressions()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected Void visitSimpleGroupBy(SimpleGroupBy node, C context) {
        for (Expression expression : node.getExpressions()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected Void visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getSubquery(), context);
        return null;
    }

    @Override
    protected Void visitExcludedPattern(ExcludedPattern node, C context) {
        this.process(node.getPattern(), context);
        return null;
    }

    @Override
    protected Void visitPatternAlternation(PatternAlternation node, C context) {
        for (RowPattern rowPattern : node.getPatterns()) {
            this.process(rowPattern, context);
        }
        return null;
    }

    @Override
    protected Void visitPatternConcatenation(PatternConcatenation node, C context) {
        for (RowPattern rowPattern : node.getPatterns()) {
            this.process(rowPattern, context);
        }
        return null;
    }

    @Override
    protected Void visitPatternPermutation(PatternPermutation node, C context) {
        for (RowPattern rowPattern : node.getPatterns()) {
            this.process(rowPattern, context);
        }
        return null;
    }

    @Override
    protected Void visitPatternVariable(PatternVariable node, C context) {
        this.process(node.getName(), context);
        return null;
    }

    @Override
    protected Void visitQuantifiedPattern(QuantifiedPattern node, C context) {
        this.process(node.getPattern(), context);
        return null;
    }
}

