/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import com.google.common.base.Supplier;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.iotdb.commons.auth.entity.DatabasePrivilege;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.TablePrivilege;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;

public class IOUtils {
    private IOUtils() {
    }

    public static void writeString(OutputStream outputStream, String str, String encoding, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        if (str != null) {
            byte[] strBuffer = str.getBytes(encoding);
            IOUtils.writeInt(outputStream, strBuffer.length, encodingBufferLocal);
            outputStream.write(strBuffer);
        } else {
            IOUtils.writeInt(outputStream, 0, encodingBufferLocal);
        }
    }

    public static void writeInt(OutputStream outputStream, int i, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        ByteBuffer encodingBuffer;
        if (encodingBufferLocal != null) {
            encodingBuffer = encodingBufferLocal.get();
            if (encodingBuffer == null) {
                encodingBuffer = ByteBuffer.allocate(8);
                encodingBufferLocal.set(encodingBuffer);
            }
        } else {
            encodingBuffer = ByteBuffer.allocate(4);
        }
        encodingBuffer.clear();
        encodingBuffer.putInt(i);
        outputStream.write(encodingBuffer.array(), 0, 4);
    }

    public static void writeLong(OutputStream outputStream, long i, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        ByteBuffer encodingBuffer;
        if (encodingBufferLocal != null) {
            encodingBuffer = encodingBufferLocal.get();
            if (encodingBuffer == null) {
                encodingBuffer = ByteBuffer.allocate(8);
                encodingBufferLocal.set(encodingBuffer);
            }
        } else {
            encodingBuffer = ByteBuffer.allocate(8);
        }
        encodingBuffer.clear();
        encodingBuffer.putLong(i);
        outputStream.write(encodingBuffer.array(), 0, 8);
    }

    public static String readString(DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal) throws IOException {
        int length = inputStream.readInt();
        return IOUtils.readString(inputStream, encoding, strBufferLocal, length);
    }

    public static String readString(DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal, int length) throws IOException {
        if (length > 0) {
            byte[] strBuffer;
            if (strBufferLocal != null) {
                strBuffer = strBufferLocal.get();
                if (strBuffer == null || length > strBuffer.length) {
                    strBuffer = new byte[length];
                    strBufferLocal.set(strBuffer);
                }
            } else {
                strBuffer = new byte[length];
            }
            inputStream.read(strBuffer, 0, length);
            return new String(strBuffer, 0, length, encoding);
        }
        return null;
    }

    public static PathPrivilege readPathPrivilege(DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal) throws IOException, IllegalPathException {
        String path = IOUtils.readString(inputStream, encoding, strBufferLocal);
        PathPrivilege pathPrivilege = new PathPrivilege(new PartialPath(path));
        int privileges = inputStream.readInt();
        pathPrivilege.setAllPrivileges(privileges);
        return pathPrivilege;
    }

    public static void writePathPrivilege(OutputStream outputStream, PathPrivilege pathPrivilege, String encoding, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        IOUtils.writeString(outputStream, pathPrivilege.getPath().getFullPath(), encoding, encodingBufferLocal);
        IOUtils.writeInt(outputStream, pathPrivilege.getAllPrivileges(), encodingBufferLocal);
    }

    public static DatabasePrivilege readRelationalPrivilege(DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal) throws IOException {
        String databaseName = IOUtils.readString(inputStream, encoding, strBufferLocal);
        DatabasePrivilege databasePrivilege = new DatabasePrivilege(databaseName);
        databasePrivilege.setPrivileges(inputStream.readInt());
        int tableNum = inputStream.readInt();
        for (int i = 0; i < tableNum; ++i) {
            String tableName = IOUtils.readString(inputStream, encoding, strBufferLocal);
            TablePrivilege tablePrivilege = new TablePrivilege(tableName);
            tablePrivilege.setPrivileges(inputStream.readInt());
            databasePrivilege.getTablePrivilegeMap().put(tableName, tablePrivilege);
        }
        return databasePrivilege;
    }

    public static void writeObjectPrivilege(OutputStream outputStream, DatabasePrivilege databasePrivilege, String encoding, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        IOUtils.writeString(outputStream, databasePrivilege.getDatabaseName(), encoding, encodingBufferLocal);
        IOUtils.writeInt(outputStream, databasePrivilege.getAllPrivileges(), encodingBufferLocal);
        IOUtils.writeInt(outputStream, databasePrivilege.getTablePrivilegeMap().size(), encodingBufferLocal);
        for (Map.Entry<String, TablePrivilege> entry : databasePrivilege.getTablePrivilegeMap().entrySet()) {
            IOUtils.writeString(outputStream, entry.getValue().getTableName(), encoding, encodingBufferLocal);
            IOUtils.writeInt(outputStream, entry.getValue().getAllPrivileges(), encodingBufferLocal);
        }
    }

    public static void replaceFile(File newFile, File oldFile) throws IOException {
        if (!newFile.renameTo(oldFile)) {
            if (!oldFile.delete()) {
                throw new IOException(String.format("Cannot delete old user file : %s", oldFile.getPath()));
            }
            if (!newFile.renameTo(oldFile)) {
                throw new IOException(String.format("Cannot replace old user file with new one : %s", newFile.getPath()));
            }
        }
    }

    public static ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        original.rewind();
        clone.put(original);
        original.rewind();
        clone.flip();
        return clone;
    }

    public static <T> Optional<T> retryNoException(int maxRetry, long retryIntervalMS, Supplier<T> retryFunc, Function<T, Boolean> validator) {
        for (int i = 0; i < maxRetry; ++i) {
            Object result = retryFunc.get();
            if (Boolean.TRUE.equals(validator.apply(result))) {
                return Optional.of(result);
            }
            try {
                Thread.sleep(retryIntervalMS);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

