/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.lemmatizer;

import java.io.OutputStream;
import opennlp.tools.cmdline.FineGrainedReportListener;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.lemmatizer.LemmatizerEvaluationMonitor;
import opennlp.tools.log.LogPrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LemmatizerFineGrainedReportListener
extends FineGrainedReportListener
implements LemmatizerEvaluationMonitor {
    private static final Logger logger = LoggerFactory.getLogger(LemmatizerFineGrainedReportListener.class);

    public LemmatizerFineGrainedReportListener() {
        super(new LogPrintStream(logger));
    }

    public LemmatizerFineGrainedReportListener(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void misclassified(LemmaSample reference, LemmaSample prediction) {
        this.statsAdd(reference, prediction);
    }

    @Override
    public void correctlyClassified(LemmaSample reference, LemmaSample prediction) {
        this.statsAdd(reference, prediction);
    }

    private void statsAdd(LemmaSample reference, LemmaSample prediction) {
        this.getStats().add(reference.getTokens(), reference.getTags(), prediction.getTags());
    }

    @Override
    public void writeReport() {
        this.printGeneralStatistics();
        this.printTokenErrorRank();
        this.printTokenOccurrencesRank();
        this.printTagsErrorRank();
        this.printGeneralConfusionTable();
        this.printDetailedConfusionMatrix();
    }
}

