/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor.model;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import org.apache.servicecomb.dashboard.client.model.MonitorData;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.CPUMonitorCalc;
import org.apache.servicecomb.huaweicloud.dashboard.monitor.data.MonitorConstant;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.RegistryUtils;

public interface MonitorDataProvider {
    public boolean enabled();

    default public String getURL() {
        return String.format(MonitorConstant.MONITORS_URI, RegistryUtils.getMicroservice().getServiceName());
    }

    default public void extractServiceInfo(MonitorData monitorData) {
        Microservice microservice = RegistryUtils.getMicroservice();
        MicroserviceInstance microserviceInstance = RegistryUtils.getMicroserviceInstance();
        monitorData.setAppId(microservice.getAppId());
        monitorData.setName(microservice.getServiceName());
        monitorData.setVersion(microservice.getVersion());
        monitorData.setServiceId(microservice.getServiceId());
        monitorData.setInstance(microserviceInstance.getHostName());
        monitorData.setInstanceId(microserviceInstance.getInstanceId());
        monitorData.setEnvironment(microservice.getEnvironment());
    }

    default public void exactProcessInfo(MonitorData monitorData) {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryHeapUsage = memoryMXBean.getHeapMemoryUsage();
        MemoryUsage memoryNonHeapUsage = memoryMXBean.getNonHeapMemoryUsage();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        int threadCount = threadMXBean.getThreadCount();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        double cpu = operatingSystemMXBean.getSystemLoadAverage();
        monitorData.setCpu(CPUMonitorCalc.getInstance().getProcessCpu());
        monitorData.setLoadAverage(cpu);
        monitorData.setThreadCount(threadCount);
        monitorData.setUptime(runtimeMXBean.getUptime());
        HashMap<String, Long> memoryInfo = new HashMap<String, Long>();
        memoryInfo.put("heapInit", memoryHeapUsage.getInit());
        memoryInfo.put("headMax", memoryHeapUsage.getMax());
        memoryInfo.put("heapCommit", memoryHeapUsage.getCommitted());
        memoryInfo.put("heapUsed", memoryHeapUsage.getUsed());
        memoryInfo.put("nonHeapInit", memoryNonHeapUsage.getInit());
        memoryInfo.put("nonHeapCommit", memoryNonHeapUsage.getCommitted());
        memoryInfo.put("nonHeapUsed", memoryNonHeapUsage.getUsed());
        monitorData.setMemory(memoryInfo);
    }

    public void extractInterfaceInfo(MonitorData var1);

    default public MonitorData getData() {
        MonitorData monitorData = new MonitorData();
        this.extractServiceInfo(monitorData);
        this.exactProcessInfo(monitorData);
        this.extractInterfaceInfo(monitorData);
        return monitorData;
    }
}

