/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.internal.shared;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.stream.StreamSource;
import org.apache.sis.util.internal.shared.Strings;

public final class URISource
extends StreamSource {
    public final URI document;
    public final String fragment;

    URISource(URI source) throws URISyntaxException {
        source = source.normalize();
        URI c = new URI(source.getScheme(), source.getSchemeSpecificPart(), null);
        if (c.isOpaque() && "file".equalsIgnoreCase(c.getScheme())) {
            c = new File(c.getSchemeSpecificPart()).toURI();
        }
        this.document = source.equals(c) ? source : c;
        this.fragment = Strings.trimOrNull((String)source.getFragment());
    }

    public static StreamSource create(InputStream input, URI source) throws URISyntaxException {
        if (source != null) {
            URISource s = new URISource(source);
            s.setInputStream(input);
            return s;
        }
        return new StreamSource(input);
    }

    public URI getReadableURI() {
        return this.getInputStream() == null && this.getReader() == null ? this.document : null;
    }

    @Override
    public String getSystemId() {
        String systemId = super.getSystemId();
        if (systemId == null) {
            systemId = this.document.toASCIIString();
            this.setSystemId(systemId);
        }
        return systemId;
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"document", this.document, "fragment", this.fragment, "inputStream", this.getInputStream(), "reader", this.getReader()});
    }
}

