/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.Region;
import org.apache.sis.io.stream.SubsampledRectangleWriter;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

public class HyperRectangleWriter {
    private final int startAt;
    final int contiguousDataLength;
    private final int[] remaining;
    private final int[] strides;

    public HyperRectangleWriter(Region region) {
        this.startAt = Math.toIntExact(region.startAt);
        int cdd = region.contiguousDataDimension();
        this.contiguousDataLength = region.targetLength(cdd);
        int d = region.getDimension() - cdd;
        this.remaining = new int[d];
        this.strides = new int[d];
        int i = d;
        while (--i >= 0) {
            this.remaining[i] = region.getTargetSize(cdd) - 1;
            if (this.remaining[i] < 0 || (this.strides[i] = Math.toIntExact(region.getSkip(cdd) + (long)this.contiguousDataLength)) == 0) {
                throw new AssertionError(region);
            }
            ++cdd;
        }
    }

    final int startAt(int offset) {
        return Math.addExact(this.startAt, offset);
    }

    final int[] count() {
        return (int[])this.remaining.clone();
    }

    final int next(int offset, int[] count) {
        int i = count.length;
        while (--i >= 0) {
            int n = i;
            count[n] = count[n] - 1;
            if (count[n] >= 0) {
                return offset + this.strides[i];
            }
            count[i] = this.remaining[i];
        }
        return -1;
    }

    public boolean suggestDirect(ChannelDataOutput output) {
        return !output.buffer.isDirect() && output.buffer.capacity() <= this.contiguousDataLength;
    }

    public void write(ChannelDataOutput output, byte[] data, int offset, boolean direct) throws IOException {
        offset = this.startAt(offset);
        int[] count = this.count();
        if (direct) {
            ByteBuffer buffer = ByteBuffer.wrap(data);
            output.flush();
            do {
                buffer.limit(offset + this.contiguousDataLength).position(offset);
                do {
                    int n = output.channel.write(buffer);
                    output.moveBufferForward(n);
                    if (n != 0) continue;
                    output.onEmptyTransfer();
                } while (buffer.hasRemaining());
            } while ((offset = this.next(offset, count)) >= 0);
        } else {
            do {
                output.write(data, offset, this.contiguousDataLength);
            } while ((offset = this.next(offset, count)) >= 0);
        }
    }

    public void write(ChannelDataOutput output, short[] data, int offset) throws IOException {
        offset = this.startAt(offset);
        int[] count = this.count();
        do {
            output.writeShorts(data, offset, this.contiguousDataLength);
        } while ((offset = this.next(offset, count)) >= 0);
    }

    public void write(ChannelDataOutput output, int[] data, int offset) throws IOException {
        offset = this.startAt(offset);
        int[] count = this.count();
        do {
            output.writeInts(data, offset, this.contiguousDataLength);
        } while ((offset = this.next(offset, count)) >= 0);
    }

    public void write(ChannelDataOutput output, long[] data, int offset) throws IOException {
        offset = this.startAt(offset);
        int[] count = this.count();
        do {
            output.writeLongs(data, offset, this.contiguousDataLength);
        } while ((offset = this.next(offset, count)) >= 0);
    }

    public void write(ChannelDataOutput output, float[] data, int offset) throws IOException {
        offset = this.startAt(offset);
        int[] count = this.count();
        do {
            output.writeFloats(data, offset, this.contiguousDataLength);
        } while ((offset = this.next(offset, count)) >= 0);
    }

    public void write(ChannelDataOutput output, double[] data, int offset) throws IOException {
        offset = this.startAt(offset);
        int[] count = this.count();
        do {
            output.writeDoubles(data, offset, this.contiguousDataLength);
        } while ((offset = this.next(offset, count)) >= 0);
    }

    public static final class Builder {
        private long length;
        private int pixelBitStride;
        private int pixelStride;
        private int scanlineStride;
        private int[] bankIndices;
        private int[] bankOffsets;
        private boolean requiresBigEndian;
        private Rectangle region;
        private int sampleModelTranslateX;
        private int sampleModelTranslateY;

        public static boolean isSupported(SampleModel sm) {
            if (sm instanceof ComponentSampleModel) {
                return true;
            }
            if (sm instanceof SinglePixelPackedSampleModel) {
                return Builder.isSupported(null, (SinglePixelPackedSampleModel)sm);
            }
            if (sm instanceof MultiPixelPackedSampleModel) {
                return Builder.isSupported(null, (MultiPixelPackedSampleModel)sm);
            }
            return false;
        }

        private HyperRectangleWriter create(SampleModel sm, int[] bandOffsets) {
            int numBands;
            int width = sm.getWidth();
            ArgumentChecks.ensureStrictlyPositive((String)"width", (int)width);
            int height = sm.getHeight();
            ArgumentChecks.ensureStrictlyPositive((String)"height", (int)height);
            ArgumentChecks.ensureStrictlyPositive((String)"scanlineStride", (int)this.scanlineStride);
            ArgumentChecks.ensureBetween((String)"pixelStride", (int)1, (int)this.scanlineStride, (int)this.pixelStride);
            long[] sourceSize = new long[]{this.scanlineStride, height};
            if (this.region == null) {
                this.region = new Rectangle(width, height);
            }
            long[] regionLower = new long[]{(long)this.region.x - (long)this.sampleModelTranslateX, (long)this.region.y - (long)this.sampleModelTranslateY};
            long[] regionUpper = new long[]{regionLower[0] + (long)this.region.width, regionLower[1] + (long)this.region.height};
            regionLower[0] = regionLower[0] * (long)this.pixelStride;
            regionUpper[0] = regionUpper[0] * (long)this.pixelStride;
            if (this.pixelBitStride != 0) {
                int dataSize = DataBuffer.getDataTypeSize(sm.getDataType());
                ArgumentChecks.ensureBetween((String)"pixelBitStride", (int)1, (int)dataSize, (int)this.pixelBitStride);
                regionLower[0] = Math.floorDiv(regionLower[0] * (long)this.pixelBitStride, dataSize);
                regionUpper[0] = JDK18.ceilDiv((long)(regionUpper[0] * (long)this.pixelBitStride), (long)dataSize);
            }
            Region subset = new Region(sourceSize, regionLower, regionUpper, new long[]{1L, 1L});
            this.length = subset.length;
            if (!(bandOffsets == null || (numBands = bandOffsets.length) == this.pixelStride && ArraysExt.isRange((int)0, (int[])bandOffsets))) {
                if (numBands != 1) {
                    ArgumentChecks.ensureBetween((String)"pixelStride", (int)numBands, (int)this.scanlineStride, (int)this.pixelStride);
                }
                return new SubsampledRectangleWriter(subset, bandOffsets, this.pixelStride);
            }
            return new HyperRectangleWriter(subset);
        }

        public HyperRectangleWriter create(ComponentSampleModel sm) {
            this.pixelStride = sm.getPixelStride();
            this.scanlineStride = sm.getScanlineStride();
            this.bankIndices = sm.getBankIndices();
            int[] bandOffsets = sm.getBandOffsets();
            boolean isInterleaved = sm instanceof PixelInterleavedSampleModel;
            if (!isInterleaved && !(sm instanceof BandedSampleModel)) {
                int min = Integer.MAX_VALUE;
                int max = Integer.MIN_VALUE;
                for (int b : bandOffsets) {
                    if (b < min) {
                        min = b;
                    }
                    if (b <= max) continue;
                    max = b;
                }
                boolean bl = isInterleaved = max - min < this.pixelStride;
            }
            if (isInterleaved && ArraysExt.allEquals((int[])this.bankIndices, (int)this.bankIndices[0])) {
                this.bankIndices = ArraysExt.resize((int[])this.bankIndices, (int)1);
                this.bankOffsets = new int[1];
            } else {
                this.bankOffsets = bandOffsets;
                bandOffsets = null;
            }
            return this.create(sm, bandOffsets);
        }

        public HyperRectangleWriter create(SinglePixelPackedSampleModel sm) {
            this.bankIndices = new int[1];
            this.bankOffsets = this.bankIndices;
            this.pixelStride = 1;
            this.scanlineStride = sm.getScanlineStride();
            if (Builder.isSupported(this, sm)) {
                return this.create(sm, null);
            }
            throw new RasterFormatException(sm.toString());
        }

        private static boolean isSupported(Builder builder, SinglePixelPackedSampleModel sm) {
            int mask;
            int dataSize = DataBuffer.getDataTypeSize(sm.getDataType());
            int[] d = sm.getBitMasks();
            if (d.length == 1 && (d[0] & (mask = (int)((1L << dataSize) - 1L))) == mask) {
                return true;
            }
            if (dataSize % (d.length * 8) != 0) {
                return false;
            }
            mask = 255;
            int i = d.length;
            while (--i >= 0) {
                if (d[i] != mask) {
                    return false;
                }
                mask <<= 8;
            }
            if (builder != null) {
                builder.requiresBigEndian = true;
            }
            return true;
        }

        public HyperRectangleWriter create(MultiPixelPackedSampleModel sm) {
            this.bankIndices = new int[1];
            this.bankOffsets = this.bankIndices;
            this.pixelStride = 1;
            this.pixelBitStride = sm.getPixelBitStride();
            this.scanlineStride = sm.getScanlineStride();
            if (Builder.isSupported(this, sm)) {
                return this.create(sm, null);
            }
            throw new RasterFormatException(sm.toString());
        }

        private static boolean isSupported(Builder builder, MultiPixelPackedSampleModel sm) {
            int[] d = sm.getSampleSize();
            if (d.length == 1) {
                int dataSize;
                int sampleSize = d[0];
                if (sm.getPixelBitStride() == sampleSize && (dataSize = DataBuffer.getDataTypeSize(sm.getDataType())) % sampleSize == 0) {
                    if (builder != null) {
                        builder.requiresBigEndian = Math.max(sampleSize, 8) != dataSize;
                    }
                    return true;
                }
            }
            return false;
        }

        public HyperRectangleWriter create(SampleModel sm) {
            if (sm instanceof ComponentSampleModel) {
                return this.create((ComponentSampleModel)sm);
            }
            if (sm instanceof SinglePixelPackedSampleModel) {
                return this.create((SinglePixelPackedSampleModel)sm);
            }
            if (sm instanceof MultiPixelPackedSampleModel) {
                return this.create((MultiPixelPackedSampleModel)sm);
            }
            throw new RasterFormatException(sm.toString());
        }

        public HyperRectangleWriter create(Raster tile, int width, int height) {
            this.region = tile.getBounds();
            if (width >= 0) {
                this.region.width = width;
            }
            if (height >= 0) {
                this.region.height = height;
            }
            this.sampleModelTranslateX = tile.getSampleModelTranslateX();
            this.sampleModelTranslateY = tile.getSampleModelTranslateY();
            return this.create(tile.getSampleModel());
        }

        public int numBanks() {
            return this.bankIndices.length;
        }

        public long length() {
            return this.length;
        }

        public int pixelStride() {
            return this.pixelStride;
        }

        public int scanlineStride() {
            return this.scanlineStride;
        }

        public int bankIndex(int i) {
            return this.bankIndices[i];
        }

        public int bankOffset(int i, int bufferOffset) {
            return Math.addExact(this.bankOffsets[i], bufferOffset);
        }

        public ByteOrder byteOrder(ByteOrder current) {
            return this.requiresBigEndian && current != ByteOrder.BIG_ENDIAN ? ByteOrder.BIG_ENDIAN : null;
        }
    }
}

