/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.io.Closeable;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.SequenceType;

public class WritablePixelIterator
extends PixelIterator
implements Closeable {
    private final WritableRenderedImage destination;
    private WritableRaster destRaster;

    WritablePixelIterator(Raster input, WritableRaster output, Rectangle subArea, Dimension window, SequenceType order) {
        super(input, subArea, window, order);
        this.destRaster = output;
        this.destination = null;
        if (output != null) {
            if (!input.getSampleModel().equals(output.getSampleModel())) {
                throw new IllegalArgumentException(Resources.format((short)46));
            }
            if (!input.getBounds().equals(output.getBounds())) {
                throw new IllegalArgumentException(Resources.format((short)43));
            }
        }
    }

    WritablePixelIterator(RenderedImage input, WritableRenderedImage output, Rectangle subArea, Dimension window, SequenceType order) {
        super(input, subArea, window, order);
        this.destRaster = null;
        this.destination = output;
        if (output != null) {
            if (!input.getSampleModel().equals(output.getSampleModel())) {
                throw new IllegalArgumentException(Resources.format((short)46));
            }
            if (input.getMinX() != output.getMinX() || input.getMinY() != output.getMinY() || input.getWidth() != output.getWidth() || input.getHeight() != output.getHeight()) {
                throw new IllegalArgumentException(Resources.format((short)43));
            }
            if (input.getMinTileX() != output.getMinTileX() || input.getMinTileY() != output.getMinTileY() || input.getTileWidth() != output.getTileWidth() || input.getTileHeight() != output.getTileHeight()) {
                throw new IllegalArgumentException(Resources.format((short)47));
            }
        }
    }

    public static WritablePixelIterator create(WritableRenderedImage data) {
        return new PixelIterator.Builder().createWritable(data);
    }

    @Override
    public boolean isWritable() {
        return this.destination != null || this.destRaster != null;
    }

    public void setSample(int band, int value) {
        this.destRaster.setSample(this.x, this.y, band, value);
    }

    public void setSample(int band, float value) {
        this.destRaster.setSample(this.x, this.y, band, value);
    }

    public void setSample(int band, double value) {
        this.destRaster.setSample(this.x, this.y, band, value);
    }

    public void setPixel(int[] values) {
        this.destRaster.setPixel(this.x, this.y, values);
    }

    public void setPixel(float[] values) {
        this.destRaster.setPixel(this.x, this.y, values);
    }

    public void setPixel(double[] values) {
        this.destRaster.setPixel(this.x, this.y, values);
    }

    public void setDataElements(Object values) {
        this.destRaster.setDataElements(this.x, this.y, values);
    }

    final WritableRaster destination() {
        return this.destRaster;
    }

    @Override
    final Raster fetchWritableTile() {
        if (this.destination != null) {
            this.destRaster = this.destination.getWritableTile(this.tileX, this.tileY);
            if (this.destination == this.image) {
                return this.destRaster;
            }
        }
        return super.fetchWritableTile();
    }

    @Override
    void releaseTile() {
        super.releaseTile();
        if (this.destination != null && this.destRaster != null) {
            this.destRaster = null;
            this.destination.releaseWritableTile(this.tileX, this.tileY);
        }
    }

    @Override
    public void close() {
        this.releaseTile();
    }
}

