/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.Simulation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HSpiceOut
extends Simulate {
    private boolean isTR0Binary;
    private int binaryTR0Size;
    private int binaryTR0Position;
    private boolean eofReached;
    private byte[] binaryTR0Buffer;

    HSpiceOut() {
    }

    protected Simulation.SimData readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        List pa0List = this.readPA0File(fileURL);
        HSpiceOut.startProgressDialog("HSpice output", fileURL.getFile());
        Simulation.SimData sd = this.readTR0File(fileURL, pa0List, cell);
        HSpiceOut.stopProgressDialog();
        return sd;
    }

    private List readPA0File(URL fileURL) throws IOException {
        String nextLine;
        String tr0File = fileURL.getFile();
        String pa0File = null;
        pa0File = tr0File.endsWith(".tr0") ? tr0File.substring(0, tr0File.length() - 4) + ".pa0" : tr0File + ".pa0";
        URL pa0URL = null;
        try {
            pa0URL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), pa0File);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (pa0URL == null) {
            return null;
        }
        if (!TextUtils.URLExists(pa0URL)) {
            return null;
        }
        if (this.openTextInput(pa0URL)) {
            return null;
        }
        ArrayList<PA0Line> pa0List = new ArrayList<PA0Line>();
        while ((nextLine = this.lineReader.readLine()) != null) {
            String trimLine = nextLine.trim();
            int spacePos = trimLine.indexOf(32);
            if (spacePos <= 0) continue;
            PA0Line pl = new PA0Line();
            pl.number = TextUtils.atoi(trimLine, 0, 10);
            pl.string = trimLine.substring(spacePos + 1).trim();
            pa0List.add(pl);
        }
        this.closeInput();
        return pa0List;
    }

    private Simulation.SimData readTR0File(URL fileURL, List pa0List, Cell cell) throws IOException {
        int j;
        int l;
        int l2;
        int j2;
        int k;
        int k2;
        int j3;
        int j4;
        if (this.openBinaryInput(fileURL)) {
            return null;
        }
        StringBuffer line = new StringBuffer();
        for (int j5 = 0; j5 < 4; ++j5) {
            line.append((char)this.getByteFromFile());
        }
        int nodcnt = TextUtils.atoi(line.toString(), 0, 10);
        line = new StringBuffer();
        for (int j6 = 0; j6 < 4; ++j6) {
            line.append((char)this.getByteFromFile());
        }
        int numnoi = TextUtils.atoi(line.toString(), 0, 10);
        line = new StringBuffer();
        for (j4 = 0; j4 < 4; ++j4) {
            line.append((char)this.getByteFromFile());
        }
        line = new StringBuffer();
        for (j4 = 0; j4 < 4; ++j4) {
            line.append((char)this.getByteFromFile());
        }
        int multiplier = TextUtils.atoi(line.toString(), 0, 10);
        int numSignals = numnoi + (nodcnt += multiplier * 10000) - 1;
        line = new StringBuffer();
        for (int j7 = 0; j7 < 4; ++j7) {
            line.append((char)this.getByteFromFile());
        }
        int version = TextUtils.atoi(line.toString(), 0, 10);
        for (j3 = 0; j3 < 76; ++j3) {
            k2 = this.getByteFromFile();
            if (this.isTR0Binary || k2 != 10) continue;
            --j3;
        }
        for (j3 = 0; j3 < 16; ++j3) {
            this.getByteFromFile();
        }
        for (j3 = 0; j3 < 72; ++j3) {
            k2 = this.getByteFromFile();
            if (this.isTR0Binary || k2 != 10) continue;
            --j3;
        }
        line = new StringBuffer();
        for (j3 = 0; j3 < 4; ++j3) {
            line.append((char)this.getByteFromFile());
        }
        int sweepcnt = TextUtils.atoi(line.toString(), 0, 10);
        for (int j8 = 0; j8 < 76; ++j8) {
            int k3 = this.getByteFromFile();
            if (this.isTR0Binary || k3 != 10) continue;
            --j8;
        }
        int important = numnoi;
        String[] signalNames = new String[numSignals];
        int[] signalTypes = new int[numSignals];
        for (k = 0; k <= numSignals; ++k) {
            line = new StringBuffer();
            for (j2 = 0; j2 < 8; ++j2) {
                l2 = this.getByteFromFile();
                line.append((char)l2);
                if (this.isTR0Binary || l2 != 10) continue;
                --j2;
            }
            if (k == 0) continue;
            l = k - nodcnt;
            if (k < nodcnt) {
                l = k + numnoi - 1;
            }
            signalTypes[l] = TextUtils.atoi(line.toString(), 0, 10);
        }
        for (k = 0; k <= numSignals; ++k) {
            j2 = 0;
            line = new StringBuffer();
            while (true) {
                if ((l2 = this.getByteFromFile()) == 10) {
                    continue;
                }
                if (l2 == 32) break;
                line.append((char)l2);
                if (++j2 >= 16) break;
            }
            l2 = (j2 + 15) / 16 * 16 - 1;
            while (j2 < l2) {
                int i = this.getByteFromFile();
                if (!this.isTR0Binary && i == 10) {
                    --j2;
                }
                ++j2;
            }
            if (k == 0) continue;
            for (j2 = 0; j2 < line.length() && line.charAt(j2) != ':' && Character.isDigit(line.charAt(j2)); ++j2) {
            }
            if (j2 < line.length() && line.charAt(j2) == ':') {
                l2 = TextUtils.atoi(line.toString(), 0, 10);
                PA0Line foundPA0Line = null;
                Iterator it = pa0List.iterator();
                while (it.hasNext()) {
                    PA0Line pa0Line = (PA0Line)it.next();
                    if (pa0Line.number != l2) continue;
                    foundPA0Line = pa0Line;
                    break;
                }
                if (foundPA0Line != null) {
                    StringBuffer newSB = new StringBuffer();
                    newSB.append(foundPA0Line.string);
                    newSB.append(line.substring(j2 + 1));
                    line = new StringBuffer();
                    line.append(newSB.toString());
                }
            }
            l2 = k < nodcnt ? k + numnoi - 1 : k - nodcnt;
            signalNames[l2] = line.toString();
        }
        line = new StringBuffer();
        if (!this.isTR0Binary) {
            j = 0;
            while ((l = this.getByteFromFile()) != 10) {
                if (j < 4) {
                    line.append(l);
                }
                ++j;
            }
        } else {
            for (j = 0; j < 4; ++j) {
                line.append((char)this.getByteFromFile());
            }
        }
        if (!line.toString().equals("$&%#")) {
            System.out.println("HSPICE header improperly terminated (got " + line.toString() + ")");
            this.closeInput();
            return null;
        }
        this.resetBinaryTR0Reader();
        Simulation.SimData sd = new Simulation.SimData();
        sd.setCell(cell);
        this.eofReached = false;
        ArrayList<Double> timeValues = new ArrayList<Double>();
        for (int k4 = 0; k4 < numSignals; ++k4) {
            Simulation.SimAnalogSignal as = new Simulation.SimAnalogSignal(sd);
            as.setCommonTimeUse(true);
            int lastDotPos = signalNames[k4].lastIndexOf(46);
            if (lastDotPos >= 0) {
                as.setSignalContext(signalNames[k4].substring(0, lastDotPos));
                as.setSignalName(signalNames[k4].substring(lastDotPos + 1));
            } else {
                as.setSignalName(signalNames[k4]);
            }
            as.tempList = new ArrayList();
        }
        block20: do {
            double time = this.getHSpiceFloat();
            if (this.eofReached) break;
            timeValues.add(new Double(time));
            for (int k5 = 1; k5 <= numSignals; ++k5) {
                double value = this.getHSpiceFloat();
                if (this.eofReached) continue block20;
                int l3 = k5 - nodcnt;
                if (k5 < nodcnt) {
                    l3 = k5 + numnoi - 1;
                }
                Simulation.SimAnalogSignal as = (Simulation.SimAnalogSignal)sd.getSignals().get(l3);
                as.tempList.add(new Double(value));
            }
        } while (!this.eofReached);
        this.closeInput();
        int numEvents = timeValues.size();
        sd.buildCommonTime(numEvents);
        for (int i = 0; i < numEvents; ++i) {
            sd.setCommonTime(i, (Double)timeValues.get(i));
        }
        for (int j9 = 0; j9 < numSignals; ++j9) {
            Simulation.SimAnalogSignal as = (Simulation.SimAnalogSignal)sd.getSignals().get(j9);
            as.buildValues(numEvents);
            for (int i = 0; i < numEvents; ++i) {
                as.setValue(i, (Double)as.tempList.get(i));
            }
            as.tempList = null;
        }
        return sd;
    }

    private void resetBinaryTR0Reader() {
        this.binaryTR0Size = 0;
        this.binaryTR0Position = 0;
    }

    private boolean readBinaryTR0Block(boolean firstbyteread) throws IOException {
        int i;
        if (!firstbyteread && this.dataInputStream.read() == -1) {
            return true;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(4);
        int blocks = 0;
        for (i = 0; i < 4; ++i) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            blocks = blocks << 8 | uval;
        }
        this.updateProgressDialog(4);
        for (i = 0; i < 4; ++i) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(4);
        int bytes = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            bytes = bytes << 8 | uval;
        }
        this.updateProgressDialog(4);
        int amtread = this.dataInputStream.read(this.binaryTR0Buffer, 0, bytes);
        if (amtread != bytes) {
            return true;
        }
        this.updateProgressDialog(bytes);
        int trailer = 0;
        for (int i4 = 0; i4 < 4; ++i4) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            trailer = trailer << 8 | uval;
        }
        if (trailer != bytes) {
            return true;
        }
        this.updateProgressDialog(4);
        this.binaryTR0Position = 0;
        this.binaryTR0Size = bytes;
        return false;
    }

    private int getByteFromFile() throws IOException {
        int i;
        if (this.byteCount == 0) {
            i = this.dataInputStream.read();
            if (i == -1) {
                return i;
            }
            this.updateProgressDialog(1);
            if (i == 0) {
                this.isTR0Binary = true;
                this.binaryTR0Buffer = new byte[8192];
                if (this.readBinaryTR0Block(true)) {
                    return -1;
                }
            } else {
                this.isTR0Binary = false;
                return i;
            }
        }
        if (this.isTR0Binary) {
            if (this.binaryTR0Position >= this.binaryTR0Size && this.readBinaryTR0Block(false)) {
                return -1;
            }
            byte val = this.binaryTR0Buffer[this.binaryTR0Position];
            ++this.binaryTR0Position;
            return val & 0xFF;
        }
        i = this.dataInputStream.read();
        this.updateProgressDialog(1);
        return i;
    }

    private double getHSpiceFloat() throws IOException {
        int fi3;
        int fi2;
        int fi1;
        if (!this.isTR0Binary) {
            StringBuffer line = new StringBuffer();
            for (int j = 0; j < 11; ++j) {
                int l = this.getByteFromFile();
                if (l == -1) {
                    this.eofReached = true;
                    return 0.0;
                }
                line.append((char)l);
                if (l != 10) continue;
                --j;
            }
            String result = line.toString();
            if (result.equals("0.10000E+31")) {
                this.eofReached = true;
                return 0.0;
            }
            return TextUtils.atof(result);
        }
        int fi0 = this.getByteFromFile() & 0xFF;
        int fi = fi0 << 24 | (fi1 = this.getByteFromFile() & 0xFF) << 16 | (fi2 = this.getByteFromFile() & 0xFF) << 8 | (fi3 = this.getByteFromFile() & 0xFF);
        float f = Float.intBitsToFloat(fi);
        if ((double)f > 1.0E30 && (double)f < 1.00000002E30) {
            this.eofReached = true;
            return 0.0;
        }
        return f;
    }

    private static class PA0Line {
        int number;
        String string;

        private PA0Line() {
        }
    }
}

