/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import java.awt.geom.Point2D;
import java.util.Iterator;

public abstract class Router {
    protected boolean verbose = false;

    protected abstract boolean planRoute(Route var1, Cell var2, RouteElement var3, Point2D var4);

    public void createRoute(Route route, Cell cell) {
        CreateRouteJob job = new CreateRouteJob(this, route, cell, this.verbose);
    }

    public abstract String toString();

    public static boolean createRouteNoJob(Route route, Cell cell, boolean verbose) {
        RouteElement finalRE;
        RouteElement e;
        if (CircuitChanges.cantEdit(cell, null, true)) {
            return false;
        }
        int arcsCreated = 0;
        int nodesCreated = 0;
        Iterator it = route.iterator();
        while (it.hasNext()) {
            e = (RouteElement)it.next();
            if (e.getAction() != RouteElement.RouteElementAction.newNode) continue;
            e.doAction();
            ++nodesCreated;
        }
        it = route.iterator();
        while (it.hasNext()) {
            e = (RouteElement)it.next();
            e.doAction();
            if (e.getAction() != RouteElement.RouteElementAction.newArc) continue;
            ++arcsCreated;
        }
        if (verbose) {
            if (arcsCreated == 1) {
                System.out.print("1 arc, ");
            } else {
                System.out.print(arcsCreated + " arcs, ");
            }
            if (nodesCreated == 1) {
                System.out.println("1 node created");
            } else {
                System.out.println(nodesCreated + " nodes created");
            }
        }
        if ((finalRE = route.getEnd()) != null) {
            Highlight.clear();
            PortInst pi = finalRE.getConnectingPort();
            if (pi != null) {
                Highlight.addElectricObject(pi, cell);
                Highlight.finished();
            }
        }
        return true;
    }

    protected static ArcProto getArcToUse(PortProto port1, PortProto port2) {
        ArcProto curAp = User.tool.getCurrentArcProto();
        PrimitiveArc uni = Generic.tech.universal_arc;
        PrimitiveArc invis = Generic.tech.invisible_arc;
        PrimitiveArc unr = Generic.tech.unrouted_arc;
        PortProto pp1 = null;
        PortProto pp2 = null;
        if (port1 == null) {
            pp1 = port2;
        } else {
            pp1 = port1;
            pp2 = port2;
        }
        if (pp1 == null && pp2 == null) {
            return null;
        }
        if (pp2 == null) {
            if (pp1.connectsTo(curAp)) {
                return curAp;
            }
            Technology tech = pp1.getParent().getTechnology();
            Iterator it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = (ArcProto)it.next();
                if (!pp1.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                return ap;
            }
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology anyTech = (Technology)it.next();
                Iterator aIt = anyTech.getArcs();
                while (aIt.hasNext()) {
                    PrimitiveArc ap = (PrimitiveArc)aIt.next();
                    if (!pp1.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                    return ap;
                }
            }
        } else {
            if (pp1.connectsTo(curAp) && pp2.connectsTo(curAp)) {
                return curAp;
            }
            Technology tech = pp1.getParent().getTechnology();
            Iterator it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = (ArcProto)it.next();
                if (!pp1.connectsTo(ap) || !pp2.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                return ap;
            }
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology anyTech = (Technology)it.next();
                Iterator aIt = anyTech.getArcs();
                while (aIt.hasNext()) {
                    PrimitiveArc ap = (PrimitiveArc)aIt.next();
                    if (!pp1.connectsTo(ap) || !pp2.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                    return ap;
                }
            }
        }
        return null;
    }

    protected static void replaceRouteElementArcPin(Route route, RouteElement bisectPinRE, RouteElement newPinRE) {
        Iterator it = route.iterator();
        while (it.hasNext()) {
            RouteElement e = (RouteElement)it.next();
            e.replaceArcEnd(bisectPinRE, newPinRE);
        }
    }

    protected static void useWidestWire(Route route, ArcProto ap) {
        double width = Router.getArcWidthToUse(route, ap);
        Iterator it = route.iterator();
        while (it.hasNext()) {
            RouteElement re = (RouteElement)it.next();
            if (re.getArcProto() != ap) continue;
            re.setArcWidth(width);
        }
    }

    protected static double getArcWidthToUse(Route route, ArcProto ap) {
        double widest = ap.getDefaultWidth();
        Iterator it = route.iterator();
        while (it.hasNext()) {
            RouteElement re = (RouteElement)it.next();
            double width = Router.getArcWidthToUse(re, ap);
            if (!(width > widest)) continue;
            widest = width;
        }
        return widest;
    }

    public static double getArcWidthToUse(PortInst pi, ArcProto ap) {
        Cell cell;
        Export export;
        PortInst exportedInst;
        double width2;
        if (pi == null) {
            return ap.getDefaultWidth();
        }
        double width = ap.getDefaultWidth();
        Iterator it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c = (Connection)it.next();
            ArcInst ai = c.getArc();
            if (ai.getProto() != ap || !(width < (newWidth = c.getArc().getWidth() - c.getArc().getProto().getWidthOffset()))) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.getProto() instanceof Cell && (width2 = Router.getArcWidthToUse(exportedInst = (export = (cell = (Cell)ni.getProto()).findExport(pi.getPortProto().getName())).getOriginalPort(), ap)) > width) {
            width = width2;
        }
        return width;
    }

    protected static double getArcWidthToUse(RouteElement re, ArcProto ap) {
        double width2;
        double width = ap.getDefaultWidth();
        double connectedWidth = re.getWidestConnectingArc(ap);
        if (re.getConnectingPort() != null && (width2 = Router.getArcWidthToUse(re.getConnectingPort(), ap)) > connectedWidth) {
            connectedWidth = width2;
        }
        if (width > connectedWidth) {
            return width;
        }
        return connectedWidth;
    }

    protected static Dimension2D getContactSize(RouteElement startRE, RouteElement endRE) {
        Dimension2D start = Router.getContactSize(startRE);
        Dimension2D end = Router.getContactSize(endRE);
        Dimension2D.Double dim = new Dimension2D.Double(start);
        if (end.getWidth() > ((Dimension2D)dim).getWidth()) {
            ((Dimension2D)dim).setSize(end.getWidth(), ((Dimension2D)dim).getHeight());
        }
        if (end.getHeight() > ((Dimension2D)dim).getHeight()) {
            ((Dimension2D)dim).setSize(((Dimension2D)dim).getWidth(), end.getHeight());
        }
        return dim;
    }

    protected static Dimension2D getContactSize(RouteElement re) {
        Iterator it;
        double width = -1.0;
        double height = -1.0;
        if (re.getAction() == RouteElement.RouteElementAction.newArc) {
            if (re.isNewArcVertical() && re.getOffsetArcWidth() > width) {
                width = re.getOffsetArcWidth();
            }
            if (re.isNewArcHorizontal() && re.getOffsetArcWidth() > height) {
                height = re.getOffsetArcWidth();
            }
        }
        if (re.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            PortInst pi = re.getConnectingPort();
            it = pi.getConnections();
            while (it.hasNext()) {
                Connection conn = (Connection)it.next();
                ArcInst arc = conn.getArc();
                Point2D head = arc.getHead().getLocation();
                Point2D tail = arc.getTail().getLocation();
                double newWidth = arc.getWidth() - arc.getProto().getWidthOffset();
                if (head.getX() == tail.getX() && newWidth > width) {
                    width = newWidth;
                }
                if (head.getY() != tail.getY() || !(newWidth > height)) continue;
                height = newWidth;
            }
        }
        if (re.getAction() == RouteElement.RouteElementAction.newNode) {
            Dimension2D dim = null;
            it = re.getNewArcs();
            while (it.hasNext()) {
                RouteElement newArcRE = (RouteElement)it.next();
                Dimension2D d = Router.getContactSize(newArcRE);
                if (dim == null) {
                    dim = d;
                }
                if (d.getWidth() > dim.getWidth()) {
                    dim.setSize(d.getWidth(), dim.getHeight());
                }
                if (!(d.getHeight() > dim.getHeight())) continue;
                dim.setSize(dim.getWidth(), d.getHeight());
            }
            return dim;
        }
        return new Dimension2D.Double(width, height);
    }

    private static class CreateRouteJob
    extends Job {
        private Route route;
        private boolean verbose;
        private Cell cell;

        protected CreateRouteJob(Router router, Route route, Cell cell, boolean verbose) {
            super(router.toString(), User.tool, Job.Type.CHANGE, cell, null, Job.Priority.USER);
            this.route = route;
            this.verbose = verbose;
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            return Router.createRouteNoJob(this.route, this.cell, this.verbose);
        }
    }
}

