/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;

public class LEInst {
    public static final Variable.Key ATTR_LEGATE = Variable.newKey("ATTR_LEGATE");
    public static final Variable.Key ATTR_LEKEEPER = Variable.newKey("ATTR_LEKEEPER");
    public static final Variable.Key ATTR_LEWIRE = Variable.newKey("ATTR_LEWIRE");
    public static final Variable.Key ATTR_LESETTINGS = Variable.newKey("ATTR_LESETTINGS");
    public static final Variable.Key ATTR_LEIGNORE = Variable.newKey("ATTR_LEIGNORE");

    public static Type getType(Nodable no, VarContext context) {
        if (LEInst.isVarValueOne(no, context, ATTR_LEGATE)) {
            return Type.LEGATE;
        }
        if (LEInst.isVarValueOne(no, context, ATTR_LEKEEPER)) {
            return Type.LEKEEPER;
        }
        if (LEInst.isVarValueOne(no, context, ATTR_LEWIRE)) {
            return Type.WIRE;
        }
        if (no.getProto() != null && no.getProto().getFunction().isTransistor()) {
            return Type.TRANSISTOR;
        }
        if (no.getProto() != null && no.getProto().getFunction() == PrimitiveNode.Function.CAPAC) {
            return Type.CAPACITOR;
        }
        if (LEInst.isVarValueOne(no, context, ATTR_LEIGNORE)) {
            return Type.IGNORE;
        }
        if (LEInst.isVarValueOne(no, context, ATTR_LESETTINGS)) {
            return Type.LESETTINGS;
        }
        return Type.UNKNOWN;
    }

    private static boolean isVarValueOne(Nodable no, VarContext context, Variable.Key key) {
        Variable var = no.getParameter(key);
        if (var == null) {
            return false;
        }
        int val = VarContext.objectToInt(context.evalVar(var), 1);
        return val == 1;
    }

    public static class Type {
        private final String name;
        public static final Type LEGATE = new Type("LE Gate");
        public static final Type LEKEEPER = new Type("LE Keeper");
        public static final Type WIRE = new Type("Wire");
        public static final Type TRANSISTOR = new Type("Transistor");
        public static final Type CAPACITOR = new Type("Capacitor");
        public static final Type IGNORE = new Type("LE Ingore");
        public static final Type LESETTINGS = new Type("LE Settings");
        public static final Type UNKNOWN = new Type("Unknown");

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

