/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.logging.Level;

public class EJob {
    static final String WAITING_NOW = "waiting now";
    static final String ABORTING = "aborting";
    Client client;
    public boolean startedByServer;
    Job.Key jobKey;
    public final Job.Type jobType;
    public final String jobName;
    public Snapshot oldSnapshot;
    public Snapshot newSnapshot;
    EditingPreferences editingPreferences;
    String progress = null;
    byte[] serializedJob;
    byte[] serializedResult;
    boolean doItOk;
    Job serverJob;
    public Job clientJob;
    State state;
    int savedHighlights = -1;
    ArrayList<Field> changedFields;

    EJob(Client connection, int jobId, Job.Type jobType, String jobName, byte[] bytes) {
        this.client = connection;
        this.jobKey = new Job.Key(connection, jobId, jobType != Job.Type.CLIENT_EXAMINE);
        this.jobType = jobType;
        this.jobName = jobName;
        this.state = State.WAITING;
        this.serializedJob = bytes;
    }

    EJob(Job job, Job.Type jobType, String jobName, EditingPreferences editingPreferences) {
        this.jobType = jobType;
        this.jobName = jobName;
        this.state = State.CLIENT_WAITING;
        this.serverJob = this.clientJob = job;
        this.editingPreferences = editingPreferences;
    }

    public Job getJob() {
        return this.clientJob != null ? this.clientJob : this.serverJob;
    }

    public Job.Inform getInform() {
        boolean isChange = this.jobType == Job.Type.CHANGE || this.jobType == Job.Type.UNDO;
        String toString = this.jobName + " (waiting)";
        long startTime = 0L;
        long endTime = 0L;
        int finished = -1;
        return new Job.Inform(this.jobKey, isChange, toString, startTime, endTime, finished);
    }

    public boolean isExamine() {
        return this.jobType == Job.Type.CLIENT_EXAMINE || this.jobType == Job.Type.SERVER_EXAMINE;
    }

    Throwable serialize(EDatabase database) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, database);
            out.writeObject(this.clientJob);
            out.flush();
            this.serializedJob = byteStream.toByteArray();
            return null;
        }
        catch (Throwable e) {
            System.out.println("ERROR: Job '" + this.jobName + "' cannot serialize parameter: " + e.getMessage());
            System.out.println("------------- Begin serialize() Exception stack trace --------------\n");
            e.printStackTrace();
            System.out.println("------------- End serialize() Exception stack trace ----------------\n");
            return e;
        }
    }

    Throwable deserializeToServer() {
        try {
            EDatabase database = EDatabase.serverDatabase();
            EObjectInputStream in = new EObjectInputStream(new ByteArrayInputStream(this.serializedJob), database);
            Job job = (Job)in.readObject();
            in.close();
            job.ejob = this;
            job.database = database;
            this.serverJob = job;
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    public Throwable deserializeToClient() {
        try {
            EDatabase database = EDatabase.clientDatabase();
            EObjectInputStream in = new EObjectInputStream(new ByteArrayInputStream(this.serializedJob), database);
            Job job = (Job)in.readObject();
            in.close();
            job.ejob = this;
            job.database = database;
            this.clientJob = job;
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    void serializeResult(EDatabase database) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, database);
            this.doItOk = true;
            out.writeObject(null);
            out.writeInt(this.changedFields.size());
            Job job = this.jobType == Job.Type.CLIENT_EXAMINE ? this.clientJob : this.serverJob;
            for (Field f : this.changedFields) {
                String fieldName = f.getName();
                Object value = f.get(job);
                out.writeUTF(fieldName);
                try {
                    out.writeObject(value);
                }
                catch (NotSerializableException e) {
                    System.out.println("ERROR: Job '" + this.jobName + "' cannot serialize returned field " + fieldName + " = " + value + " : " + e.getMessage());
                    throw e;
                }
            }
            out.close();
            this.serializedResult = byteStream.toByteArray();
        }
        catch (Throwable e) {
            Job.logger.logp(Level.WARNING, this.getClass().getName(), "serializeResult", "failure", e);
            this.serializeExceptionResult(e, database);
        }
    }

    void serializeExceptionResult(Throwable jobException, EDatabase database) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            EObjectOutputStream out = new EObjectOutputStream(byteStream, database);
            jobException.getStackTrace();
            out.writeObject(jobException);
            out.writeInt(0);
            out.close();
            this.serializedResult = byteStream.toByteArray();
        }
        catch (Throwable e) {
            Job.logger.logp(Level.WARNING, this.getClass().getName(), "serializeExceptionResult", "failure", e);
            this.serializedResult = new byte[0];
        }
    }

    public Throwable deserializeResult() {
        try {
            EObjectInputStream in = new EObjectInputStream(new ByteArrayInputStream(this.serializedResult), EDatabase.clientDatabase());
            Throwable jobException = (Throwable)in.readObject();
            int numFields = in.readInt();
            for (int i = 0; i < numFields; ++i) {
                String fieldName = in.readUTF();
                Object value = in.readObject();
                Field f = this.findField(fieldName);
                f.setAccessible(true);
                f.set(this.clientJob, value);
            }
            in.close();
            return jobException;
        }
        catch (Throwable e) {
            Job.logger.logp(Level.WARNING, this.getClass().getName(), "deserializeResult", "failure", e);
            return e;
        }
    }

    protected void fieldVariableChanged(String fieldName) {
        Field fld = this.findField(fieldName);
        fld.setAccessible(true);
        this.changedFields.add(fld);
    }

    private Field findField(String fieldName) {
        for (Class<?> jobClass = this.getJob().getClass(); jobClass != Job.class; jobClass = jobClass.getSuperclass()) {
            try {
                return jobClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CLIENT_WAITING,
        WAITING,
        RUNNING,
        SERVER_DONE,
        CLIENT_DONE;

    }
}

