/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

class Nand2_star_sy {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inbY = 4.0;
    private static final double inaY = -4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    Nand2_star_sy() {
    }

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        int i;
        int i2;
        TechType tech = stdCell.getTechType();
        sz = stdCell.roundSize(sz);
        Nand2_star_sy.error(!threshold.equals("") && !threshold.equals("HLT"), "Nand2_sy: threshold not \"\" or \"HLT\": " + threshold);
        String nm = "nand2" + threshold + "_sy";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        double lamPerSz = threshold.equals("HLT") ? 4.5 : 6.0;
        double totWid = sz * lamPerSz * 2.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand2_star_sy.error(fwP == null, "can't make " + nm + " this small: " + sz);
        int nbSeriesN = 2;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0 * (double)nbSeriesN;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand2_star_sy.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inaX = 3.5;
        double pmosX = inaX + 2.0 + 3.0 + 2.0;
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(pmosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, nand, tech);
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedMos[] nmoss = new FoldedMos[(int)Math.ceil((double)fwN.nbFolds / 2.0)];
        for (int nbFoldsN = 0; nbFoldsN < fwN.nbFolds; nbFoldsN += 2) {
            int nbSeries = 2;
            int nbFolds = 2;
            double nmosPitch = 32.0;
            double nmosX = pmosX + (double)(nbFoldsN / 2) * nmosPitch;
            FoldedNmos nmos = new FoldedNmos(nmosX, nmosY, nbFolds, nbSeries, fwN.gateWid, nand, tech);
            nmoss[nbFoldsN / 2] = nmos;
        }
        stdCell.fillDiffAndSelectNotches(nmoss, true);
        stdCell.wireVddGnd(nmoss, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, nand);
        double inbX = StdCellParams.getRightDiffX(nmoss, pmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "inb", PortCharacteristic.IN, tech.m1(), 4.0, inbX, 4.0);
        TrackRouterH inb = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, nand);
        inb.connect(nand.findExport("inb"));
        for (i2 = 0; i2 < nmoss.length; ++i2) {
            inb.connect(nmoss[i2].getGate(1, 'T'), tech.getPolyLShapeOffset());
            inb.connect(nmoss[i2].getGate(3, 'T'), -tech.getPolyLShapeOffset());
        }
        for (i2 = 0; i2 < pmos.nbGates(); ++i2) {
            if (i2 % 4 == 1) {
                inb.connect(pmos.getGate(i2, 'B'), -tech.getPolyLShapeOffset());
                continue;
            }
            if (i2 % 4 != 2) continue;
            inb.connect(pmos.getGate(i2, 'B'), 0.5);
        }
        LayoutLib.newExport(nand, "ina", PortCharacteristic.IN, tech.m1(), 4.0, inaX, -4.0);
        TrackRouterH inA = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, nand);
        inA.connect(nand.findExport("ina"));
        for (i = 0; i < nmoss.length; ++i) {
            for (int j = 0; j < nmoss[i].nbGates(); j += 2) {
                inA.connect(nmoss[i].getGate(j, 'T'), -tech.getPolyLShapeOffset());
            }
        }
        for (i = 0; i < pmos.nbGates(); ++i) {
            if (i % 4 == 0) {
                inA.connect(pmos.getGate(i, 'B'), -tech.getPolyLShapeOffset());
                continue;
            }
            if (i % 4 != 3) continue;
            double offset = 6.5;
            PortInst g = pmos.getGate(i, 'B');
            double gX = LayoutLib.roundCenterX(g) + offset;
            if (inbX - gX < 7.0) {
                offset -= 7.0 - (inbX - gX);
            }
            ((TrackRouter)inA).connect(g, offset, tech.getPolyLShapeOffset());
        }
        double outX = inbX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, nand);
        outHi.connect(nand.findExport("out"));
        for (int i3 = 1; i3 < pmos.nbSrcDrns(); i3 += 2) {
            outHi.connect(pmos.getSrcDrn(i3));
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, nand);
        outLo.connect(nand.findExport("out"));
        for (int i4 = 0; i4 < nmoss.length; ++i4) {
            outLo.connect(nmoss[i4].getSrcDrn(1));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

