/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIF
extends Input {
    private static final int MAXMMSTACK = 50;
    private static final int BIGSIGNED = 0xCCCCCCB;
    private static final int NOERROR = 100;
    private static final int NUMTOOBIG = 101;
    private static final int NOUNSIGNED = 102;
    private static final int NOSIGNED = 103;
    private static final int NOSEMI = 104;
    private static final int NOPATH = 105;
    private static final int BADTRANS = 106;
    private static final int BADUSER = 107;
    private static final int BADCOMMAND = 108;
    private static final int INTERNAL = 109;
    private static final int BADDEF = 110;
    private static final int NOLAYER = 111;
    private static final int BADCOMMENT = 112;
    private static final int BADAXIS = 113;
    private static final int NESTDEF = 114;
    private static final int NESTDD = 115;
    private static final int NODEFSTART = 116;
    private static final int NESTEND = 117;
    private static final int NOSPACE = 118;
    private static final int NONAME = 119;
    private static final int SYNTAXERROR = 1;
    private static final int WIRECOM = 2;
    private static final int BOXCOM = 3;
    private static final int POLYCOM = 4;
    private static final int FLASHCOM = 5;
    private static final int DEFSTART = 6;
    private static final int DEFEND = 7;
    private static final int DELETEDEF = 8;
    private static final int LAYER = 9;
    private static final int CALLCOM = 10;
    private static final int COMMENT = 11;
    private static final int NULLCOMMAND = 12;
    private static final int USERS = 13;
    private static final int END = 14;
    private static final int ENDFILE = 15;
    private static final int SYMNAME = 16;
    private static final int INSTNAME = 17;
    private static final int GEONAME = 18;
    private static final int LABELCOM = 19;
    private FrontTransformType MIRROR = new FrontTransformType();
    private FrontTransformType TRANSLATE = new FrontTransformType();
    private FrontTransformType ROTATE = new FrontTransformType();
    private static final int FATALINTERNAL = 0;
    private static final int FATALSYNTAX = 1;
    private static final int FATALSEMANTIC = 2;
    private static final int FATALOUTPUT = 3;
    private static final int ADVISORY = 4;
    private static final int TIDENT = 0;
    private static final int TROTATE = 1;
    private static final int TTRANSLATE = 2;
    private static final int TMIRROR = 4;
    private static final int CSTART = 0;
    private static final int CEND = 1;
    private static final int CBOX = 4;
    private static final int CPOLY = 5;
    private static final int CGNAME = 7;
    private static final int CLABEL = 8;
    private static final int CCALL = 9;
    private static final int MIRX = 1;
    private static final int MIRY = 2;
    private static final int TRANS = 3;
    private static final int ROT = 4;
    private BackCIFTransform currentCTrans;
    private BackCIFList currentFrontList = null;
    private BackCIFList currentFrontElement;
    private FrontItem currentItemList;
    private double cellScaleFactor;
    private FrontSymbol currentFrontSymbol;
    private Layer backupLayer;
    private boolean symbolNamed;
    private boolean errorFound;
    private int errorType;
    private boolean isInCellDefinition;
    private boolean endIsSeen;
    private int charactersRead;
    private boolean resetInputBuffer;
    private int numFatalErrors;
    private boolean numNullLayerErrors;
    private boolean ignoreStatements;
    private boolean namePending;
    private boolean endCommandFound;
    private Layer currentLayer;
    private HashMap<Integer, FrontSymbol> symbolTable;
    private FrontMatrix matrixStackTop;
    private int nextInputCharacter;
    private boolean statementsSince91;
    private int minMaxStackPtr;
    private int[] minMaxStackLeft;
    private int[] minMaxStackRight;
    private int[] minMaxStackBottom;
    private int[] minMaxStackTop;
    private HashMap<Integer, BackCIFCell> cifCellMap;
    private BackCIFCell currentBackCell;
    private Technology curTech;
    private HashMap<String, Layer> cifLayerNames;
    private HashSet<String> unknownLayerNames;
    private Cell cellBeingBuilt;
    private String currentNodeProtoName;
    private StringBuffer inputBuffer;
    private CIFPreferences localPrefs;

    CIF(CIFPreferences ap) {
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        CIF.setProgressNote("Reading CIF file");
        this.cifCellMap = new HashMap();
        this.curTech = tech;
        if (this.initFind()) {
            return null;
        }
        if (this.interpret()) {
            return null;
        }
        CIF.setProgressNote("Storing CIF in database...");
        if (this.listToNodes(lib)) {
            return null;
        }
        this.doneInterpreter();
        return lib;
    }

    private boolean listToNodes(Library lib) {
        this.cellBeingBuilt = null;
        this.currentFrontElement = this.currentFrontList;
        while (this.currentFrontElement != null) {
            if (this.currentFrontElement.identity == 0) {
                this.cellBeingBuilt = this.nodesStart(lib);
                if (this.cellBeingBuilt == null) {
                    return true;
                }
            } else if (this.currentFrontElement.identity == 1) {
                this.cellBeingBuilt = null;
            } else {
                if (this.cellBeingBuilt == null) {
                    this.cellBeingBuilt = lib.findNodeProto("TOP_LEVEL_UNNAMED{lay}");
                    if (this.cellBeingBuilt == null) {
                        this.cellBeingBuilt = Cell.newInstance(lib, "TOP_LEVEL_UNNAMED{lay}");
                        if (this.cellBeingBuilt == null) break;
                        this.currentBackCell = this.makeBackCIFCell(9999);
                    }
                    this.currentBackCell.addr = this.cellBeingBuilt;
                }
                if (this.currentFrontElement.identity == 4 ? this.nodesBox() : (this.currentFrontElement.identity == 5 ? this.nodesPoly() : this.currentFrontElement.identity == 9 && this.nodesCall())) {
                    return true;
                }
            }
            this.currentFrontElement = this.currentFrontElement.next;
        }
        return false;
    }

    private Cell nodesStart(Library lib) {
        BackCIFStart cs = (BackCIFStart)this.currentFrontElement.member;
        BackCIFCell cifCell = this.makeBackCIFCell(cs.cIndex);
        cifCell.l = cs.l;
        cifCell.r = cs.r;
        cifCell.b = cs.b;
        cifCell.t = cs.t;
        this.currentNodeProtoName = cs.name;
        StringBuffer properName = new StringBuffer();
        for (int i = 0; i < this.currentNodeProtoName.length(); ++i) {
            char chr = this.currentNodeProtoName.charAt(i);
            if (Character.isWhitespace(chr) || chr == ':' || chr == ';') {
                chr = 'X';
            }
            properName.append(chr);
        }
        this.currentNodeProtoName = properName.toString();
        cifCell.addr = Cell.newInstance(lib, this.currentNodeProtoName + "{lay}");
        if (cifCell.addr == null) {
            System.out.println("Cannot create the cell " + this.currentNodeProtoName);
            return null;
        }
        return cifCell.addr;
    }

    private boolean nodesCall() {
        BackCIFCall cc = (BackCIFCall)this.currentFrontElement.member;
        BackCIFCell cell = this.findBackCIFCell(cc.cIndex);
        if (cell == null) {
            System.out.println("Referencing an undefined cell");
            return true;
        }
        int rot = 0;
        boolean trans = false;
        int l = cell.l;
        int r = cell.r;
        int b = cell.b;
        int t = cell.t;
        BackCIFTransform ctrans = cc.list;
        while (ctrans != null) {
            switch (ctrans.type) {
                case 1: {
                    int temp = l;
                    l = -r;
                    r = -temp;
                    rot = trans ? (rot + 2700) % 3600 : (rot + 900) % 3600;
                    trans = !trans;
                    break;
                }
                case 2: {
                    int temp = t;
                    t = -b;
                    b = -temp;
                    rot = trans ? (rot + 900) % 3600 : (rot + 2700) % 3600;
                    trans = !trans;
                    break;
                }
                case 3: {
                    l += ctrans.x;
                    r += ctrans.x;
                    b += ctrans.y;
                    t += ctrans.y;
                    break;
                }
                case 4: {
                    int deg = GenMath.figureAngle(new Point2D.Double(0.0, 0.0), new Point2D.Double(ctrans.x, ctrans.y));
                    if (deg == 0) break;
                    int hlen = Math.abs((l - r) / 2);
                    int hwid = Math.abs((b - t) / 2);
                    int cenX = (l + r) / 2;
                    int cenY = (b + t) / 2;
                    Point pt = new Point(cenX, cenY);
                    this.rotateLayer(pt, deg);
                    cenX = pt.x;
                    cenY = pt.y;
                    l = cenX - hlen;
                    r = cenX + hlen;
                    b = cenY - hwid;
                    t = cenY + hwid;
                    rot += trans ? -deg : deg;
                }
            }
            ctrans = ctrans.next;
        }
        while (rot >= 3600) {
            rot -= 3600;
        }
        while (rot < 0) {
            rot += 3600;
        }
        double lX = this.convertFromCentimicrons(l);
        double hX = this.convertFromCentimicrons(r);
        double lY = this.convertFromCentimicrons(b);
        double hY = this.convertFromCentimicrons(t);
        double x = (lX + hX) / 2.0;
        double y = (lY + hY) / 2.0;
        double sX = hX - lX;
        double sY = hY - lY;
        ERectangle bounds = cell.addr.getBounds();
        sX = ((RectangularShape)bounds).getWidth();
        sY = ((RectangularShape)bounds).getHeight();
        Orientation or = Orientation.fromC(rot, trans);
        AffineTransform ctrTrans = or.rotateAbout(x, y);
        Point2D.Double spin = new Point2D.Double(x - bounds.getCenterX(), y - bounds.getCenterY());
        ctrTrans.transform(spin, spin);
        x = ((Point2D)spin).getX();
        y = ((Point2D)spin).getY();
        NodeInst ni = NodeInst.makeInstance(cell.addr, new Point2D.Double(x, y), sX, sY, this.currentBackCell.addr, or, null);
        if (ni == null) {
            System.out.println("Problems creating an instance of " + cell.addr + " in " + this.currentBackCell.addr);
            return true;
        }
        return false;
    }

    private boolean nodesPoly() {
        double sY;
        double sX;
        double highY;
        double lowY;
        double y;
        double highX;
        BackCIFPoly cp = (BackCIFPoly)this.currentFrontElement.member;
        if (cp.lim == 0) {
            return false;
        }
        NodeProto np = this.findPrototype(cp.lay);
        int lx = cp.x[0];
        int hx = cp.x[0];
        int ly = cp.y[0];
        int hy = cp.y[0];
        for (int i = 1; i < cp.lim; ++i) {
            if (cp.x[i] < lx) {
                lx = cp.x[i];
            }
            if (cp.x[i] > hx) {
                hx = cp.x[i];
            }
            if (cp.y[i] < ly) {
                ly = cp.y[i];
            }
            if (cp.y[i] <= hy) continue;
            hy = cp.y[i];
        }
        double lowX = this.convertFromCentimicrons(lx);
        double x = (lowX + (highX = this.convertFromCentimicrons(hx))) / 2.0;
        NodeInst newni = NodeInst.makeInstance(np, new Point2D.Double(x, y = ((lowY = this.convertFromCentimicrons(ly)) + (highY = this.convertFromCentimicrons(hy))) / 2.0), sX = highX - lowX, sY = highY - lowY, this.currentBackCell.addr);
        if (newni == null) {
            System.out.println("Problems creating a polygon on layer " + cp.lay + " in " + this.currentBackCell.addr);
            return true;
        }
        Point2D[] points = new EPoint[cp.lim];
        for (int i = 0; i < cp.lim; ++i) {
            points[i] = new EPoint(this.convertFromCentimicrons(cp.x[i]), this.convertFromCentimicrons(cp.y[i]));
        }
        newni.setTrace(points);
        return false;
    }

    private void rotateLayer(Point pt, int deg) {
        if (pt.x == 0 && pt.y == 0) {
            return;
        }
        switch (deg) {
            case 0: 
            case 3600: {
                break;
            }
            case 900: {
                int temp = pt.x;
                pt.x = -pt.y;
                pt.y = temp;
                break;
            }
            case 1800: {
                pt.x = -pt.x;
                pt.y = -pt.y;
                break;
            }
            case 2700: {
                int temp = pt.x;
                pt.x = pt.y;
                pt.y = -temp;
                break;
            }
            default: {
                double factx = 1.0;
                double facty = 1.0;
                while (Math.abs((double)pt.x / factx) > 1000.0) {
                    factx *= 10.0;
                }
                while (Math.abs((double)pt.y / facty) > 1000.0) {
                    facty *= 10.0;
                }
                double fact = factx > facty ? facty : factx;
                double fx = (double)pt.x / fact;
                double fy = (double)pt.y / fact;
                double vlen = fact * Math.hypot(fx, fy);
                double vang = (double)(deg + GenMath.figureAngle(new Point2D.Double(0.0, 0.0), new Point2D.Double(pt.x, pt.y))) / 10.0 / (45.0 / Math.atan(1.0));
                pt.x = (int)(vlen * Math.cos(vang));
                pt.y = (int)(vlen * Math.sin(vang));
            }
        }
    }

    private void outputPolygon(Layer lay, FrontPath pPath) {
        int lim = pPath.pLength;
        if (lim < 3) {
            return;
        }
        this.placeCIFList(5);
        BackCIFPoly cp = (BackCIFPoly)this.currentFrontElement.member;
        cp.lay = lay;
        cp.x = new int[lim];
        cp.y = new int[lim];
        cp.lim = lim;
        for (int i = 0; i < lim; ++i) {
            Point temp = this.removePoint(pPath);
            cp.x[i] = temp.x;
            cp.y[i] = temp.y;
        }
    }

    private double convertFromCentimicrons(double v) {
        return TextUtils.convertFromDistance(v / 100.0, this.curTech, TextUtils.UnitScale.MICRO);
    }

    private boolean nodesBox() {
        Orientation orient;
        double wid;
        double len;
        double y;
        BackCIFBox cb = (BackCIFBox)this.currentFrontElement.member;
        NodeProto node = this.findPrototype(cb.lay);
        if (node == null) {
            String layname = cb.lay.getName();
            System.out.println("Cannot find primitive to use for layer '" + layname + "' (number " + cb.lay + ")");
            return true;
        }
        int r = GenMath.figureAngle(new Point2D.Double(0.0, 0.0), new Point2D.Double(cb.xRot, cb.yRot));
        double x = this.convertFromCentimicrons(cb.cenX);
        NodeInst ni = NodeInst.makeInstance(node, new Point2D.Double(x, y = this.convertFromCentimicrons(cb.cenY)), len = this.convertFromCentimicrons(cb.length), wid = this.convertFromCentimicrons(cb.width), this.currentBackCell.addr, orient = Orientation.fromAngle(r), null);
        if (ni == null) {
            String layname = cb.lay.getName();
            System.out.println("Problems creating a box on layer " + layname + " in " + this.currentBackCell.addr);
            return true;
        }
        return false;
    }

    private boolean interpret() {
        this.initParser();
        this.initInterpreter();
        this.inFromFile();
        this.parseFile();
        this.doneParser();
        if (this.numFatalErrors > 0) {
            return true;
        }
        if (this.unknownLayerNames.size() > 0) {
            System.out.println("Error: these layers appear in the CIF file but are not assigned to Electric layers:");
            for (String str : this.unknownLayerNames) {
                System.out.println("    " + str);
            }
        }
        this.getInterpreterBounds();
        this.createList();
        return false;
    }

    private BackCIFCell findBackCIFCell(int cIndex) {
        return this.cifCellMap.get(new Integer(cIndex));
    }

    private BackCIFCell makeBackCIFCell(int cIndex) {
        BackCIFCell newCC = new BackCIFCell();
        newCC.addr = null;
        newCC.cIndex = cIndex;
        this.cifCellMap.put(new Integer(newCC.cIndex), newCC);
        this.currentBackCell = newCC;
        return newCC;
    }

    private NodeProto findPrototype(Layer lay) {
        return lay.getNonPseudoLayer().getPureLayerNode();
    }

    private boolean initFind() {
        this.cifLayerNames = new HashMap();
        this.unknownLayerNames = new HashSet();
        boolean valid = false;
        Iterator<Layer> it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            String cifName = layer.getCIFLayer();
            if (cifName == null || cifName.length() <= 0) continue;
            this.cifLayerNames.put(cifName, layer);
            valid = true;
        }
        if (!valid) {
            System.out.println("There are no CIF layer names assigned in the " + this.curTech.getTechName() + " technology");
            return true;
        }
        return false;
    }

    private void initInterpreter() {
        this.numNullLayerErrors = false;
        this.isInCellDefinition = false;
        this.ignoreStatements = false;
        this.namePending = false;
        this.endCommandFound = false;
        this.currentLayer = null;
        this.currentItemList = null;
        this.initUtilities();
        this.initMatrices();
    }

    private void initParser() {
        this.errorFound = false;
        this.errorType = 100;
        this.isInCellDefinition = false;
        this.endIsSeen = false;
        this.initInput();
        this.initErrors();
    }

    private void doneParser() {
        if (!this.endIsSeen) {
            this.errorReport("missing End command", 1);
        }
    }

    private int parseFile() {
        int com;
        int comCount = 1;
        while ((com = this.parseStatement()) != 14 && com != 15) {
            ++comCount;
        }
        return comCount;
    }

    private void doneInterpreter() {
        if (this.numNullLayerErrors) {
            System.out.println("Warning: some CIF objects were not read");
        }
    }

    private Rectangle getInterpreterBounds() {
        FrontItem h = this.currentItemList;
        boolean first = true;
        if (h == null) {
            this.errorReport("item list is empty!", 4);
            return null;
        }
        this.pushTransform();
        while (h != null) {
            FrontObjBase obj = h.what;
            Point temp = new Point();
            temp.x = obj.bb.l;
            temp.y = obj.bb.b;
            Point comperror = this.transformPoint(temp);
            this.initMinMax(comperror);
            temp.x = obj.bb.r;
            comperror = this.transformPoint(temp);
            this.minMax(comperror);
            temp.y = obj.bb.t;
            comperror = this.transformPoint(temp);
            this.minMax(comperror);
            temp.x = obj.bb.l;
            comperror = this.transformPoint(temp);
            this.minMax(comperror);
            int left = this.getMinMaxMinX();
            int right = this.getMinMaxMaxX();
            int bottom = this.getMinMaxMinY();
            int top = this.getMinMaxMaxY();
            this.doneMinMax();
            temp.x = left;
            temp.y = bottom;
            if (first) {
                first = false;
                this.initMinMax(temp);
            } else {
                this.minMax(temp);
            }
            temp.x = right;
            temp.y = top;
            this.minMax(temp);
            h = h.same;
        }
        Rectangle ret = new Rectangle(this.getMinMaxMinX(), this.getMinMaxMinY(), this.getMinMaxMaxX() - this.getMinMaxMinX(), this.getMinMaxMaxY() - this.getMinMaxMinY());
        this.doneMinMax();
        this.popTransform();
        return ret;
    }

    private void createList() {
        if (!this.isEndSeen()) {
            System.out.println("missing End command, assumed");
        }
        if (this.numFatalErrors > 0) {
            return;
        }
        this.sendList(this.currentItemList);
        this.currentItemList = null;
    }

    private void sendList(FrontItem list) {
        FrontItem h = list;
        while (h != null) {
            FrontItem save = h.same;
            this.outItem(h);
            h = save;
        }
    }

    private void outItem(FrontItem thing) {
        if (thing.what instanceof FrontPoly) {
            FrontPoly po = (FrontPoly)thing.what;
            FrontPath pPath = new FrontPath();
            for (int i = 0; i < po.points.length; ++i) {
                this.appendPoint(pPath, po.points[i]);
            }
            this.outputPolygon(po.layer, pPath);
            return;
        }
        if (thing.what instanceof FrontWire) {
            FrontWire wi = (FrontWire)thing.what;
            FrontPath pPath = new FrontPath();
            for (int i = 0; i < wi.points.length; ++i) {
                this.appendPoint(pPath, wi.points[i]);
            }
            this.outputWire(wi.layer, wi.width, pPath);
            return;
        }
        if (thing.what instanceof FrontFlash) {
            FrontFlash fl = (FrontFlash)thing.what;
            this.outputFlash(fl.layer, fl.diameter, fl.center);
            return;
        }
        if (thing.what instanceof FrontBox) {
            FrontBox bo = (FrontBox)thing.what;
            this.outputBox(bo.layer, bo.length, bo.width, bo.center, bo.xRot, bo.yRot);
            return;
        }
        if (thing.what instanceof FrontManBox) {
            Point temp = new Point();
            FrontManBox mb = (FrontManBox)thing.what;
            temp.x = (mb.bb.r + mb.bb.l) / 2;
            temp.y = (mb.bb.t + mb.bb.b) / 2;
            this.outputBox(mb.layer, mb.bb.r - mb.bb.l, mb.bb.t - mb.bb.b, temp, 1, 0);
            return;
        }
        if (thing.what instanceof FrontCall) {
            this.pushTransform();
            FrontCall sc = (FrontCall)thing.what;
            this.applyLocal(sc.matrix);
            FrontTransformList tList = new FrontTransformList();
            this.dupTransformList(sc.transList, tList);
            this.dumpDefinition(sc.unID);
            this.outputCall(sc.symNumber, sc.unID.name, tList);
            this.popTransform();
            return;
        }
        if (thing.what instanceof FrontGeomName) {
            FrontGeomName gn = (FrontGeomName)thing.what;
            this.outputGeomName(gn.layer);
            return;
        }
        if (thing.what instanceof FrontLabel) {
            FrontLabel la = (FrontLabel)thing.what;
            this.outputLabel(la.name, la.pos);
            return;
        }
    }

    private void outputLabel(String name, Point pt) {
        this.placeCIFList(8);
        BackCIFLabel cl = (BackCIFLabel)this.currentFrontElement.member;
        cl.label = name;
        cl.x = pt.x;
        cl.y = pt.y;
    }

    private void outputGeomName(Layer lay) {
        this.placeCIFList(7);
        BackCIFGeomName cg = (BackCIFGeomName)this.currentFrontElement.member;
        cg.lay = lay;
    }

    private void outputCall(int number, String name, FrontTransformList list) {
        this.placeCIFList(9);
        BackCIFCall cc = (BackCIFCall)this.currentFrontElement.member;
        cc.cIndex = number;
        cc.name = name;
        this.currentCTrans = null;
        cc.list = null;
        for (int i = this.getFrontTransformListLength(list); i > 0; --i) {
            if (this.newBackCIFTransform() == null) {
                return;
            }
            FrontTransformEntry temp = this.removeFrontTransformEntry(list);
            if (temp.kind == this.MIRROR) {
                if (temp.xCoord) {
                    this.currentCTrans.type = 1;
                    continue;
                }
                this.currentCTrans.type = 2;
                continue;
            }
            if (temp.kind == this.TRANSLATE) {
                this.currentCTrans.type = 3;
                this.currentCTrans.x = temp.xt;
                this.currentCTrans.y = temp.yt;
                continue;
            }
            if (temp.kind != this.ROTATE) continue;
            this.currentCTrans.type = 4;
            this.currentCTrans.x = temp.xRot;
            this.currentCTrans.y = temp.yRot;
        }
    }

    private BackCIFTransform newBackCIFTransform() {
        BackCIFTransform newCT = new BackCIFTransform();
        newCT.next = null;
        BackCIFCall cc = (BackCIFCall)this.currentFrontElement.member;
        if (cc.list == null) {
            cc.list = newCT;
        } else {
            this.currentCTrans.next = newCT;
        }
        this.currentCTrans = newCT;
        return newCT;
    }

    private void dumpDefinition(FrontSymbol sym) {
        if (sym.dumped) {
            return;
        }
        if (sym.numCalls > 0) {
            int count = sym.numCalls;
            FrontObjBase ro = sym.guts;
            while (ro != null && count > 0) {
                if (ro instanceof FrontCall) {
                    this.dumpDefinition(((FrontCall)ro).unID);
                    --count;
                }
                ro = ro.next;
            }
        }
        this.shipContents(sym);
        sym.dumped = true;
    }

    private void shipContents(FrontSymbol sym) {
        FrontObjBase ro = sym.guts;
        this.outputDefinitionStart(sym.symNumber, sym.name, sym.bounds.l, sym.bounds.r, sym.bounds.b, sym.bounds.t);
        while (ro != null) {
            int i;
            FrontPath pPath;
            if (ro instanceof FrontPoly) {
                FrontPoly po = (FrontPoly)ro;
                pPath = new FrontPath();
                for (i = 0; i < po.points.length; ++i) {
                    this.appendPoint(pPath, po.points[i]);
                }
                this.outputPolygon(po.layer, pPath);
            } else if (ro instanceof FrontWire) {
                FrontWire wi = (FrontWire)ro;
                pPath = new FrontPath();
                for (i = 0; i < wi.points.length; ++i) {
                    this.appendPoint(pPath, wi.points[i]);
                }
                this.outputWire(wi.layer, wi.width, pPath);
            } else if (ro instanceof FrontFlash) {
                FrontFlash fl = (FrontFlash)ro;
                this.outputFlash(fl.layer, fl.diameter, fl.center);
            } else if (ro instanceof FrontBox) {
                FrontBox bo = (FrontBox)ro;
                this.outputBox(bo.layer, bo.length, bo.width, bo.center, bo.xRot, bo.yRot);
            } else if (ro instanceof FrontManBox) {
                FrontManBox mb = (FrontManBox)ro;
                Point temp = new Point();
                temp.x = (((FrontManBox)ro).bb.r + ((FrontManBox)ro).bb.l) / 2;
                temp.y = (((FrontManBox)ro).bb.t + ((FrontManBox)ro).bb.b) / 2;
                this.outputBox(mb.layer, mb.bb.r - mb.bb.l, mb.bb.t - mb.bb.b, temp, 1, 0);
            } else if (ro instanceof FrontCall) {
                FrontCall sc = (FrontCall)ro;
                FrontTransformList tList = new FrontTransformList();
                this.dupTransformList(sc.transList, tList);
                this.outputCall(sc.symNumber, sc.unID.name, tList);
            } else if (ro instanceof FrontGeomName) {
                FrontGeomName gn = (FrontGeomName)ro;
                this.outputGeomName(gn.layer);
            } else if (ro instanceof FrontLabel) {
                FrontLabel la = (FrontLabel)ro;
                this.outputLabel(la.name, la.pos);
            }
            ro = ro.next;
        }
        this.outputDefinitionEnd();
    }

    private void outputDefinitionEnd() {
        this.placeCIFList(1);
    }

    private void outputDefinitionStart(int number, String name, int l, int r, int b, int t) {
        this.placeCIFList(0);
        BackCIFStart cs = (BackCIFStart)this.currentFrontElement.member;
        cs.cIndex = number;
        cs.name = name;
        cs.l = l;
        cs.r = r;
        cs.b = b;
        cs.t = t;
    }

    private void dupTransformList(FrontTransformList src, FrontTransformList dest) {
        if (src == null || dest == null) {
            return;
        }
        FrontLinkedTransform node = src.tFirst;
        while (node != null) {
            this.appendTransformEntry(dest, node.tValue);
            node = node.tNext;
        }
    }

    private void outputBox(Layer lay, int length, int width, Point center, int xRotation, int yRotation) {
        if (length == 0 && width == 0) {
            return;
        }
        this.placeCIFList(4);
        BackCIFBox cb = (BackCIFBox)this.currentFrontElement.member;
        cb.lay = lay;
        cb.length = length;
        cb.width = width;
        cb.cenX = center.x;
        cb.cenY = center.y;
        cb.xRot = xRotation;
        cb.yRot = yRotation;
    }

    private void placeCIFList(int id) {
        BackCIFList cl = this.newBackCIFList(id);
        if (cl == null) {
            return;
        }
        if (this.currentFrontList == null) {
            this.currentFrontList = this.currentFrontElement = cl;
        } else {
            while (this.currentFrontElement.next != null) {
                this.currentFrontElement = this.currentFrontElement.next;
            }
            this.currentFrontElement = this.currentFrontElement.next = cl;
        }
    }

    private BackCIFList newBackCIFList(int id) {
        BackCIFList newCL = new BackCIFList();
        newCL.next = null;
        newCL.identity = id;
        switch (id) {
            case 0: {
                BackCIFStart cs = new BackCIFStart();
                newCL.member = cs;
                cs.name = null;
                break;
            }
            case 4: {
                newCL.member = new BackCIFBox();
                break;
            }
            case 5: {
                newCL.member = new BackCIFPoly();
                break;
            }
            case 7: {
                newCL.member = new BackCIFGeomName();
                break;
            }
            case 8: {
                newCL.member = new BackCIFLabel();
                break;
            }
            case 9: {
                BackCIFCall cc = new BackCIFCall();
                newCL.member = cc;
                cc.name = null;
            }
        }
        return newCL;
    }

    private void outputFlash(Layer lay, int diameter, Point center) {
        int radius = diameter / 2;
        double fCX = center.x;
        double fCY = center.y;
        double offset = (float)diameter / 2.0f * 0.414213f;
        FrontPath fpath = new FrontPath();
        Point temp = new Point();
        temp.x = center.x - radius;
        temp.y = (int)(fCY + offset);
        this.appendPoint(fpath, temp);
        temp.y = (int)(fCY - offset);
        this.appendPoint(fpath, temp);
        temp.x = (int)(fCX - offset);
        temp.y = center.y - radius;
        this.appendPoint(fpath, temp);
        temp.x = (int)(fCX + offset);
        this.appendPoint(fpath, temp);
        temp.x = center.x + radius;
        temp.y = (int)(fCY - offset);
        this.appendPoint(fpath, temp);
        temp.y = (int)(fCY + offset);
        this.appendPoint(fpath, temp);
        temp.x = (int)(fCX + offset);
        temp.y = center.y + radius;
        this.appendPoint(fpath, temp);
        temp.x = (int)(fCX - offset);
        this.appendPoint(fpath, temp);
        this.outputPolygon(lay, fpath);
    }

    private void outputWire(Layer lay, int width, FrontPath wpath) {
        int lim = wpath.pLength;
        Point prev = this.removePoint(wpath);
        if (width != 0 && !this.localPrefs.squareWires) {
            this.boundsFlash(width, prev);
            this.outputFlash(lay, width, prev);
        }
        for (int i = 1; i < lim; ++i) {
            Point curr = this.removePoint(wpath);
            if (width != 0 && !this.localPrefs.squareWires) {
                this.boundsFlash(width, curr);
                this.outputFlash(lay, width, curr);
            }
            int xr = curr.x - prev.x;
            int yr = curr.y - prev.y;
            int len = (int)new Point2D.Double(0.0, 0.0).distance(new Point2D.Double(xr, yr));
            if (this.localPrefs.squareWires) {
                len += width;
            }
            Point center = new Point((curr.x + prev.x) / 2, (curr.y + prev.y) / 2);
            this.boundsBox(len, width, center, xr, yr);
            this.outputBox(lay, len, width, center, xr, yr);
            prev = curr;
        }
    }

    private boolean isEndSeen() {
        return this.endCommandFound;
    }

    private void initInput() {
        this.charactersRead = 0;
        this.resetInputBuffer = true;
    }

    private void initErrors() {
        this.numFatalErrors = 0;
    }

    private void initUtilities() {
        this.minMaxStackLeft = new int[50];
        this.minMaxStackRight = new int[50];
        this.minMaxStackBottom = new int[50];
        this.minMaxStackTop = new int[50];
        this.symbolTable = new HashMap();
        this.minMaxStackPtr = -1;
    }

    private void initMatrices() {
        this.matrixStackTop = new FrontMatrix();
        this.clearMatrix(this.matrixStackTop);
        this.matrixStackTop.next = null;
        this.matrixStackTop.prev = null;
        this.matrixStackTop.multiplied = true;
    }

    private void clearMatrix(FrontMatrix mat) {
        mat.a11 = 1.0;
        mat.a12 = 0.0;
        mat.a21 = 0.0;
        mat.a22 = 1.0;
        mat.a31 = 0.0;
        mat.a32 = 0.0;
        mat.a33 = 1.0;
        mat.type = 0;
        mat.multiplied = false;
    }

    private void inFromFile() {
        try {
            this.nextInputCharacter = this.lineReader.read();
            this.updateProgressDialog(1);
        }
        catch (IOException e) {
            this.nextInputCharacter = -1;
        }
    }

    private char getNextCharacter() {
        int c;
        if (this.resetInputBuffer) {
            this.resetInputBuffer = false;
            this.inputBuffer = new StringBuffer();
            this.charactersRead = 0;
        }
        if ((c = this.nextInputCharacter) >= 0) {
            if (c != 10) {
                ++this.charactersRead;
                this.inputBuffer.append((char)c);
            } else {
                this.resetInputBuffer = true;
            }
            try {
                this.nextInputCharacter = this.lineReader.read();
                this.updateProgressDialog(1);
            }
            catch (IOException e) {
                this.nextInputCharacter = -1;
            }
        }
        return (char)c;
    }

    private char peekNextCharacter() {
        return (char)this.nextInputCharacter;
    }

    private boolean atEndOfFile() {
        return this.nextInputCharacter < 0;
    }

    private int flushInput(char breakchar) {
        char c;
        while ((c = this.peekNextCharacter()) >= '\u0000' && c != breakchar) {
            this.getNextCharacter();
        }
        return c;
    }

    private void skipBlanks() {
        char c;
        while (!(this.atEndOfFile() || TextUtils.isDigit(c = this.peekNextCharacter()) || Character.isUpperCase(c) || c == '(' || c == ')' || c == ';' || c == '-')) {
            this.getNextCharacter();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseStatement() {
        if (this.atEndOfFile()) {
            return 15;
        }
        this.skipBlanks();
        char curChar = this.getNextCharacter();
        int command = 0;
        int xRotate = 0;
        int yRotate = 0;
        int length = 0;
        int width = 0;
        int diameter = 0;
        int symbolNumber = 0;
        int multiplier = 0;
        int divisor = 0;
        int userCommand = 0;
        Point center = null;
        Point namePoint = null;
        FrontTransformList curTList = null;
        FrontPath curPath = null;
        String lName = null;
        String nameText = null;
        String userText = null;
        block0 : switch (curChar) {
            case 'P': {
                command = 4;
                curPath = new FrontPath();
                this.getPath(curPath);
                if (!this.errorFound) break;
                return this.reportError();
            }
            case 'B': {
                command = 3;
                xRotate = 1;
                yRotate = 0;
                length = this.getNumber();
                if (this.errorFound) {
                    return this.reportError();
                }
                width = this.getNumber();
                if (this.errorFound) {
                    return this.reportError();
                }
                center = this.getPoint();
                if (this.errorFound) {
                    return this.reportError();
                }
                this.skipSeparators();
                curChar = this.peekNextCharacter();
                if ((curChar < '0' || curChar > '9') && curChar != '-') break;
                xRotate = this.getSignedInteger();
                if (this.errorFound) {
                    return this.reportError();
                }
                yRotate = this.getSignedInteger();
                if (!this.errorFound) break;
                return this.reportError();
            }
            case 'R': {
                command = 5;
                diameter = this.getNumber();
                if (this.errorFound) {
                    return this.reportError();
                }
                center = this.getPoint();
                if (!this.errorFound) break;
                return this.reportError();
            }
            case 'W': {
                command = 2;
                width = this.getNumber();
                if (this.errorFound) {
                    return this.reportError();
                }
                curPath = new FrontPath();
                this.getPath(curPath);
                if (!this.errorFound) break;
                return this.reportError();
            }
            case 'L': {
                char chr;
                command = 9;
                this.skipBlanks();
                StringBuffer layerName = new StringBuffer();
                for (int i = 0; i < 4 && (Character.isUpperCase(chr = this.peekNextCharacter()) || TextUtils.isDigit(chr)); ++i) {
                    layerName.append(this.getNextCharacter());
                }
                if (layerName.length() == 0) {
                    this.errorFound = true;
                    this.errorType = 111;
                    return this.reportError();
                }
                lName = layerName.toString();
                break;
            }
            case 'D': {
                this.skipBlanks();
                switch (this.getNextCharacter()) {
                    case 'S': {
                        command = 6;
                        symbolNumber = this.getNumber();
                        if (this.errorFound) {
                            return this.reportError();
                        }
                        this.skipSeparators();
                        divisor = 1;
                        multiplier = 1;
                        if (TextUtils.isDigit(this.peekNextCharacter())) {
                            multiplier = this.getNumber();
                            if (this.errorFound) {
                                return this.reportError();
                            }
                            divisor = this.getNumber();
                            if (this.errorFound) {
                                return this.reportError();
                            }
                        }
                        if (this.isInCellDefinition) {
                            this.errorFound = true;
                            this.errorType = 114;
                            return this.reportError();
                        }
                        this.isInCellDefinition = true;
                        break block0;
                    }
                    case 'F': {
                        command = 7;
                        if (!this.isInCellDefinition) {
                            this.errorFound = true;
                            this.errorType = 116;
                            return this.reportError();
                        }
                        this.isInCellDefinition = false;
                        break block0;
                    }
                    case 'D': {
                        command = 8;
                        symbolNumber = this.getNumber();
                        if (this.errorFound) {
                            return this.reportError();
                        }
                        if (!this.isInCellDefinition) break block0;
                        this.errorFound = true;
                        this.errorType = 115;
                        return this.reportError();
                    }
                    default: {
                        this.errorFound = true;
                        this.errorType = 110;
                        return this.reportError();
                    }
                }
            }
            case 'C': {
                command = 10;
                symbolNumber = this.getNumber();
                if (this.errorFound) {
                    return this.reportError();
                }
                this.skipBlanks();
                curTList = new FrontTransformList();
                while (true) {
                    FrontTransformEntry trans = new FrontTransformEntry();
                    char val = this.peekNextCharacter();
                    if (val == ';') break block0;
                    switch (this.peekNextCharacter()) {
                        case 'T': {
                            this.getNextCharacter();
                            trans.kind = this.TRANSLATE;
                            trans.xt = this.getSignedInteger();
                            if (this.errorFound) {
                                return this.reportError();
                            }
                            trans.yt = this.getSignedInteger();
                            if (this.errorFound) {
                                return this.reportError();
                            }
                            this.appendTransformEntry(curTList, trans);
                            break;
                        }
                        case 'M': {
                            trans.kind = this.MIRROR;
                            this.getNextCharacter();
                            this.skipBlanks();
                            switch (this.getNextCharacter()) {
                                case 'X': {
                                    trans.xCoord = true;
                                    break;
                                }
                                case 'Y': {
                                    trans.xCoord = false;
                                    break;
                                }
                                default: {
                                    this.errorFound = true;
                                    this.errorType = 113;
                                    return this.reportError();
                                }
                            }
                            this.appendTransformEntry(curTList, trans);
                            break;
                        }
                        case 'R': {
                            trans.kind = this.ROTATE;
                            this.getNextCharacter();
                            trans.xRot = this.getSignedInteger();
                            if (this.errorFound) {
                                return this.reportError();
                            }
                            trans.yRot = this.getSignedInteger();
                            if (this.errorFound) {
                                return this.reportError();
                            }
                            this.appendTransformEntry(curTList, trans);
                            break;
                        }
                        default: {
                            this.errorFound = true;
                            this.errorType = 106;
                            return this.reportError();
                        }
                    }
                    this.skipBlanks();
                }
            }
            case '(': {
                int level = 1;
                command = 11;
                StringBuffer comment = new StringBuffer();
                block59: while (level != 0) {
                    curChar = this.getNextCharacter();
                    switch (curChar) {
                        case '(': {
                            ++level;
                            comment.append('(');
                            continue block59;
                        }
                        case ')': {
                            if (--level == 0) continue block59;
                            comment.append(')');
                            continue block59;
                        }
                        case '\uffffffff': {
                            this.errorFound = true;
                            this.errorType = 112;
                            return this.reportError();
                        }
                    }
                    comment.append((int)curChar);
                }
                break;
            }
            case 'E': {
                this.skipBlanks();
                if (this.isInCellDefinition) {
                    this.errorFound = true;
                    this.errorType = 117;
                    return this.reportError();
                }
                if (!this.atEndOfFile()) {
                    this.errorReport("more text follows end command", 4);
                }
                this.endIsSeen = true;
                this.processEnd();
                return 14;
            }
            case ';': {
                return 12;
            }
            default: {
                if (!TextUtils.isDigit(curChar)) {
                    this.errorFound = true;
                    this.errorType = 108;
                    return this.reportError();
                }
                userCommand = curChar - 48;
                if (userCommand != 9) break;
                curChar = this.peekNextCharacter();
                if (curChar == ' ' || curChar == '\t' || curChar == '1' || curChar == '2' || curChar == '3') {
                    switch (this.getNextCharacter()) {
                        case '\t': 
                        case ' ': {
                            this.skipSpaces();
                            nameText = this.parseName();
                            if (this.errorFound) {
                                return this.reportError();
                            }
                            command = 16;
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': {
                            if (!this.skipSpaces()) {
                                this.errorFound = true;
                                this.errorType = 118;
                                return this.reportError();
                            }
                            nameText = this.parseName();
                            if (this.errorFound) {
                                return this.reportError();
                            }
                            switch (curChar) {
                                case '1': {
                                    command = 17;
                                    break;
                                }
                                case '2': {
                                    char chr;
                                    command = 18;
                                    namePoint = this.getPoint();
                                    if (this.errorFound) {
                                        return this.reportError();
                                    }
                                    this.skipBlanks();
                                    StringBuffer layName = new StringBuffer();
                                    for (int i = 0; i < 4 && (Character.isUpperCase(chr = this.peekNextCharacter()) || TextUtils.isDigit(chr)); ++i) {
                                        layName.append(this.getNextCharacter());
                                    }
                                    lName = layName.toString();
                                    break;
                                }
                                case '3': {
                                    command = 19;
                                    namePoint = this.getPoint();
                                    if (!this.errorFound) break;
                                    return this.reportError();
                                }
                            }
                            break;
                        }
                    }
                    break;
                }
                command = 13;
                userText = this.getUserText();
                if (!this.atEndOfFile()) break;
                this.errorFound = true;
                this.errorType = 107;
                return this.reportError();
            }
        }
        switch (command) {
            case 2: {
                this.makeWire(width, curPath);
                break;
            }
            case 6: {
                this.makeStartDefinition(symbolNumber, multiplier, divisor);
                break;
            }
            case 7: {
                this.makeEndDefinition();
                break;
            }
            case 8: {
                this.makeDeleteDefinition(symbolNumber);
                break;
            }
            case 10: {
                this.makeCall(symbolNumber, curTList);
                break;
            }
            case 9: {
                this.makeLayer(lName);
                break;
            }
            case 5: {
                this.makeFlash(diameter, center);
                break;
            }
            case 4: {
                this.makePolygon(curPath);
                break;
            }
            case 3: {
                this.makeBox(length, width, center, xRotate, yRotate);
                break;
            }
            case 11: {
                break;
            }
            case 13: {
                this.makeUserComment(userCommand, userText);
                break;
            }
            case 16: {
                this.makeSymbolName(nameText);
                break;
            }
            case 17: {
                this.makeInstanceName(nameText);
                break;
            }
            case 18: {
                this.makeGeomName(nameText, namePoint, this.curTech.findLayer(lName));
                break;
            }
            case 19: {
                this.makeLabel(nameText, namePoint);
                break;
            }
            default: {
                this.errorFound = true;
                this.errorType = 109;
                return this.reportError();
            }
        }
        if (!this.skipSemicolon()) {
            this.errorFound = true;
            this.errorType = 104;
            return this.reportError();
        }
        return command;
    }

    private void makeLabel(String name, Point pt) {
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            return;
        }
        if (name.length() == 0) {
            this.errorReport("null label ignored", 4);
            return;
        }
        FrontLabel obj = new FrontLabel();
        if (this.isInCellDefinition && this.cellScaleFactor != 1.0) {
            pt.x = (int)(this.cellScaleFactor * (double)pt.x);
            pt.y = (int)(this.cellScaleFactor * (double)pt.y);
        }
        obj.pos = pt;
        obj.name = name;
        this.pushTransform();
        Point temp = this.transformPoint(pt);
        this.popTransform();
        obj.bb.l = temp.x;
        obj.bb.r = temp.x;
        obj.bb.b = temp.y;
        obj.bb.t = temp.y;
        if (this.isInCellDefinition) {
            obj.next = this.currentFrontSymbol.guts;
            this.currentFrontSymbol.guts = obj;
        } else {
            this.topLevelItem(obj);
        }
    }

    private void makeGeomName(String name, Point pt, Layer lay) {
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            return;
        }
        if (name.length() == 0) {
            this.errorReport("null geometry name ignored", 4);
            return;
        }
        FrontGeomName obj = new FrontGeomName();
        obj.layer = lay;
        if (this.isInCellDefinition && this.cellScaleFactor != 1.0) {
            pt.x = (int)(this.cellScaleFactor * (double)pt.x);
            pt.y = (int)(this.cellScaleFactor * (double)pt.y);
        }
        this.pushTransform();
        Point temp = this.transformPoint(pt);
        this.popTransform();
        obj.bb.l = temp.x;
        obj.bb.r = temp.x;
        obj.bb.b = temp.y;
        obj.bb.t = temp.y;
        if (this.isInCellDefinition) {
            obj.next = this.currentFrontSymbol.guts;
            this.currentFrontSymbol.guts = obj;
        } else {
            this.topLevelItem(obj);
        }
    }

    private void makeSymbolName(String name) {
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            return;
        }
        if (!this.isInCellDefinition) {
            this.errorReport("no symbol to name", 2);
            return;
        }
        if (name.length() == 0) {
            this.errorReport("null symbol name ignored", 4);
            return;
        }
        if (this.symbolNamed) {
            this.errorReport("symbol is already named, new name ignored", 2);
            return;
        }
        this.symbolNamed = true;
        this.currentFrontSymbol.name = name;
    }

    private void makeUserComment(int command, String text) {
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            return;
        }
    }

    private void makeBox(int length, int width, Point center, int xr, int yr) {
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            return;
        }
        if (this.currentLayer == null) {
            this.numNullLayerErrors = true;
            return;
        }
        if (length == 0 || width == 0) {
            this.errorReport("box with null length or width specified, ignored", 4);
            return;
        }
        if (this.isInCellDefinition && this.cellScaleFactor != 1.0) {
            length = (int)(this.cellScaleFactor * (double)length);
            width = (int)(this.cellScaleFactor * (double)width);
            center.x = (int)(this.cellScaleFactor * (double)center.x);
            center.y = (int)(this.cellScaleFactor * (double)center.y);
        }
        Rectangle box = this.boundsBox(length, width, center, xr, yr);
        int tl = box.x;
        int tr = box.x + box.width;
        int tb = box.y;
        int tt = box.y + box.height;
        int halfW = width / 2;
        int halfL = length / 2;
        if (yr == 0 && length % 2 == 0 && width % 2 == 0 && center.x - halfL == tl && center.x + halfL == tr && center.y - halfW == tb && center.y + halfW == tt || xr == 0 && length % 2 == 0 && width % 2 == 0 && center.x - halfW == tl && center.x + halfW == tr && center.y - halfL == tb && center.y + halfL == tt) {
            FrontManBox obj = new FrontManBox();
            obj.layer = this.currentLayer;
            if (yr == 0) {
                obj.bb.l = tl;
                obj.bb.r = tr;
                obj.bb.b = tb;
                obj.bb.t = tt;
            } else {
                obj.bb.l = center.x - halfW;
                obj.bb.r = center.x + halfW;
                obj.bb.b = center.y - halfL;
                obj.bb.t = center.y + halfL;
            }
            if (this.isInCellDefinition) {
                obj.next = this.currentFrontSymbol.guts;
                this.currentFrontSymbol.guts = obj;
            } else {
                this.topLevelItem(obj);
            }
        } else {
            FrontBox obj = new FrontBox();
            obj.layer = this.currentLayer;
            obj.length = length;
            obj.width = width;
            obj.center = center;
            obj.xRot = xr;
            obj.yRot = yr;
            obj.bb.l = tl;
            obj.bb.r = tr;
            obj.bb.b = tb;
            obj.bb.t = tt;
            if (this.isInCellDefinition) {
                obj.next = this.currentFrontSymbol.guts;
                this.currentFrontSymbol.guts = obj;
            } else {
                this.topLevelItem(obj);
            }
        }
    }

    private void makeFlash(int diameter, Point center) {
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            return;
        }
        if (this.currentLayer == null) {
            this.numNullLayerErrors = true;
            return;
        }
        if (diameter == 0) {
            this.errorReport("flash with null diamter, ignored", 4);
            return;
        }
        FrontFlash obj = new FrontFlash();
        obj.layer = this.currentLayer;
        if (this.isInCellDefinition && this.cellScaleFactor != 1.0) {
            diameter = (int)(this.cellScaleFactor * (double)diameter);
            center.x = (int)(this.cellScaleFactor * (double)center.x);
            center.y = (int)(this.cellScaleFactor * (double)center.y);
        }
        obj.diameter = diameter;
        obj.center = center;
        Rectangle box = this.boundsFlash(diameter, center);
        obj.bb.l = box.x;
        obj.bb.r = box.x + box.width;
        obj.bb.b = box.y;
        obj.bb.t = box.y + box.height;
        if (this.isInCellDefinition) {
            obj.next = this.currentFrontSymbol.guts;
            this.currentFrontSymbol.guts = obj;
        } else {
            this.topLevelItem(obj);
        }
    }

    private Rectangle boundsFlash(int diameter, Point center) {
        return this.boundsBox(diameter, diameter, center, 1, 0);
    }

    private Rectangle boundsBox(int length, int width, Point center, int xr, int yr) {
        int dx = length / 2;
        int dy = width / 2;
        this.pushTransform();
        this.rotateMatrix(xr, yr);
        this.translateMatrix(center.x, center.y);
        Point temp = new Point(dx, dy);
        this.initMinMax(this.transformPoint(temp));
        temp.y = -dy;
        this.minMax(this.transformPoint(temp));
        temp.x = -dx;
        this.minMax(this.transformPoint(temp));
        temp.y = dy;
        this.minMax(this.transformPoint(temp));
        this.popTransform();
        Rectangle ret = new Rectangle(this.getMinMaxMinX(), this.getMinMaxMinY(), this.getMinMaxMaxX() - this.getMinMaxMinX(), this.getMinMaxMaxY() - this.getMinMaxMinY());
        this.doneMinMax();
        return ret;
    }

    private void makeLayer(String lName) {
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            return;
        }
        this.currentLayer = this.cifLayerNames.get(lName);
        if (this.currentLayer == null) {
            this.unknownLayerNames.add(lName);
        }
    }

    private void makeCall(int symbol, FrontTransformList list) {
        if (this.ignoreStatements) {
            return;
        }
        int j = this.getFrontTransformListLength(list);
        FrontTransformList newtlist = null;
        if (j != 0) {
            newtlist = new FrontTransformList();
        }
        this.pushTransform();
        for (int i = 1; i <= j; ++i) {
            FrontTransformEntry temp = this.removeFrontTransformEntry(list);
            if (temp.kind == this.MIRROR) {
                this.mirrorMatrix(temp.xCoord);
            } else if (temp.kind == this.TRANSLATE) {
                if (this.isInCellDefinition && this.cellScaleFactor != 1.0) {
                    temp.xt = (int)(this.cellScaleFactor * (double)temp.xt);
                    temp.yt = (int)(this.cellScaleFactor * (double)temp.yt);
                }
                this.translateMatrix(temp.xt, temp.yt);
            } else if (temp.kind == this.ROTATE) {
                this.rotateMatrix(temp.xRot, temp.yRot);
            } else {
                this.errorReport("interpreter: no such transformation", 0);
            }
            this.appendTransformEntry(newtlist, temp);
        }
        FrontCall obj = new FrontCall();
        obj.matrix = new FrontMatrix();
        obj.matrix.a11 = this.matrixStackTop.a11;
        obj.matrix.a12 = this.matrixStackTop.a12;
        obj.matrix.a21 = this.matrixStackTop.a21;
        obj.matrix.a22 = this.matrixStackTop.a22;
        obj.matrix.a31 = this.matrixStackTop.a31;
        obj.matrix.a32 = this.matrixStackTop.a32;
        obj.matrix.a33 = this.matrixStackTop.a33;
        obj.matrix.type = this.matrixStackTop.type;
        obj.matrix.multiplied = this.matrixStackTop.multiplied;
        this.popTransform();
        obj.symNumber = symbol;
        obj.unID = null;
        obj.transList = newtlist;
        if (this.namePending) {
            if (this.statementsSince91) {
                this.errorReport("statements between name and instance", 4);
            }
            this.namePending = false;
        }
        if (this.isInCellDefinition) {
            obj.next = this.currentFrontSymbol.guts;
            this.currentFrontSymbol.guts = obj;
            ++this.currentFrontSymbol.numCalls;
        } else {
            this.topLevelItem(obj);
        }
    }

    private void rotateMatrix(int xRot, int yRot) {
        double si = yRot;
        double co = xRot;
        if (yRot == 0 && xRot >= 0) {
            return;
        }
        this.matrixStackTop.type |= 1;
        if (xRot == 0) {
            double temp = this.matrixStackTop.a11;
            this.matrixStackTop.a11 = -this.matrixStackTop.a12;
            this.matrixStackTop.a12 = temp;
            temp = this.matrixStackTop.a21;
            this.matrixStackTop.a21 = -this.matrixStackTop.a22;
            this.matrixStackTop.a22 = temp;
            temp = this.matrixStackTop.a31;
            this.matrixStackTop.a31 = -this.matrixStackTop.a32;
            this.matrixStackTop.a32 = temp;
            if (yRot < 0) {
                this.matrixStackTop.a33 = -this.matrixStackTop.a33;
            }
        } else if (yRot == 0) {
            this.matrixStackTop.a33 = -this.matrixStackTop.a33;
        } else {
            double temp = this.matrixStackTop.a11 * co - this.matrixStackTop.a12 * si;
            this.matrixStackTop.a12 = this.matrixStackTop.a11 * si + this.matrixStackTop.a12 * co;
            this.matrixStackTop.a11 = temp;
            temp = this.matrixStackTop.a21 * co - this.matrixStackTop.a22 * si;
            this.matrixStackTop.a22 = this.matrixStackTop.a21 * si + this.matrixStackTop.a22 * co;
            this.matrixStackTop.a21 = temp;
            temp = this.matrixStackTop.a31 * co - this.matrixStackTop.a32 * si;
            this.matrixStackTop.a32 = this.matrixStackTop.a31 * si + this.matrixStackTop.a32 * co;
            this.matrixStackTop.a31 = temp;
            this.matrixStackTop.a33 = new Point2D.Double(0.0, 0.0).distance(new Point2D.Double(co, si));
        }
    }

    private void translateMatrix(int xtrans, int ytrans) {
        if (xtrans != 0 || ytrans != 0) {
            this.matrixStackTop.a31 += this.matrixStackTop.a33 * (double)xtrans;
            this.matrixStackTop.a32 += this.matrixStackTop.a33 * (double)ytrans;
            this.matrixStackTop.type |= 2;
        }
    }

    private void mirrorMatrix(boolean xCoord) {
        if (xCoord) {
            this.matrixStackTop.a11 = -this.matrixStackTop.a11;
            this.matrixStackTop.a21 = -this.matrixStackTop.a21;
            this.matrixStackTop.a31 = -this.matrixStackTop.a31;
        } else {
            this.matrixStackTop.a12 = -this.matrixStackTop.a12;
            this.matrixStackTop.a22 = -this.matrixStackTop.a22;
            this.matrixStackTop.a32 = -this.matrixStackTop.a32;
        }
        this.matrixStackTop.type |= 4;
    }

    private int getFrontTransformListLength(FrontTransformList a) {
        if (a == null) {
            return 0;
        }
        return a.tLength;
    }

    private FrontTransformEntry removeFrontTransformEntry(FrontTransformList a) {
        if (a.tFirst == null) {
            FrontTransformEntry ans = new FrontTransformEntry();
            ans.kind = this.TRANSLATE;
            ans.yt = 0;
            ans.xt = 0;
            return ans;
        }
        FrontLinkedTransform temp = a.tFirst.tNext;
        FrontTransformEntry ans = a.tFirst.tValue;
        a.tFirst = temp;
        if (a.tFirst == null) {
            a.tLast = null;
        }
        --a.tLength;
        return ans;
    }

    private void makeDeleteDefinition(int n) {
        this.statementsSince91 = true;
        this.errorReport("DD not supported (ignored)", 4);
    }

    private void makeEndDefinition() {
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            this.ignoreStatements = false;
            return;
        }
        this.isInCellDefinition = false;
        this.currentLayer = this.backupLayer;
        if (!this.symbolNamed) {
            String s;
            this.currentFrontSymbol.name = s = "SYM" + this.currentFrontSymbol.symNumber;
        }
        this.currentFrontSymbol.defined = true;
    }

    private void makeStartDefinition(int symbol, int mtl, int div) {
        this.statementsSince91 = true;
        this.currentFrontSymbol = this.lookupSymbol(symbol);
        if (this.currentFrontSymbol.defined) {
            String mess = "attempt to redefine symbol " + symbol + " (ignored)";
            this.errorReport(mess, 4);
            this.ignoreStatements = true;
            return;
        }
        this.isInCellDefinition = true;
        if (mtl != 0 && div != 0) {
            this.cellScaleFactor = (float)mtl / (float)div;
        } else {
            this.errorReport("illegal scale factor, ignored", 4);
            this.cellScaleFactor = 1.0;
        }
        this.backupLayer = this.currentLayer;
        this.currentLayer = null;
        this.symbolNamed = false;
    }

    private void makeWire(int width, FrontPath a) {
        int length = a.pLength;
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            return;
        }
        if (this.currentLayer == null) {
            this.numNullLayerErrors = true;
            return;
        }
        FrontWire obj = new FrontWire();
        FrontPath tPath = a;
        FrontPath sPath = null;
        obj.layer = this.currentLayer;
        if (this.isInCellDefinition && this.cellScaleFactor != 1.0) {
            sPath = new FrontPath();
            this.scalePath(a, sPath);
            width = (int)(this.cellScaleFactor * (double)width);
            tPath = sPath;
        }
        obj.width = width;
        FrontPath bbpath = new FrontPath();
        this.copyPath(tPath, bbpath);
        this.boundsWire(width, bbpath);
        obj.points = new Point[length];
        for (int i = 0; i < length; ++i) {
            obj.points[i] = this.removePoint(tPath);
        }
        if (this.isInCellDefinition) {
            obj.next = this.currentFrontSymbol.guts;
            this.currentFrontSymbol.guts = obj;
        } else {
            this.topLevelItem(obj);
        }
    }

    private Rectangle boundsWire(int width, FrontPath pPath) {
        int half = (width + 1) / 2;
        int limit = pPath.pLength;
        this.pushTransform();
        this.initMinMax(this.transformPoint(this.removePoint(pPath)));
        for (int i = 1; i < limit; ++i) {
            this.minMax(this.transformPoint(this.removePoint(pPath)));
        }
        this.popTransform();
        Rectangle rect = new Rectangle(this.getMinMaxMinX() - half, this.getMinMaxMinY() - half, this.getMinMaxMaxX() - this.getMinMaxMinX() + half * 2, this.getMinMaxMaxY() - this.getMinMaxMinY() + half * 2);
        this.doneMinMax();
        return rect;
    }

    private String getUserText() {
        StringBuffer user = new StringBuffer();
        while (!this.atEndOfFile() && this.peekNextCharacter() != ';') {
            user.append(this.getNextCharacter());
        }
        return user.toString();
    }

    private String parseName() {
        char c;
        StringBuffer nText = new StringBuffer();
        boolean noChar = true;
        while (!this.atEndOfFile() && (c = this.peekNextCharacter()) != ';' && c != ' ' && c != '\t' && c != '{' && c != '}') {
            noChar = false;
            this.getNextCharacter();
            nText.append(c);
        }
        if (noChar) {
            this.logIt(119);
        }
        return nText.toString();
    }

    private void appendTransformEntry(FrontTransformList a, FrontTransformEntry p) {
        FrontLinkedTransform newT = new FrontLinkedTransform();
        if (newT == null) {
            return;
        }
        FrontLinkedTransform temp = a.tLast;
        a.tLast = newT;
        if (temp != null) {
            temp.tNext = a.tLast;
        }
        a.tLast.tValue = p;
        a.tLast.tNext = null;
        if (a.tFirst == null) {
            a.tFirst = a.tLast;
        }
        ++a.tLength;
    }

    private int getNumber() {
        int ans;
        boolean somedigit = false;
        this.skipSpaces();
        for (ans = 0; ans < 0xCCCCCCB && TextUtils.isDigit(this.peekNextCharacter()); ans += this.getNextCharacter() - 48) {
            ans *= 10;
            somedigit = true;
        }
        if (!somedigit) {
            this.logIt(102);
            return 0;
        }
        if (TextUtils.isDigit(this.peekNextCharacter())) {
            this.logIt(101);
            return -1;
        }
        return ans;
    }

    private boolean skipSemicolon() {
        boolean ans = false;
        this.skipBlanks();
        if (this.peekNextCharacter() == ';') {
            this.getNextCharacter();
            ans = true;
            this.skipBlanks();
        }
        return ans;
    }

    private boolean skipSpaces() {
        char c;
        boolean ans = false;
        while ((c = this.peekNextCharacter()) == ' ' || c == '\t') {
            this.getNextCharacter();
            ans = true;
        }
        return ans;
    }

    private void makePolygon(FrontPath a) {
        int length = a.pLength;
        this.statementsSince91 = true;
        if (this.ignoreStatements) {
            return;
        }
        if (this.currentLayer == null) {
            this.numNullLayerErrors = true;
            return;
        }
        if (length < 3) {
            this.errorReport("polygon with < 3 pts in path, ignored", 4);
            return;
        }
        FrontPoly obj = new FrontPoly();
        FrontPath tPath = a;
        obj.layer = this.currentLayer;
        if (this.isInCellDefinition && this.cellScaleFactor != 1.0) {
            FrontPath sPath = new FrontPath();
            this.scalePath(a, sPath);
            tPath = sPath;
        }
        FrontPath bbpath = new FrontPath();
        this.copyPath(tPath, bbpath);
        Rectangle box = this.getPolyBounds(bbpath);
        obj.bb.l = box.x;
        obj.bb.r = box.x + box.width;
        obj.bb.b = box.y;
        obj.bb.t = box.y + box.height;
        obj.points = new Point[length];
        for (int i = 0; i < length; ++i) {
            obj.points[i] = this.removePoint(tPath);
        }
        if (this.isInCellDefinition) {
            obj.next = this.currentFrontSymbol.guts;
            this.currentFrontSymbol.guts = obj;
        } else {
            this.topLevelItem(obj);
        }
    }

    private void topLevelItem(FrontObjBase object) {
        if (object == null) {
            this.errorReport("item: null object", 0);
            return;
        }
        FrontItem newItem = new FrontItem();
        newItem.same = this.currentItemList;
        this.currentItemList = newItem;
        newItem.what = object;
        if (object instanceof FrontCall) {
            this.findCallBounds((FrontCall)object);
        }
    }

    private void findCallBounds(FrontCall object) {
        FrontSymbol thisST = this.lookupSymbol(object.symNumber);
        if (!thisST.defined) {
            String mess = "call to undefined symbol " + thisST.symNumber;
            this.errorReport(mess, 2);
            return;
        }
        if (thisST.expanded) {
            String mess = "recursive call on symbol " + thisST.symNumber;
            this.errorReport(mess, 2);
            return;
        }
        thisST.expanded = true;
        this.findBounds(thisST);
        object.unID = thisST;
        this.pushTransform();
        this.applyLocal(object.matrix);
        Point temp = new Point();
        temp.x = thisST.bounds.l;
        temp.y = thisST.bounds.b;
        Point comperror = this.transformPoint(temp);
        this.initMinMax(comperror);
        temp.x = thisST.bounds.r;
        comperror = this.transformPoint(temp);
        this.minMax(comperror);
        temp.y = thisST.bounds.t;
        comperror = this.transformPoint(temp);
        this.minMax(comperror);
        temp.x = thisST.bounds.l;
        comperror = this.transformPoint(temp);
        this.minMax(comperror);
        object.bb.l = this.getMinMaxMinX();
        object.bb.r = this.getMinMaxMaxX();
        object.bb.b = this.getMinMaxMinY();
        object.bb.t = this.getMinMaxMaxY();
        this.doneMinMax();
        this.popTransform();
        thisST.expanded = false;
    }

    private void findBounds(FrontSymbol sym) {
        boolean first = true;
        FrontObjBase ob = sym.guts;
        if (sym.boundsValid) {
            return;
        }
        if (ob == null) {
            String name = sym.name;
            if (name == null) {
                name = "#" + sym.symNumber;
            }
            System.out.println("Warning: cell " + name + " has no geometry in it");
            sym.bounds.l = 0;
            sym.bounds.r = 0;
            sym.bounds.b = 0;
            sym.bounds.t = 0;
            sym.boundsValid = true;
            return;
        }
        while (ob != null) {
            if (ob instanceof FrontCall) {
                this.findCallBounds((FrontCall)ob);
            }
            Point temp = new Point();
            temp.x = ob.bb.l;
            temp.y = ob.bb.b;
            if (first) {
                first = false;
                this.initMinMax(temp);
            } else {
                this.minMax(temp);
            }
            temp.x = ob.bb.r;
            temp.y = ob.bb.t;
            this.minMax(temp);
            ob = ob.next;
        }
        sym.bounds.l = this.getMinMaxMinX();
        sym.bounds.r = this.getMinMaxMaxX();
        sym.bounds.b = this.getMinMaxMinY();
        sym.bounds.t = this.getMinMaxMaxY();
        sym.boundsValid = true;
        this.doneMinMax();
    }

    private FrontSymbol lookupSymbol(int sym) {
        FrontSymbol val = this.symbolTable.get(new Integer(sym));
        if (val == null) {
            val = new FrontSymbol(sym);
            this.symbolTable.put(new Integer(sym), val);
        }
        return val;
    }

    private void applyLocal(FrontMatrix tm) {
        this.assignMatrix(tm, this.matrixStackTop);
    }

    private void scalePath(FrontPath src, FrontPath dest) {
        int limit = src.pLength;
        for (int i = 0; i < limit; ++i) {
            Point temp = this.removePoint(src);
            temp.x = (int)(this.cellScaleFactor * (double)temp.x);
            temp.y = (int)(this.cellScaleFactor * (double)temp.y);
            this.appendPoint(dest, temp);
        }
    }

    private void copyPath(FrontPath src, FrontPath dest) {
        FrontLinkedPoint temp = src.pFirst;
        if (src == dest) {
            return;
        }
        while (temp != null) {
            this.appendPoint(dest, temp.pValue);
            temp = temp.pNext;
        }
    }

    private Rectangle getPolyBounds(FrontPath pPath) {
        int limit = pPath.pLength;
        this.pushTransform();
        this.initMinMax(this.transformPoint(this.removePoint(pPath)));
        for (int i = 1; i < limit; ++i) {
            this.minMax(this.transformPoint(this.removePoint(pPath)));
        }
        this.popTransform();
        Rectangle ret = new Rectangle(this.getMinMaxMinX(), this.getMinMaxMinY(), this.getMinMaxMaxX() - this.getMinMaxMinX(), this.getMinMaxMaxY() - this.getMinMaxMinY());
        this.doneMinMax();
        return ret;
    }

    private void minMax(Point foo) {
        if (foo.x > this.minMaxStackRight[this.minMaxStackPtr]) {
            this.minMaxStackRight[this.minMaxStackPtr] = foo.x;
        } else if (foo.x < this.minMaxStackLeft[this.minMaxStackPtr]) {
            this.minMaxStackLeft[this.minMaxStackPtr] = foo.x;
        }
        if (foo.y > this.minMaxStackTop[this.minMaxStackPtr]) {
            this.minMaxStackTop[this.minMaxStackPtr] = foo.y;
        } else if (foo.y < this.minMaxStackBottom[this.minMaxStackPtr]) {
            this.minMaxStackBottom[this.minMaxStackPtr] = foo.y;
        }
    }

    private void initMinMax(Point foo) {
        if (++this.minMaxStackPtr >= 50) {
            this.errorReport("initMinMax: out of stack", 0);
            return;
        }
        this.minMaxStackLeft[this.minMaxStackPtr] = foo.x;
        this.minMaxStackRight[this.minMaxStackPtr] = foo.x;
        this.minMaxStackBottom[this.minMaxStackPtr] = foo.y;
        this.minMaxStackTop[this.minMaxStackPtr] = foo.y;
    }

    private void doneMinMax() {
        if (this.minMaxStackPtr < 0) {
            this.errorReport("doneMinMax: pop from empty stack", 0);
        } else {
            --this.minMaxStackPtr;
        }
    }

    private int getMinMaxMinX() {
        return this.minMaxStackLeft[this.minMaxStackPtr];
    }

    private int getMinMaxMinY() {
        return this.minMaxStackBottom[this.minMaxStackPtr];
    }

    private int getMinMaxMaxX() {
        return this.minMaxStackRight[this.minMaxStackPtr];
    }

    private int getMinMaxMaxY() {
        return this.minMaxStackTop[this.minMaxStackPtr];
    }

    private void pushTransform() {
        if (this.matrixStackTop.next == null) {
            this.matrixStackTop.next = new FrontMatrix();
            this.clearMatrix(this.matrixStackTop.next);
            this.matrixStackTop.next.prev = this.matrixStackTop;
            this.matrixStackTop = this.matrixStackTop.next;
            this.matrixStackTop.next = null;
        } else {
            this.matrixStackTop = this.matrixStackTop.next;
            this.clearMatrix(this.matrixStackTop);
        }
    }

    private void popTransform() {
        if (this.matrixStackTop.prev != null) {
            this.matrixStackTop = this.matrixStackTop.prev;
        } else {
            this.errorReport("pop, empty trans stack", 0);
        }
    }

    private Point transformPoint(Point foo) {
        Point ans = new Point();
        if (!this.matrixStackTop.multiplied) {
            this.matrixMult(this.matrixStackTop, this.matrixStackTop.prev, this.matrixStackTop);
        }
        switch (this.matrixStackTop.type) {
            case 0: {
                return foo;
            }
            case 2: {
                ans.x = (int)this.matrixStackTop.a31;
                ans.y = (int)this.matrixStackTop.a32;
                ans.x += foo.x;
                ans.y += foo.y;
                return ans;
            }
            case 4: {
                ans.x = this.matrixStackTop.a11 < 0.0 ? -foo.x : foo.x;
                ans.y = this.matrixStackTop.a22 < 0.0 ? -foo.y : foo.y;
                return ans;
            }
            case 1: {
                ans.x = (int)((double)foo.x * this.matrixStackTop.a11 + (double)foo.y * this.matrixStackTop.a21);
                ans.y = (int)((double)foo.x * this.matrixStackTop.a12 + (double)foo.y * this.matrixStackTop.a22);
                return ans;
            }
        }
        ans.x = (int)(this.matrixStackTop.a31 + (double)foo.x * this.matrixStackTop.a11 + (double)foo.y * this.matrixStackTop.a21);
        ans.y = (int)(this.matrixStackTop.a32 + (double)foo.x * this.matrixStackTop.a12 + (double)foo.y * this.matrixStackTop.a22);
        return ans;
    }

    private void matrixMult(FrontMatrix l, FrontMatrix r, FrontMatrix result) {
        if (l == null || r == null || result == null) {
            this.errorReport("null arg to matrixMult", 0);
        }
        if (result.multiplied) {
            this.errorReport("can't re-mult matrix", 0);
            return;
        }
        if (!r.multiplied) {
            FrontMatrix temp = new FrontMatrix();
            temp.multiplied = false;
            this.matrixMult(r, r.prev, temp);
            this.matrixMultCore(l, temp, result);
        } else {
            this.matrixMultCore(l, r, result);
        }
    }

    private void matrixMultCore(FrontMatrix l, FrontMatrix r, FrontMatrix result) {
        if (l == null || r == null || result == null) {
            this.errorReport("null arg to matrixMultCore", 0);
            return;
        }
        if (l.type == 0) {
            this.assignMatrix(r, result);
        } else if (r.type == 0) {
            this.assignMatrix(l, result);
        } else {
            FrontMatrix temp = new FrontMatrix();
            temp.a11 = l.a11 * r.a11 + l.a12 * r.a21;
            temp.a12 = l.a11 * r.a12 + l.a12 * r.a22;
            temp.a21 = l.a21 * r.a11 + l.a22 * r.a21;
            temp.a22 = l.a21 * r.a12 + l.a22 * r.a22;
            temp.a31 = l.a31 * r.a11 + l.a32 * r.a21 + l.a33 * r.a31;
            temp.a32 = l.a31 * r.a12 + l.a32 * r.a22 + l.a33 * r.a32;
            temp.a33 = l.a33 * r.a33;
            temp.type = l.type | r.type;
            this.assignMatrix(temp, result);
        }
        if (result.a33 != 1.0) {
            result.a11 /= result.a33;
            result.a12 /= result.a33;
            result.a21 /= result.a33;
            result.a22 /= result.a33;
            result.a31 /= result.a33;
            result.a32 /= result.a33;
            result.a33 = 1.0;
        }
        result.multiplied = true;
    }

    private void assignMatrix(FrontMatrix src, FrontMatrix dest) {
        dest.a11 = src.a11;
        dest.a12 = src.a12;
        dest.a21 = src.a21;
        dest.a22 = src.a22;
        dest.a31 = src.a31;
        dest.a32 = src.a32;
        dest.a33 = src.a33;
        dest.type = src.type;
        dest.multiplied = src.multiplied;
    }

    private Point removePoint(FrontPath a) {
        if (a.pFirst == null) {
            return new Point(0, 0);
        }
        FrontLinkedPoint temp = a.pFirst.pNext;
        Point ans = a.pFirst.pValue;
        a.pFirst = temp;
        if (a.pFirst == null) {
            a.pLast = null;
        }
        --a.pLength;
        return ans;
    }

    private void makeInstanceName(String name) {
        if (this.ignoreStatements) {
            return;
        }
        if (name.length() == 0) {
            this.errorReport("null instance name ignored", 4);
            return;
        }
        if (this.namePending) {
            this.errorReport("there is already a name pending, new name replaces it", 4);
        }
        this.namePending = true;
        this.statementsSince91 = false;
    }

    private void processEnd() {
        this.statementsSince91 = true;
        this.endCommandFound = true;
        if (this.namePending) {
            this.errorReport("no instance to match name command", 4);
            this.namePending = false;
        }
    }

    private int getSignedInteger() {
        boolean sign = false;
        int ans = 0;
        this.skipSeparators();
        if (this.peekNextCharacter() == '-') {
            sign = true;
            this.getNextCharacter();
        }
        boolean someDigit = false;
        while (ans < 0xCCCCCCB && TextUtils.isDigit(this.peekNextCharacter())) {
            ans *= 10;
            ans += this.getNextCharacter() - 48;
            someDigit = true;
        }
        if (!someDigit) {
            this.logIt(103);
            return 0;
        }
        if (TextUtils.isDigit(this.peekNextCharacter())) {
            this.logIt(101);
            return sign ? -2147483647 : Integer.MAX_VALUE;
        }
        return sign ? -ans : ans;
    }

    private void logIt(int thing) {
        this.errorFound = true;
        this.errorType = thing;
    }

    private Point getPoint() {
        int x = this.getSignedInteger();
        int y = this.getSignedInteger();
        return new Point(x, y);
    }

    private void getPath(FrontPath a) {
        char c;
        this.skipSeparators();
        while (TextUtils.isDigit(c = this.peekNextCharacter()) || c == '-') {
            Point temp = this.getPoint();
            if (this.errorFound) break;
            this.appendPoint(a, temp);
            this.skipSeparators();
        }
        if (a.pLength == 0) {
            this.logIt(105);
        }
    }

    private void appendPoint(FrontPath a, Point p) {
        FrontLinkedPoint temp = a.pLast;
        a.pLast = new FrontLinkedPoint();
        if (temp != null) {
            temp.pNext = a.pLast;
        }
        a.pLast.pValue = p;
        a.pLast.pNext = null;
        if (a.pFirst == null) {
            a.pFirst = a.pLast;
        }
        ++a.pLength;
    }

    private void skipSeparators() {
        while (true) {
            char c = this.peekNextCharacter();
            switch (c) {
                case '\uffffffff': 
                case '(': 
                case ')': 
                case '-': 
                case ';': {
                    return;
                }
            }
            if (TextUtils.isDigit(c)) {
                return;
            }
            this.getNextCharacter();
        }
    }

    private int reportError() {
        switch (this.errorType) {
            case 101: {
                this.errorReport("number too large", 1);
                break;
            }
            case 102: {
                this.errorReport("unsigned integer expected", 1);
                break;
            }
            case 103: {
                this.errorReport("signed integer expected", 1);
                break;
            }
            case 104: {
                this.errorReport("missing ';' inserted", 1);
                break;
            }
            case 105: {
                this.errorReport("no points in path", 1);
                break;
            }
            case 106: {
                this.errorReport("no such transformation command", 1);
                break;
            }
            case 107: {
                this.errorReport("end of file inside user command", 1);
                break;
            }
            case 108: {
                this.errorReport("unknown command encountered", 1);
                break;
            }
            case 109: {
                this.errorReport("parser can't find i routine", 0);
                break;
            }
            case 110: {
                this.errorReport("no such define command", 1);
                break;
            }
            case 111: {
                this.errorReport("layer name expected", 1);
                break;
            }
            case 112: {
                this.errorReport("end of file inside a comment", 1);
                break;
            }
            case 113: {
                this.errorReport("no such axis in mirror command", 1);
                break;
            }
            case 114: {
                this.errorReport("symbol definitions can't nest", 1);
                break;
            }
            case 116: {
                this.errorReport("DF without DS", 1);
                break;
            }
            case 115: {
                this.errorReport("DD can't appear inside symbol definition", 1);
                break;
            }
            case 118: {
                this.errorReport("missing space in name command", 1);
                break;
            }
            case 119: {
                this.errorReport("no name in name command", 1);
                break;
            }
            case 117: {
                this.errorReport("End command inside symbol definition", 1);
                break;
            }
            case 100: {
                this.errorReport("error signaled but not reported", 0);
                break;
            }
            default: {
                this.errorReport("uncaught error", 1);
            }
        }
        if (this.errorType != 109 && this.errorType != 104 && this.flushInput(';') < 0) {
            this.errorReport("unexpected end of input file", 1);
        } else {
            this.skipBlanks();
        }
        this.errorFound = false;
        this.errorType = 100;
        return 1;
    }

    private void errorReport(String mess, int kind) {
        if (this.charactersRead > 0) {
            System.out.println("line " + (this.lineReader.getLineNumber() - (this.resetInputBuffer ? 1 : 0)) + ": " + this.inputBuffer.toString());
        }
        if (kind == 0 || kind == 0 || kind == 2 || kind == 3) {
            ++this.numFatalErrors;
        }
        switch (kind) {
            case 0: {
                System.out.println("Fatal internal error: " + mess);
                break;
            }
            case 1: {
                System.out.println("Syntax error: " + mess);
                break;
            }
            case 2: {
                System.out.println("Error: " + mess);
                break;
            }
            case 3: {
                System.out.println("Output error: " + mess);
                break;
            }
            case 4: {
                System.out.println("Warning: " + mess);
                break;
            }
            default: {
                System.out.println(mess);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CIFPreferences
    extends Input.InputPreferences {
        public boolean squareWires;

        public CIFPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public void initFromUserDefaults() {
            this.squareWires = IOTool.isCIFInSquaresWires();
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Job job) {
            CIF in = new CIF(this);
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }
    }

    static class FrontWire
    extends FrontObjBase {
        int width;
        Point[] points;

        FrontWire() {
        }
    }

    static class FrontPoly
    extends FrontObjBase {
        Point[] points;

        FrontPoly() {
        }
    }

    static class FrontFlash
    extends FrontObjBase {
        Point center;
        int diameter;

        FrontFlash() {
        }
    }

    static class FrontManBox
    extends FrontObjBase {
        FrontManBox() {
        }
    }

    static class FrontBox
    extends FrontObjBase {
        int length;
        int width;
        Point center;
        int xRot;
        int yRot;

        FrontBox() {
        }
    }

    static class FrontLabel
    extends FrontObjBase {
        String name;
        Point pos;

        FrontLabel() {
        }
    }

    static class FrontGeomName
    extends FrontObjBase {
        FrontGeomName() {
        }
    }

    static class FrontCall
    extends FrontObjBase {
        int symNumber;
        FrontSymbol unID;
        FrontMatrix matrix;
        FrontTransformList transList;

        FrontCall() {
        }
    }

    static class FrontObjBase {
        FrontBBox bb = new FrontBBox();
        FrontObjBase next;
        Layer layer;

        FrontObjBase() {
        }
    }

    static class FrontItem {
        FrontItem same;
        FrontObjBase what;

        FrontItem() {
        }
    }

    static class FrontTransformList {
        FrontLinkedTransform tFirst = null;
        FrontLinkedTransform tLast = null;
        int tLength = 0;

        FrontTransformList() {
        }
    }

    static class FrontLinkedTransform {
        FrontTransformEntry tValue;
        FrontLinkedTransform tNext;

        FrontLinkedTransform() {
        }
    }

    static class FrontPath {
        FrontLinkedPoint pFirst = null;
        FrontLinkedPoint pLast = null;
        int pLength = 0;

        FrontPath() {
        }
    }

    static class FrontLinkedPoint {
        Point pValue;
        FrontLinkedPoint pNext;

        FrontLinkedPoint() {
        }
    }

    static class FrontSymbol {
        int symNumber;
        boolean expanded;
        boolean defined;
        boolean dumped;
        FrontBBox bounds = new FrontBBox();
        boolean boundsValid;
        String name;
        int numCalls;
        FrontObjBase guts;

        FrontSymbol(int num) {
            this.symNumber = num;
            this.expanded = false;
            this.defined = false;
            this.dumped = false;
            this.numCalls = 0;
            this.boundsValid = false;
            this.name = null;
            this.guts = null;
        }
    }

    static class FrontBBox {
        int l;
        int r;
        int b;
        int t;

        FrontBBox() {
        }
    }

    static class FrontMatrix {
        double a11;
        double a12;
        double a21;
        double a22;
        double a31;
        double a32;
        double a33;
        FrontMatrix prev;
        FrontMatrix next;
        int type;
        boolean multiplied;

        FrontMatrix() {
        }
    }

    static class FrontTransformEntry {
        FrontTransformType kind;
        boolean xCoord;
        int xt;
        int yt;
        int xRot;
        int yRot;

        FrontTransformEntry() {
        }
    }

    static class BackCIFTransform {
        int type;
        int x;
        int y;
        BackCIFTransform next;

        BackCIFTransform() {
        }
    }

    static class BackCIFCall {
        int cIndex;
        String name;
        BackCIFTransform list;

        BackCIFCall() {
        }
    }

    static class BackCIFLabel {
        int x;
        int y;
        String label;

        BackCIFLabel() {
        }
    }

    static class BackCIFGeomName {
        Layer lay;

        BackCIFGeomName() {
        }
    }

    static class BackCIFPoly {
        Layer lay;
        int[] x;
        int[] y;
        int lim;

        BackCIFPoly() {
        }
    }

    static class BackCIFBox {
        Layer lay;
        int length;
        int width;
        int cenX;
        int cenY;
        int xRot;
        int yRot;

        BackCIFBox() {
        }
    }

    static class BackCIFStart {
        int cIndex;
        String name;
        int l;
        int r;
        int t;
        int b;

        BackCIFStart() {
        }
    }

    static class BackCIFList {
        int identity;
        Object member;
        BackCIFList next;

        BackCIFList() {
        }
    }

    static class BackCIFCell {
        int cIndex;
        int l;
        int r;
        int t;
        int b;
        Cell addr;

        BackCIFCell() {
        }
    }

    static class FrontTransformType {
        FrontTransformType() {
        }
    }
}

