/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.SweptSample;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class RawSpiceOut
extends Input<Stimuli> {
    private static final boolean DEBUG = false;
    private boolean complexValues;

    RawSpiceOut() {
        super(null);
    }

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        sd.setNetDelimiter(" ");
        if (this.openBinaryInput(fileURL)) {
            return sd;
        }
        System.out.println("Reading LTSpice/SmartSpice raw output file: " + fileURL.getFile());
        RawSpiceOut.startProgressDialog("LTSpice output", fileURL.getFile());
        this.readRawLTSpiceFile(cell, sd);
        RawSpiceOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private void readRawLTSpiceFile(Cell cell, Stimuli sd) throws IOException {
        String line;
        this.complexValues = false;
        boolean realValues = false;
        int signalCount = -1;
        boolean firstFieldIsTime = false;
        String[] signalNames = null;
        int rowCount = -1;
        boolean isLTSpice = false;
        boolean first = true;
        sd.setCell(cell);
        SignalCollection sc = null;
        double[] time = null;
        while ((line = this.getLineFromBinary()) != null) {
            int i;
            String name;
            int colonPos;
            this.updateProgressDialog(line.length());
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a RAWFILE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return;
                }
            }
            if ((colonPos = line.indexOf(58)) < 0) continue;
            String keyWord = line.substring(0, colonPos);
            String restOfLine = line.substring(colonPos + 1).trim();
            if (keyWord.equals("Command")) {
                isLTSpice = restOfLine.indexOf("LTspice") != -1;
                continue;
            }
            if (keyWord.equals("Plotname")) {
                if (sc != null) {
                    signalCount = -1;
                    rowCount = -1;
                    signalNames = null;
                }
                if (restOfLine.startsWith("Transient Analysis")) {
                    sc = Stimuli.newSignalCollection(sd, "TRANS SIGNALS");
                    continue;
                }
                if (restOfLine.startsWith("DC ")) {
                    sc = Stimuli.newSignalCollection(sd, "DC SIGNALS");
                    continue;
                }
                if (restOfLine.startsWith("AC ")) {
                    sc = Stimuli.newSignalCollection(sd, "AC SIGNALS");
                    continue;
                }
                if (restOfLine.startsWith("Operating ")) {
                    sc = Stimuli.newSignalCollection(sd, "OPERATING POINT");
                    continue;
                }
                System.out.println("Warning: unknown analysis: " + restOfLine);
                sc = Stimuli.newSignalCollection(sd, "TRANS SIGNALS");
                continue;
            }
            if (keyWord.equals("Flags")) {
                int r;
                int complex = restOfLine.indexOf("complex");
                if (complex >= 0) {
                    this.complexValues = true;
                }
                if ((r = restOfLine.indexOf("real")) < 0) continue;
                realValues = true;
                continue;
            }
            if (keyWord.equals("No. Variables")) {
                signalCount = TextUtils.atoi(restOfLine);
                continue;
            }
            if (keyWord.equals("No. Points")) {
                rowCount = TextUtils.atoi(restOfLine);
                time = new double[rowCount];
                continue;
            }
            if (!isLTSpice) {
                int j;
                int i2;
                if (keyWord.equals("Variables")) {
                    if (signalCount < 0) {
                        System.out.println("Missing variable count in file");
                        return;
                    }
                    signalNames = new String[signalCount];
                    int trueSignalCount = 0;
                    for (i2 = 0; i2 < signalCount; ++i2) {
                        int pos;
                        int tabPos;
                        int spacePos;
                        if (restOfLine.length() > 0) {
                            line = restOfLine;
                            restOfLine = "";
                        } else {
                            line = this.getLineAndUpdateProgressBinary();
                            if (line == null) {
                                System.out.println("Error: end of file during signal names");
                                return;
                            }
                        }
                        line = line.trim();
                        int numberOnLine = TextUtils.atoi(line);
                        if (numberOnLine != i2) {
                            System.out.println("Warning: Variable " + i2 + " has number " + numberOnLine);
                        }
                        if ((spacePos = line.indexOf(" ")) < 0) {
                            spacePos = line.length();
                        }
                        if ((tabPos = line.indexOf("\t")) < 0) {
                            tabPos = line.length();
                        }
                        if ((spacePos = (name = line.substring(pos = Math.min(spacePos, tabPos)).trim()).indexOf(" ")) < 0) {
                            spacePos = name.length();
                        }
                        if ((tabPos = name.indexOf("\t")) < 0) {
                            tabPos = name.length();
                        }
                        pos = Math.min(spacePos, tabPos);
                        name = name.substring(0, pos);
                        if (i2 == 0 && name.equals("time")) {
                            firstFieldIsTime = true;
                            continue;
                        }
                        signalNames[trueSignalCount++] = name;
                    }
                    signalCount = trueSignalCount;
                    continue;
                }
                if (keyWord.equals("Values")) {
                    if (signalCount < 0) {
                        System.out.println("Missing variable count in file");
                        return;
                    }
                    if (rowCount < 0) {
                        System.out.println("Missing point count in file");
                        return;
                    }
                    double[][] values2 = new double[signalCount][rowCount];
                    for (j = 0; j < rowCount; ++j) {
                        int valueFill = 0;
                        int valuesToRead = signalCount;
                        if (firstFieldIsTime) {
                            ++valuesToRead;
                        } else {
                            time[j] = j;
                        }
                        int i3 = -1;
                        block3: while (i3 < valuesToRead) {
                            line = this.getLineAndUpdateProgressBinary();
                            if (line == null) {
                                System.out.println("Error: end of file during data points (read " + j + " out of " + rowCount);
                                return;
                            }
                            if ((line = line.trim()).length() == 0) continue;
                            int charPos = 0;
                            while (charPos <= line.length()) {
                                int tabPos = line.indexOf("\t", charPos);
                                if (tabPos < 0) {
                                    tabPos = line.length();
                                }
                                String field2 = line.substring(charPos, tabPos);
                                for (charPos = tabPos + 1; charPos < line.length() && line.charAt(charPos) == '\t'; ++charPos) {
                                }
                                if (i3 < 0) {
                                    int lineNumber = TextUtils.atoi(field2);
                                    if (lineNumber != j) {
                                        System.out.println("Warning: event " + j + " has wrong event number: " + lineNumber);
                                    }
                                } else {
                                    double val = TextUtils.atof(field2);
                                    if (i3 == 0 && firstFieldIsTime) {
                                        time[j] = val;
                                    } else {
                                        values2[valueFill++][j] = val;
                                    }
                                }
                                if (++i3 < valuesToRead) continue;
                                continue block3;
                            }
                        }
                    }
                    for (i2 = 0; i2 < signalCount; ++i2) {
                        ScalarSample.createSignal(sc, sd, signalNames[i2], null, time, values2[i2]);
                    }
                    continue;
                }
                if (!keyWord.equals("Binary")) continue;
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return;
                }
                if (rowCount < 0) {
                    System.out.println("Missing point count in file");
                    return;
                }
                double[][] values3 = new double[signalCount][rowCount];
                for (j = 0; j < rowCount; ++j) {
                    time[j] = this.dataInputStream.readDouble();
                    for (i = 0; i < signalCount; ++i) {
                        values3[i][j] = this.dataInputStream.readDouble();
                    }
                }
                for (i2 = 0; i2 < signalCount; ++i2) {
                    ScalarSample.createSignal(sc, sd, signalNames[i2], null, time, values3[i2]);
                }
                continue;
            }
            boolean OLD = true;
            if (OLD) {
                firstFieldIsTime = true;
            }
            if (keyWord.equals("Variables")) {
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return;
                }
                signalNames = new String[signalCount];
                int trueSignalCount = 0;
                for (i = 0; i < signalCount && (restOfLine = this.getLineFromBinary()) != null; ++i) {
                    int nameEnd;
                    int nameStart;
                    this.updateProgressDialog(restOfLine.length());
                    restOfLine = restOfLine.trim();
                    int indexOnLine = TextUtils.atoi(restOfLine);
                    if (indexOnLine != i) {
                        System.out.println("Warning: Variable " + i + " has number " + indexOnLine);
                    }
                    for (nameStart = 0; nameStart < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameStart)); ++nameStart) {
                    }
                    while (nameStart < restOfLine.length() && Character.isWhitespace(restOfLine.charAt(nameStart))) {
                        ++nameStart;
                    }
                    for (nameEnd = nameStart; nameEnd < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameEnd)); ++nameEnd) {
                    }
                    name = restOfLine.substring(nameStart, nameEnd);
                    if (name.startsWith("V(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    }
                    if (i == 0) {
                        if (OLD) continue;
                        if (name.equals("time")) {
                            firstFieldIsTime = true;
                            continue;
                        }
                    }
                    signalNames[trueSignalCount++] = name;
                }
                signalCount = trueSignalCount;
                continue;
            }
            if (!keyWord.equals("Binary")) continue;
            if (signalCount < 0) {
                System.out.println("Missing variable count in file");
                return;
            }
            if (rowCount < 0) {
                System.out.println("Missing point count in file");
                return;
            }
            double[][] values4 = new double[signalCount][rowCount];
            time = new double[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                double t = j;
                if (firstFieldIsTime) {
                    t = this.getNextDouble();
                }
                time[j] = Math.abs(t);
                for (int i4 = 0; i4 < signalCount; ++i4) {
                    double value2 = 0.0;
                    value2 = realValues ? (double)this.getNextFloat() : this.getNextDouble();
                    values4[i4][j] = value2;
                }
            }
            ArrayList<Integer> sweepLengths = new ArrayList<Integer>();
            int sweepStart = 0;
            int sweepCount = 0;
            for (int j = 1; j <= rowCount; ++j) {
                if (j != rowCount && !(time[j] < time[j - 1])) continue;
                int sl = j - sweepStart;
                sweepLengths.add(new Integer(sl));
                sweepStart = j;
                ++sweepCount;
            }
            Signal[][] signals = new Signal[signalCount][sweepCount];
            for (int i5 = 0; i5 < signalCount; ++i5) {
                String name2 = signalNames[i5];
                int lastDotPos = name2.lastIndexOf(46);
                String context = null;
                if (lastDotPos >= 0) {
                    context = name2.substring(0, lastDotPos);
                    name2 = name2.substring(lastDotPos + 1);
                }
                for (int s = 0; s < sweepCount; ++s) {
                    signals[i5][s] = ScalarSample.createSignal(sc, sd, name2, context);
                }
            }
            int offset = 0;
            for (int s = 0; s < sweepCount; ++s) {
                int sweepLength = (Integer)sweepLengths.get(s);
                for (int i6 = 0; i6 < signalCount; ++i6) {
                    MutableSignal ms = (MutableSignal)signals[i6][s];
                    for (int j = 0; j < sweepLength; ++j) {
                        ms.addSample(time[j + offset], new ScalarSample(values4[i6][j + offset]));
                    }
                }
                offset += sweepLength;
            }
            String[] sweepNames = new String[sweepCount];
            for (int s = 0; s < sweepCount; ++s) {
                sweepNames[s] = "" + (s + 1);
            }
            for (int i7 = 0; i7 < signalCount; ++i7) {
                String name3 = signalNames[i7];
                int lastDotPos = name3.lastIndexOf(46);
                String context = null;
                if (lastDotPos >= 0) {
                    context = name3.substring(0, lastDotPos);
                    name3 = name3.substring(lastDotPos + 1);
                }
                SweptSample.createSignal(sc, sd, name3, context, false, signals[i7]);
            }
            sc.setSweepNames(sweepNames);
            return;
        }
    }

    private double getNextDouble() throws IOException {
        long lt = this.dataInputStream.readLong();
        lt = Long.reverseBytes(lt);
        double t = Double.longBitsToDouble(lt);
        int amtRead = 8;
        if (this.complexValues) {
            amtRead *= 2;
            this.dataInputStream.readLong();
        }
        this.updateProgressDialog(amtRead);
        return t;
    }

    private float getNextFloat() throws IOException {
        int lt = this.dataInputStream.readInt();
        lt = Integer.reverseBytes(lt);
        float t = Float.intBitsToFloat(lt);
        int amtRead = 4;
        if (this.complexValues) {
            amtRead *= 2;
            this.dataInputStream.readInt();
        }
        this.updateProgressDialog(amtRead);
        return t;
    }
}

