/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenIterable$class;
import scala.collection.GenIterableLike$class;
import scala.collection.GenIterableViewLike$class;
import scala.collection.GenTraversable$class;
import scala.collection.GenTraversableLike$class;
import scala.collection.GenTraversableOnce$class;
import scala.collection.GenTraversableViewLike$class;
import scala.collection.Iterable;
import scala.collection.Iterable$class;
import scala.collection.IterableLike;
import scala.collection.IterableLike$;
import scala.collection.IterableView;
import scala.collection.IterableViewLike$class;
import scala.collection.Iterator;
import scala.collection.Parallelizable$class;
import scala.collection.Seq;
import scala.collection.Traversable$class;
import scala.collection.TraversableLike$class;
import scala.collection.TraversableOnce$class;
import scala.collection.TraversableViewLike$class;
import scala.collection.ViewMkString$class;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericTraversableTemplate$class;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public abstract class IterableLike$class {
    public static Iterable thisCollection(IterableLike $this) {
        return (Iterable)$this;
    }

    public static Iterable toCollection(IterableLike $this, Object repr) {
        return (Iterable)repr;
    }

    public static void foreach(IterableLike $this, Function1 f2) {
        $this.iterator().foreach(f2);
    }

    public static boolean forall(IterableLike $this, Function1 p) {
        return $this.iterator().forall(p);
    }

    public static boolean exists(IterableLike $this, Function1 p) {
        return $this.iterator().exists(p);
    }

    public static Option find(IterableLike $this, Function1 p) {
        return $this.iterator().find(p);
    }

    public static boolean isEmpty(IterableLike $this) {
        return !$this.iterator().hasNext();
    }

    public static Object foldRight(IterableLike $this, Object z, Function2 op) {
        return $this.iterator().foldRight(z, op);
    }

    public static Object reduceRight(IterableLike $this, Function2 op) {
        return $this.iterator().reduceRight(op);
    }

    public static Iterable toIterable(IterableLike $this) {
        return $this.thisCollection();
    }

    public static Object head(IterableLike $this) {
        return $this.iterator().next();
    }

    public static Object slice(IterableLike $this, int from2, int until2) {
        Object Repr;
        int lo = package$.MODULE$.max(from2, 0);
        int elems = until2 - lo;
        Builder b = $this.newBuilder();
        if (elems <= 0) {
            Repr = b.result();
        } else {
            b.sizeHintBounded(elems, $this);
            Iterator it = $this.iterator().drop(lo);
            for (int i = 0; i < elems && it.hasNext(); ++i) {
                b.$plus$eq(it.next());
            }
            Repr = b.result();
        }
        return Repr;
    }

    public static Object take(IterableLike $this, int n) {
        Object Repr;
        Builder b = $this.newBuilder();
        if (n <= 0) {
            Repr = b.result();
        } else {
            b.sizeHintBounded(n, $this);
            Iterator it = $this.iterator();
            for (int i = 0; i < n && it.hasNext(); ++i) {
                b.$plus$eq(it.next());
            }
            Repr = b.result();
        }
        return Repr;
    }

    public static Object drop(IterableLike $this, int n) {
        Builder b = $this.newBuilder();
        int lo = package$.MODULE$.max(0, n);
        b.sizeHint($this, -lo);
        Iterator it = $this.iterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.next();
        }
        return ((Builder)b.$plus$plus$eq(it)).result();
    }

    public static Object takeWhile(IterableLike $this, Function1 p) {
        Builder b = $this.newBuilder();
        Iterator it = $this.iterator();
        while (it.hasNext()) {
            Object x2 = it.next();
            if (BoxesRunTime.unboxToBoolean(p.apply(x2))) {
                b.$plus$eq(x2);
                continue;
            }
            return b.result();
        }
        return b.result();
    }

    public static Iterator grouped(IterableLike $this, int size2) {
        return $this.iterator().grouped(size2).map(new Serializable($this){
            public static final long serialVersionUID;
            public final IterableLike $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Repr apply(Seq<A> xs) {
                Builder<A, Repr> b = this.$outer.newBuilder();
                b.$plus$plus$eq(xs);
                return b.result();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Iterator sliding(IterableLike $this, int size2) {
        return $this.sliding(size2, 1);
    }

    public static Iterator sliding(IterableLike $this, int size2, int step) {
        return $this.iterator().sliding(size2, step).map(new Serializable($this){
            public static final long serialVersionUID;
            public final IterableLike $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Repr apply(Seq<A> xs) {
                Builder<A, Repr> b = this.$outer.newBuilder();
                b.$plus$plus$eq(xs);
                return b.result();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Object takeRight(IterableLike $this, int n) {
        Builder b$1 = $this.newBuilder();
        b$1.sizeHintBounded(n, $this);
        Iterator lead$1 = $this.iterator().drop(n);
        BooleanRef go$1 = new BooleanRef(false);
        $this.seq().foreach(new Serializable($this, b$1, lead$1, go$1){
            public static final long serialVersionUID;
            private final Builder b$1;
            private final Iterator lead$1;
            private final BooleanRef go$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(A x2) {
                Object object;
                if (this.lead$1.hasNext()) {
                    object = this.lead$1.next();
                } else {
                    this.go$1.elem = true;
                    object = BoxedUnit.UNIT;
                }
                return this.go$1.elem ? this.b$1.$plus$eq(x2) : BoxedUnit.UNIT;
            }
            {
                this.b$1 = iterableLike;
                this.lead$1 = var3_3;
                this.go$1 = var4_4;
            }
        });
        return b$1.result();
    }

    public static Object dropRight(IterableLike $this, int n) {
        Builder b = $this.newBuilder();
        if (n >= 0) {
            b.sizeHint($this, -n);
        }
        Iterator lead = $this.iterator().drop(n);
        Iterator it = $this.iterator();
        while (lead.hasNext()) {
            b.$plus$eq(it.next());
            lead.next();
        }
        return b.result();
    }

    public static void copyToArray(IterableLike $this, Object xs, int start, int len) {
        int end = Predef$.MODULE$.intWrapper(start + len).min(ScalaRunTime$.MODULE$.array_length(xs));
        Iterator it = $this.iterator();
        for (int i = start; i < end && it.hasNext(); ++i) {
            ScalaRunTime$.MODULE$.array_update(xs, i, it.next());
        }
    }

    public static Object zip(IterableLike $this, GenIterable that, CanBuildFrom bf) {
        Builder b = bf.apply($this.repr());
        Iterator these = $this.iterator();
        Iterator those = that.iterator();
        while (these.hasNext() && those.hasNext()) {
            b.$plus$eq(new Tuple2(these.next(), those.next()));
        }
        return b.result();
    }

    public static /* bridge */ Object zip(IterableLike $this, Iterable that, CanBuildFrom bf) {
        return $this.zip(that, bf);
    }

    public static Object zipAll(IterableLike $this, GenIterable that, Object thisElem, Object thatElem, CanBuildFrom bf) {
        Builder b = bf.apply($this.repr());
        Iterator these = $this.iterator();
        Iterator those = that.iterator();
        while (these.hasNext() && those.hasNext()) {
            b.$plus$eq(new Tuple2(these.next(), those.next()));
        }
        while (these.hasNext()) {
            b.$plus$eq(new Tuple2(these.next(), thatElem));
        }
        while (those.hasNext()) {
            b.$plus$eq(new Tuple2(thisElem, those.next()));
        }
        return b.result();
    }

    public static /* bridge */ Object zipAll(IterableLike $this, Iterable that, Object thisElem, Object thatElem, CanBuildFrom bf) {
        return $this.zipAll(that, thisElem, thatElem, bf);
    }

    public static Object zipWithIndex(IterableLike $this, CanBuildFrom bf) {
        Builder b$2 = bf.apply($this.repr());
        IntRef i$1 = new IntRef(0);
        $this.foreach(new Serializable($this, b$2, i$1){
            public static final long serialVersionUID;
            public final Builder b$2;
            public final IntRef i$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(A x2) {
                this.b$2.$plus$eq(new Tuple2<A, Integer>(x2, BoxesRunTime.boxToInteger(this.i$1.elem)));
                ++this.i$1.elem;
            }
            {
                this.b$2 = iterableLike;
                this.i$1 = var3_3;
            }
        });
        return b$2.result();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean sameElements(IterableLike $this, GenIterable that) {
        Iterator these = $this.iterator();
        Iterator those = that.iterator();
        while (these.hasNext() && those.hasNext()) {
            void y1;
            void x1;
            Object a = those.next();
            Object a2 = these.next();
            if (a2 == a ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1))))) continue;
            return false;
        }
        return !these.hasNext() && !those.hasNext();
    }

    public static /* bridge */ boolean sameElements(IterableLike $this, Iterable that) {
        return $this.sameElements(that);
    }

    public static Stream toStream(IterableLike $this) {
        return $this.iterator().toStream();
    }

    public static boolean canEqual(IterableLike $this, Object that) {
        return true;
    }

    public static IterableView view(IterableLike $this) {
        return new IterableView<A, Repr>($this){
            private Repr underlying;
            private final IterableLike $outer;
            public volatile int bitmap$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Repr underlying() {
                if ((this.bitmap$0 & 1) != 0) return this.underlying;
                IterableLike$.anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((this.bitmap$0 & 1) == 0) {
                        this.underlying = this.$outer.repr();
                        this.bitmap$0 |= 1;
                    }
                    // ** MonitorExit[this] (shouldn't be in output)
                    return this.underlying;
                }
            }

            public Iterator<A> iterator() {
                return this.$outer.iterator();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                GenTraversableOnce$class.$init$(this);
                TraversableOnce$class.$init$(this);
                Parallelizable$class.$init$(this);
                GenTraversableLike$class.$init$(this);
                TraversableLike$class.$init$(this);
                GenericTraversableTemplate$class.$init$(this);
                GenTraversable$class.$init$(this);
                Traversable$class.$init$(this);
                GenIterableLike$class.$init$(this);
                GenIterable$class.$init$(this);
                IterableLike$class.$init$(this);
                Iterable$class.$init$(this);
                ViewMkString$class.$init$(this);
                GenTraversableViewLike$class.$init$(this);
                TraversableViewLike$class.$init$(this);
                GenIterableViewLike$class.$init$(this);
                IterableViewLike$class.$init$(this);
            }
        };
    }

    public static IterableView view(IterableLike $this, int from2, int until2) {
        return (IterableView)$this.view().slice(from2, until2);
    }

    public static Iterator elements(IterableLike $this) {
        return $this.iterator();
    }

    public static Object first(IterableLike $this) {
        return $this.head();
    }

    public static Option firstOption(IterableLike $this) {
        return $this.headOption();
    }

    public static IterableView projection(IterableLike $this) {
        return $this.view();
    }

    public static void $init$(IterableLike $this) {
    }
}

