/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.tool.ncc.Ncc;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.result.NccResults;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class StdCellParams {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private static final Variable.Key ATTR_X = Variable.newKey("ATTR_X");
    private static final Variable.Key ATTR_S = Variable.newKey("ATTR_S");
    private static final Variable.Key ATTR_SN = Variable.newKey("ATTR_SN");
    private static final Variable.Key ATTR_SP = Variable.newKey("ATTR_SP");
    private double nmosWellHeight;
    private double pmosWellHeight;
    private double gndY;
    private double vddY;
    private double gndWidth;
    private double vddWidth;
    private double trackPitch;
    private double trackWidth;
    private double m1TrackWidth;
    private double m2TrackWidth;
    private double metalSpace;
    private double pmosTrackOffset;
    private double nmosTrackOffset;
    private double enableGateStrengthRatio;
    private boolean separateWellTies;
    private double maxWellTieRadius;
    private double nmosWellTieY;
    private double pmosWellTieY;
    private double minGateWid;
    private double maxMosWidth;
    private double gridResolution;
    private double drcRingSpace;
    private double wellConSelectHeight;
    private double wellConSelectOffset;
    private double sizeErr = 0.1;
    private static final double selectOverhangsDiffCont = 4.5;
    private static final double m1OverhangsDiffCont = 2.0;
    private static final double m1Space = 3.0;
    private ArrayList<Double> nmosTracks = new ArrayList();
    private ArrayList<Double> pmosTracks = new ArrayList();
    private Library schemLib = null;
    private Library layoutLib = null;
    private boolean doubleStrapGate = false;
    private boolean exhaustivePlace = true;
    private int nbPlacerPerms = 40000;
    private boolean simpleName = false;
    private String vddExportName = "vdd";
    private String gndExportName = "gnd";
    private PortCharacteristic vddExportRole = PortCharacteristic.PWR;
    private PortCharacteristic gndExportRole = PortCharacteristic.GND;
    private TechType tech;
    final EditingPreferences ep;
    private boolean is90nm;
    public static final SelectSrcDrn EVEN = new SelectSrcDrn(){

        @Override
        public boolean connectThisOne(int mosNdx, int srcDrnNdx) {
            return srcDrnNdx % 2 == 0;
        }
    };
    public static final SelectSrcDrn ODD = new SelectSrcDrn(){

        @Override
        public boolean connectThisOne(int mosNdx, int srcDrnNdx) {
            return srcDrnNdx % 2 == 1;
        }
    };

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    private void initMoCMOS() {
        this.nmosWellHeight = 70.0;
        this.pmosWellHeight = 70.0;
        this.gndY = -21.0;
        this.vddY = 21.0;
        this.gndWidth = 10.0;
        this.vddWidth = 10.0;
        this.trackPitch = 7.0;
        this.trackWidth = 4.0;
        this.m1TrackWidth = 4.0;
        this.m2TrackWidth = 4.0;
        this.metalSpace = 3.0;
        this.pmosTrackOffset = this.trackPitch / 2.0;
        this.nmosTrackOffset = -this.trackPitch / 2.0;
        this.enableGateStrengthRatio = 0.1;
        this.separateWellTies = false;
        this.maxWellTieRadius = 300.0;
        this.nmosWellTieY = 0.0;
        this.pmosWellTieY = 0.0;
        this.minGateWid = 3.0;
        this.maxMosWidth = 45.0;
        this.gridResolution = 0.5;
        this.drcRingSpace = 3.0;
        this.wellConSelectHeight = 9.0;
        this.wellConSelectOffset = 0.0;
    }

    private void initCMOS90() {
        this.nmosWellHeight = 84.0;
        this.pmosWellHeight = 84.0;
        this.gndY = -24.5;
        this.vddY = 24.5;
        this.gndWidth = 9.0;
        this.vddWidth = 9.0;
        this.trackPitch = 7.0;
        this.trackWidth = 3.4;
        this.m1TrackWidth = 3.4;
        this.m2TrackWidth = 2.8;
        this.metalSpace = 2.4;
        this.pmosTrackOffset = 7.0;
        this.nmosTrackOffset = -77.0;
        this.enableGateStrengthRatio = 0.1;
        this.separateWellTies = false;
        this.maxWellTieRadius = 300.0;
        this.nmosWellTieY = 0.0;
        this.pmosWellTieY = 0.0;
        this.minGateWid = 5.2;
        this.maxMosWidth = 45.0;
        this.gridResolution = 0.1;
        this.drcRingSpace = 0.0;
        this.wellConSelectHeight = 8.4;
        this.wellConSelectOffset = 0.0;
        this.is90nm = true;
    }

    private void init() {
        TrackBlockages blockages = new TrackBlockages(this.metalSpace);
        blockages.addBlockage(11.0, 4.0);
        blockages.addBlockage(-11.0, 4.0);
        blockages.addBlockage(this.vddY, this.vddWidth);
        blockages.addBlockage(this.gndY, this.gndWidth);
        this.generateTracks(blockages);
        this.nmosWellTieY = this.gndY;
        this.pmosWellTieY = this.vddY;
        if (this.separateWellTies) {
            this.nmosWellTieY = this.getTrackY(-(this.nbNmosTracks() - 1));
            blockages.addBlockage(this.nmosWellTieY, this.trackWidth);
            this.pmosWellTieY = this.getTrackY(this.nbPmosTracks() - 1);
            blockages.addBlockage(this.pmosWellTieY, this.trackWidth);
            this.generateTracks(blockages);
        }
    }

    private boolean is90nm() {
        return this.is90nm;
    }

    private void generateTracks(TrackBlockages blockages) {
        double y;
        this.nmosTracks.clear();
        this.pmosTracks.clear();
        for (y = this.pmosTrackOffset; y < this.pmosWellHeight; y += this.trackPitch) {
            if (blockages.isBlocked(y, this.trackWidth)) continue;
            this.pmosTracks.add(new Double(y));
        }
        for (y = this.nmosTrackOffset; y > -this.nmosWellHeight; y -= this.trackPitch) {
            if (blockages.isBlocked(y, this.trackWidth)) continue;
            this.nmosTracks.add(new Double(y));
        }
    }

    private double quantizeMantissa(double mantissa) {
        double loApprox;
        double szRatio = (1.0 + this.sizeErr) / (1.0 - this.sizeErr);
        double logBaseSzRatio = Math.log(mantissa) / Math.log(szRatio);
        double floorN = Math.floor(logBaseSzRatio);
        double ceilN = Math.ceil(logBaseSzRatio);
        double hiApprox = Math.pow(szRatio, ceilN);
        return hiApprox - mantissa < mantissa - (loApprox = Math.pow(szRatio, floorN)) ? hiApprox : loApprox;
    }

    private int calcNbGroups(double maxAvailWid, double totWid, int groupSz) {
        int nbGroups = (int)Math.ceil(totWid / maxAvailWid / (double)groupSz);
        if (groupSz % 2 == 0) {
            return nbGroups;
        }
        if (nbGroups % 2 == 0) {
            return nbGroups;
        }
        if (totWid < maxAvailWid && groupSz == 1) {
            return 1;
        }
        int roundupGroups = nbGroups + 1;
        double wid = totWid / (double)groupSz / (double)roundupGroups;
        if (wid >= this.tech.getDiffContWidth()) {
            nbGroups = roundupGroups;
        }
        return nbGroups;
    }

    private void fillDiffAndSelectNotch(PortInst prevPort, PortInst thisPort, FoldedMos mosLeft, FoldedMos mosRight, boolean fillDiffNotch) {
        double mosRightY;
        double diffWid = mosLeft.getPhysWidth();
        Cell f = mosLeft.getSrcDrn(0).getNodeInst().getParent();
        ArcProto diffArc = mosLeft instanceof FoldedPmos ? this.tech.pdiff() : this.tech.ndiff();
        PrimitiveNode diffNode = mosLeft instanceof FoldedPmos ? this.tech.pdNode() : this.tech.ndNode();
        double prevX = LayoutLib.roundCenterX(prevPort);
        double thisX = LayoutLib.roundCenterX(thisPort);
        double dist = thisX - prevX;
        if (dist == 0.0 || dist >= 9.0 + this.tech.getSelectSpacingRule()) {
            return;
        }
        double mosY = mosLeft.getMosCenterY();
        if (!DBMath.areEquals(mosY, mosRightY = mosRight.getMosCenterY())) {
            double activePlusSelect = diffWid / 2.0 + this.tech.getSelectSurroundDiffInTrans();
            double topY = -activePlusSelect;
            double bottomY = activePlusSelect;
            double sign = 1.0;
            if (mosY > mosRightY) {
                topY += mosY;
                bottomY += mosRightY;
                sign = -1.0;
            } else {
                topY += mosRightY;
                bottomY += mosY;
            }
            double diff2 = DBMath.round(topY - bottomY);
            if (DBMath.isGreaterThan(diff2, 0.0)) {
                double minRe = this.getGridResolution() * 2.0;
                if (minRe > 0.0 && DBMath.hasRemainder(diff2, minRe)) {
                    diff2 += this.getGridResolution();
                    diff2 = (double)((int)Math.ceil(diff2 / minRe)) * minRe;
                }
                diffWid += diff2;
                mosY += DBMath.round(sign * diff2 / 2.0);
            }
        }
        double a = mosLeft.getDiffContWidth();
        double b = mosLeft.getGateWidth();
        Rectangle2D diffNodeBnd = LayoutLib.calculateNodeInst(diffNode, thisX - dist / 2.0, mosY, dist, diffWid, this.ep);
        if (fillDiffNotch) {
            NodeInst dFill = LayoutLib.newNodeInst(diffNode, this.ep, diffNodeBnd, 0.0, f);
            double contY = LayoutLib.roundCenterY(thisPort);
            LayoutLib.newArcInst(diffArc, this.ep, Double.POSITIVE_INFINITY, thisPort, thisX, contY, dFill.getOnlyPortInst(), LayoutLib.roundCenterX(dFill.getOnlyPortInst()), contY);
            if (dist < 7.0) {
                double m1Wid = mosLeft.getDiffContWidth() - 1.0;
                NodeInst mFill = LayoutLib.newNodeInst(this.tech.m1Node(), this.ep, thisX - dist / 2.0, contY, dist, m1Wid, 0.0, f);
                LayoutLib.newArcInst(this.tech.m1(), this.ep, Double.POSITIVE_INFINITY, thisPort, mFill.getOnlyPortInst());
            }
        }
        double roundedPosY = DBMath.round(diffNodeBnd.getY() - diffNodeBnd.getHeight() / 2.0);
        Rectangle2D.Double selectRec = new Rectangle2D.Double(diffNodeBnd.getX() - dist / 2.0, roundedPosY, diffNodeBnd.getWidth(), diffNodeBnd.getHeight());
        double selectDiff = a - b;
        this.addSelAroundDiff(diffNode, selectRec, selectDiff, f);
    }

    private static FoldedMos getRightMos(Object a) {
        if (a instanceof FoldedMos) {
            return (FoldedMos)a;
        }
        StdCellParams.error(!(a instanceof FoldedMos[]), "not FoldedMos or FoldedMos[]");
        FoldedMos[] moss = (FoldedMos[])a;
        return moss[moss.length - 1];
    }

    private static String trkMsg(Object key, Cell schem) {
        return "Track assignment for export: " + key + " in Cell: " + schem.getName() + ".\n    ";
    }

    public void setDoubleStrapGate(boolean val) {
        this.doubleStrapGate = val;
    }

    public void setExhaustivePlace(boolean val) {
        this.exhaustivePlace = val;
    }

    public void setNbPlacerPerms(int i) {
        this.nbPlacerPerms = i;
    }

    public void setNmosWellHeight(double h) {
        this.nmosWellHeight = h;
        this.init();
    }

    public void setPmosWellHeight(double h) {
        this.pmosWellHeight = h;
        this.init();
    }

    public void setMaxMosWidth(double wid) {
        this.maxMosWidth = wid;
    }

    public void setPmosTrackOffset(double offset) {
        this.pmosTrackOffset = offset;
        this.init();
    }

    public void setNmosTrackOffset(double offset) {
        this.nmosTrackOffset = offset;
        this.init();
    }

    public void setTrackWidth(double width) {
        this.trackWidth = width;
        this.init();
    }

    public void setVddWidth(double width) {
        this.vddWidth = width;
        this.init();
    }

    public void setGndWidth(double width) {
        this.gndWidth = width;
        this.init();
    }

    public void setM1TrackWidth(double width) {
        this.m1TrackWidth = width;
    }

    public double getM1TrackWidth() {
        return this.m1TrackWidth;
    }

    public void setM2TrackWidth(double width) {
        this.m2TrackWidth = width;
    }

    public double getM2TrackWidth() {
        return this.m2TrackWidth;
    }

    public double getDRCRingSpacing() {
        return this.drcRingSpace;
    }

    public double getM1TrackAboveVDD() {
        double trackX = this.is90nm() ? this.getVddY() + this.getVddWidth() / 2.0 + 2.4 + this.getM1TrackWidth() / 2.0 + 2.8 : this.getVddY() + this.getVddWidth() / 2.0 + 3.0 + 2.0;
        return trackX;
    }

    public double getM1TrackBelowGnd() {
        double gndBot = this.getGndY() - this.getGndWidth() / 2.0;
        double trackX = this.is90nm() ? gndBot - 2.4 - this.getM1TrackWidth() / 2.0 - 2.8 : gndBot - this.getM1TrackWidth() - 2.0;
        return trackX;
    }

    public double getWellOverhangDiff() {
        if (this.is90nm()) {
            return 8.0;
        }
        return 6.0;
    }

    public double getGridResolution() {
        return this.gridResolution;
    }

    public double getFoldPitch(int nbSeries) {
        if (this.is90nm()) {
            return 8 + (nbSeries - 1) * 5;
        }
        return 8 + (nbSeries - 1) * 5;
    }

    public void enableNCC(String libName) {
        this.schemLib = Library.findLibrary(libName);
        StdCellParams.error(this.schemLib == null, "Please open the PurpleFour Library");
    }

    public void setVddExportName(String vddNm) {
        this.vddExportName = vddNm;
    }

    public String getVddExportName() {
        return this.vddExportName;
    }

    public void setGndExportName(String gndNm) {
        this.gndExportName = gndNm;
    }

    public String getGndExportName() {
        return this.gndExportName;
    }

    public void setVddExportRole(PortCharacteristic vddRole) {
        this.vddExportRole = vddRole;
    }

    public PortCharacteristic getVddExportRole() {
        return this.vddExportRole;
    }

    public void setGndExportRole(PortCharacteristic gndRole) {
        this.gndExportRole = gndRole;
    }

    public PortCharacteristic getGndExportRole() {
        return this.gndExportRole;
    }

    public StdCellParams(Technology tech, EditingPreferences ep) {
        this.tech = TechType.getTechType(tech);
        this.ep = ep;
        if (tech == Technology.getCMOS90Technology()) {
            this.initCMOS90();
        } else {
            this.initMoCMOS();
        }
    }

    void setOutputLibrary(Library lib) {
        this.layoutLib = lib;
    }

    Library getOutputLibrary() {
        return this.layoutLib;
    }

    public TechType getTechType() {
        return this.tech;
    }

    public EditingPreferences getEditingPreferences() {
        return this.ep;
    }

    public double getNmosWellHeight() {
        return this.nmosWellHeight;
    }

    public double getPmosWellHeight() {
        return this.pmosWellHeight;
    }

    public boolean getDoubleStrapGate() {
        return this.doubleStrapGate;
    }

    public boolean getExhaustivePlace() {
        return this.exhaustivePlace;
    }

    public int getNbPlacerPerms() {
        return this.nbPlacerPerms;
    }

    public double getCellBot() {
        return -this.nmosWellHeight;
    }

    public double getCellTop() {
        return this.pmosWellHeight;
    }

    public double getGndY() {
        return this.gndY;
    }

    public void setGndY(double y) {
        this.gndY = y;
        this.init();
    }

    public double getVddY() {
        return this.vddY;
    }

    public void setVddY(double y) {
        this.vddY = y;
        this.init();
    }

    public double getGndWidth() {
        return this.gndWidth;
    }

    public double getVddWidth() {
        return this.vddWidth;
    }

    public double getTrackY(int i) {
        StdCellParams.error(i == 0, "StdCellParams.getTrackY: 0 is an illegal track index");
        return i > 0 ? this.pmosTracks.get(i - 1).doubleValue() : this.nmosTracks.get(-i - 1).doubleValue();
    }

    public double getPhysTrackY(int i) {
        StdCellParams.error(i == 0, "StdCellParams.getPhysTrackY: 0 is illegal track index");
        return i > 0 ? this.trackPitch / 2.0 + (double)(i - 1) * this.trackPitch : -this.trackPitch / 2.0 + (double)(i + 1) * this.trackPitch;
    }

    public double getTrackPitch() {
        return this.trackPitch;
    }

    public int nbNmosTracks() {
        return this.nmosTracks.size();
    }

    public int nbPmosTracks() {
        return this.pmosTracks.size();
    }

    public boolean getSeparateWellTies() {
        return this.separateWellTies;
    }

    public void setSeparateWellTies(boolean b) {
        this.separateWellTies = b;
        this.init();
    }

    public double getNmosWellTieY() {
        return this.nmosWellTieY;
    }

    public double getPmosWellTieY() {
        return this.pmosWellTieY;
    }

    public double getNmosWellTieWidth() {
        return this.separateWellTies ? this.trackWidth : this.gndWidth;
    }

    public double getPmosWellTieWidth() {
        return this.separateWellTies ? this.trackWidth : this.vddWidth;
    }

    public String getNmosWellTieName() {
        return this.separateWellTies ? "vsb" : this.gndExportName;
    }

    public String getPmosWellTieName() {
        return this.separateWellTies ? "vnw" : this.vddExportName;
    }

    public PortCharacteristic getNmosWellTieRole() {
        return this.separateWellTies ? PortCharacteristic.IN : this.gndExportRole;
    }

    public PortCharacteristic getPmosWellTieRole() {
        return this.separateWellTies ? PortCharacteristic.IN : this.vddExportRole;
    }

    public void setSimpleName(boolean b) {
        this.simpleName = b;
    }

    public boolean getSimpleName() {
        return this.simpleName;
    }

    public double getWellTiePitch() {
        double tieToPwellTop = 0.0 - this.getNmosWellTieY();
        double tieToPwellBot = this.getNmosWellTieY() - -this.nmosWellHeight;
        double tieToPwellTopBot = Math.max(tieToPwellTop, tieToPwellBot);
        double nmosWellTieDistance = Math.sqrt(Math.pow(this.maxWellTieRadius, 2.0) - Math.pow(tieToPwellTopBot, 2.0));
        double tieToNwellTop = this.pmosWellHeight - this.getPmosWellTieY();
        double tieToNwellBot = this.getPmosWellTieY() - 0.0;
        double tieToNwellTopBot = Math.max(tieToNwellTop, tieToNwellBot);
        double pmosWellTieDistance = Math.sqrt(Math.pow(this.maxWellTieRadius, 2.0) - Math.pow(tieToNwellTopBot, 2.0));
        double tiePitch = 2.0 * Math.min(nmosWellTieDistance, pmosWellTieDistance);
        return (int)tiePitch / 2;
    }

    public double getEnableGateStrengthRatio() {
        return this.enableGateStrengthRatio;
    }

    public double roundGateWidth(double w) {
        if (this.is90nm()) {
            double size2 = Math.rint(w * 5.0) / 5.0;
            if (size2 < this.minGateWid) {
                System.out.println("Warning: gate width of " + size2 + " too small, using " + this.minGateWid);
                return this.minGateWid;
            }
            return size2;
        }
        return Math.rint(w * 2.0) / 2.0;
    }

    public double roundSize(double s2) {
        if (s2 == 0.0) {
            return s2;
        }
        double q = this.quantizeSize(s2);
        return q;
    }

    public double roundToGrid(double s2) {
        return (double)((int)(s2 / this.gridResolution)) * this.gridResolution;
    }

    public void setSizeQuantizationError(double err) {
        StdCellParams.error(err >= 1.0, "quantization error must be less than 1.0");
        StdCellParams.error(err < 0.0, "quantization error must be positive");
        this.sizeErr = err;
    }

    public double quantizeSize(double desiredSize) {
        double exponent = Math.floor(Math.log(desiredSize) / Math.log(10.0));
        double mantissa = desiredSize / Math.pow(10.0, exponent);
        double quantMant = this.sizeErr != 0.0 ? this.quantizeMantissa(mantissa) : mantissa;
        double roundMant = Math.rint(quantMant * 100.0) / 100.0;
        return Math.pow(10.0, exponent) * roundMant;
    }

    public String parameterizedName(String nm) {
        if (!this.vddExportName.equals("vdd")) {
            nm = nm + "_pwr";
        }
        if (this.simpleName) {
            return nm;
        }
        return nm + "_NH" + this.nmosWellHeight + "_PH" + this.pmosWellHeight + "_MW" + this.maxMosWidth + "_VY" + this.vddY + "_GY" + this.gndY;
    }

    public String sizedName(String nm, double sz) {
        String num = "" + (sz + 1000.0);
        num = num.substring(1);
        return this.parameterizedName(nm) + "_X" + num + "{lay}";
    }

    private NodeInst addNmosWell(double loX, double hiX, double y, Cell cell) {
        NodeInst well = LayoutLib.newNodeInst(this.tech.pwell(), this.ep, (loX + hiX) / 2.0, y - this.nmosWellHeight / 2.0, hiX - loX, this.nmosWellHeight, 0.0, cell);
        well.setHardSelect();
        return well;
    }

    private NodeInst addPmosWell(double loX, double hiX, double y, Cell cell) {
        NodeInst well = LayoutLib.newNodeInst(this.tech.nwell(), this.ep, (loX + hiX) / 2.0, y + this.pmosWellHeight / 2.0, hiX - loX, this.pmosWellHeight, 0.0, cell);
        well.setHardSelect();
        return well;
    }

    public NodeInst addNmosWell(double loX, double hiX, Cell cell) {
        return this.addNmosWell(loX, hiX, 0.0, cell);
    }

    public NodeInst addPmosWell(double loX, double hiX, Cell cell) {
        return this.addPmosWell(loX, hiX, 0.0, cell);
    }

    public void addWellsForRow(ArrayList<NodeInst> row, double minX, double maxX, Cell cell) {
        NodeInst last2;
        double rowMaxX;
        NodeInst first = row.get(row.size() - 1);
        double rowMinX = first.getBounds().getMinX();
        if (rowMinX < minX) {
            this.addPmosWell(minX, rowMinX, first.getAnchorCenterY(), cell);
            this.addNmosWell(minX, rowMinX, first.getAnchorCenterY(), cell);
        }
        if ((rowMaxX = (last2 = row.get(row.size() - 1)).getBounds().getMaxX()) < maxX) {
            this.addPmosWell(rowMaxX, maxX, first.getAnchorCenterY(), cell);
            this.addNmosWell(rowMaxX, maxX, first.getAnchorCenterY(), cell);
        }
    }

    public void addPstackEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, loX, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, hiX, this.pmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public void addNstackEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, loX, -this.nmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, hiX, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public void addEssentialBounds(double loX, double hiX, Cell cell) {
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, loX, -this.nmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(this.tech.essentialBounds(), this.ep, hiX, this.pmosWellHeight, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public double checkMinStrength(double specified, double minAllowable, String gateNm) {
        if (specified < minAllowable) {
            System.out.println("Can't make: " + gateNm + " this small: X=" + specified + ", Using X=" + minAllowable + " instead");
        }
        return Math.max(specified, minAllowable);
    }

    public FoldsAndWidth calcFoldsAndWidth(double spaceAvailWid, double totWid, int groupSz) {
        if (totWid == 0.0) {
            return null;
        }
        double maxAvailWid = Math.min(spaceAvailWid, this.maxMosWidth);
        int nbGroups = this.calcNbGroups(maxAvailWid, totWid, groupSz);
        double gateWid = this.roundGateWidth(totWid / (double)groupSz / (double)nbGroups);
        if (gateWid > maxAvailWid) {
            nbGroups = this.calcNbGroups(maxAvailWid - 0.5, totWid, groupSz);
            gateWid = this.roundGateWidth(totWid / (double)groupSz / (double)nbGroups);
        }
        double physWid = Math.max(this.tech.getDiffContWidth(), gateWid);
        if (gateWid < this.minGateWid) {
            return null;
        }
        return new FoldsAndWidth(nbGroups * groupSz, gateWid, physWid);
    }

    public void fillDiffAndSelectNotches(FoldedMos[] moss, boolean fillDiffNotch) {
        StdCellParams.error(moss.length == 0, "fillDiffAndSelectNotches: no transistors?");
        FoldedMos mos = moss[0];
        for (int i = 1; i < moss.length; ++i) {
            PortInst thisPort = moss[i].getSrcDrn(0);
            PortInst prevPort = moss[i - 1].getSrcDrn(moss[i - 1].nbSrcDrns() - 1);
            this.fillDiffAndSelectNotch(prevPort, thisPort, mos, moss[i], fillDiffNotch);
        }
    }

    public void wireVddGnd(FoldedMos[] moss, SelectSrcDrn select, Cell p) {
        String exportNm;
        FoldedMos mos = moss[0];
        PortInst leftDiff = mos.getSrcDrn(0);
        Cell f = leftDiff.getNodeInst().getParent();
        double busWid = mos instanceof FoldedPmos ? this.vddWidth : this.gndWidth;
        double busY = mos instanceof FoldedPmos ? this.vddY : this.gndY;
        TrackRouterH net = new TrackRouterH(this.tech.m2(), busWid, busY, this.tech, this.ep, p);
        String string2 = exportNm = mos instanceof FoldedPmos ? this.vddExportName : this.gndExportName;
        if (f.findPortProto(exportNm) == null) {
            double x = leftDiff.getBounds().getCenterX();
            NodeInst pinProt = LayoutLib.newNodeInst(this.tech.m2pin(), this.ep, x, busY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, f);
            PortInst pin = pinProt.getOnlyPortInst();
            Export e = Export.newInstance(f, pin, exportNm, this.ep);
            PortCharacteristic role = mos instanceof FoldedPmos ? this.vddExportRole : this.gndExportRole;
            e.setCharacteristic(role);
            LayoutLib.newArcInst(this.tech.m2(), this.ep, busWid, pin, pin);
            net.connect(pin);
        }
        double diffY = LayoutLib.roundCenterY(leftDiff);
        double notchLoY = Math.min(busY - busWid / 2.0, diffY);
        double notchHiY = Math.max(busY + busWid / 2.0, diffY);
        PortInst lastDiff = null;
        for (int i = 0; i < moss.length; ++i) {
            for (int j = 0; j < moss[i].nbSrcDrns(); ++j) {
                if (!select.connectThisOne(i, j)) continue;
                PortInst thisDiff = moss[i].getSrcDrn(j);
                net.connect(thisDiff);
                if (lastDiff != null) {
                    double rightX;
                    double leftX = LayoutLib.roundCenterX(lastDiff);
                    StdCellParams.error(leftX > (rightX = LayoutLib.roundCenterX(thisDiff)), "wireVddGnd: trans not sorted left to right");
                    double deltaX = rightX - leftX;
                    if (deltaX > 0.0 && deltaX < 7.0) {
                        double dY = Math.ceil(notchHiY - notchLoY);
                        NodeInst patchNode = LayoutLib.newNodeInst(this.tech.m1Node(), this.ep, (leftX + rightX) / 2.0, notchLoY + dY / 2.0, deltaX, dY, 0.0, f);
                        PortInst patch2 = patchNode.getOnlyPortInst();
                        LayoutLib.newArcInst(this.tech.m1(), this.ep, Double.POSITIVE_INFINITY, patch2, thisDiff);
                    }
                }
                lastDiff = thisDiff;
            }
        }
    }

    public void wireVddGnd(FoldedMos mos, SelectSrcDrn select, Cell p) {
        this.wireVddGnd(new FoldedMos[]{mos}, select, p);
    }

    public boolean nccEnabled() {
        return this.schemLib != null;
    }

    public void doNCC(Cell layout, String schemNm) {
        if (this.schemLib == null) {
            return;
        }
        Cell schem = this.schemLib.findNodeProto(schemNm);
        StdCellParams.error(schem == null, "can't find schematic: " + schemNm);
        NccOptions options = new NccOptions();
        options.howMuchStatus = 0;
        NccResults results = Ncc.compare(schem, null, layout, null, options);
        StdCellParams.error(!results.match(), "layout not topologically identical to schematic!");
    }

    public static double getSize(NodeInst iconInst, VarContext context) {
        Variable var = iconInst.getParameterOrVariable(ATTR_X);
        if (var == null) {
            var = iconInst.getParameterOrVariable(ATTR_S);
        }
        if (var == null) {
            var = iconInst.getParameterOrVariable(ATTR_SP);
        }
        if (var == null) {
            var = iconInst.getParameterOrVariable(ATTR_SN);
        }
        if (var == null) {
            System.out.println("can't find size, using 40");
            return 40.0;
        }
        Object val = context.evalVar(var);
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        StdCellParams.error(true, "an Icon's size isn't a numeric value");
        return 0.0;
    }

    public Cell findPart(String partNm, double sz) {
        return this.findPart(this.sizedName(partNm, sz));
    }

    public Cell findPart(String partNm) {
        return this.layoutLib.findNodeProto(partNm);
    }

    public Cell newPart(String partNm, double sz) {
        return this.newPart(this.sizedName(partNm, sz));
    }

    public Cell newPart(String partNm) {
        StdCellParams.error(this.findPart(partNm) != null, "Cell already exists: " + partNm);
        Cell p = Cell.newInstance(this.layoutLib, partNm);
        p.setTechnology(this.tech.getTechnology());
        return p;
    }

    public static double getRightDiffX(FoldedMos m) {
        return LayoutLib.roundCenterX(m.getSrcDrn(m.nbSrcDrns() - 1));
    }

    public static double getRightDiffX(FoldedMos[] moss) {
        return StdCellParams.getRightDiffX(StdCellParams.getRightMos(moss));
    }

    public static double getRightDiffX(Object a, Object b) {
        FoldedMos ra = StdCellParams.getRightMos(a);
        FoldedMos rb = StdCellParams.getRightMos(b);
        return Math.max(StdCellParams.getRightDiffX(ra), StdCellParams.getRightDiffX(rb));
    }

    public void addEssentialBoundsFromChildren(Cell cell, TechType tech) {
        double loY = Double.MAX_VALUE;
        double loX = Double.MAX_VALUE;
        double hiY = -1.7976931348623157E308;
        double hiX = -1.7976931348623157E308;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            ERectangle b = it.next().getBounds();
            loX = Math.min(loX, ((RectangularShape)b).getMinX());
            loY = Math.min(loY, ((RectangularShape)b).getMinY());
            hiX = Math.max(hiX, ((RectangularShape)b).getMaxX());
            hiY = Math.max(hiY, ((RectangularShape)b).getMaxY());
        }
        LayoutLib.newNodeInst(tech.essentialBounds(), this.ep, loX, loY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 180.0, cell);
        LayoutLib.newNodeInst(tech.essentialBounds(), this.ep, hiX, hiY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, cell);
    }

    public HashMap<String, Object> getSchemTrackAssign(Cell schem) {
        HashMap<String, Object> schAsgn = new HashMap<String, Object>();
        Iterator<PortProto> it = schem.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            Variable val = e.getParameterOrVariable("ATTR_track");
            String key = e.getName();
            if (val == null) continue;
            schAsgn.put(key, val);
        }
        this.validateTrackAssign(schAsgn, schem);
        return schAsgn;
    }

    public void validateTrackAssign(HashMap<String, Object> asgn, Cell s2) {
        HashMap<Object, String> trkToExp = new HashMap<Object, String>();
        for (String k : asgn.keySet()) {
            Object v = asgn.get(k);
            StdCellParams.error(!(v instanceof Integer), StdCellParams.trkMsg(k, s2) + "Value not Integer: " + v);
            int track = (Integer)v;
            StdCellParams.error(track == 0, StdCellParams.trkMsg(k, s2) + "Track must be <=-1 or >=1, 0 is illegal");
            String oldK = (String)trkToExp.get(v);
            if (oldK != null) {
                System.out.println(StdCellParams.trkMsg(k, s2) + "Track: " + v + " is shared by export: " + oldK);
            }
            trkToExp.put(v, k);
        }
    }

    public void addSelAroundDiff(NodeProto prot, Rectangle2D diffNodeBnd, double activeGateDiff, Cell cell) {
        StdCellParams.error(prot != this.tech.pdNode() && prot != this.tech.ndNode(), "addSelectAroundDiff: only works with MOSIS CMOS diff nodes");
        PrimitiveNode sel = prot == this.tech.pdNode() ? this.tech.pselNode() : this.tech.nselNode();
        double w = diffNodeBnd.getWidth();
        double h = diffNodeBnd.getHeight();
        h += this.tech.selectSurroundDiffAlongGateInTrans() * 2.0;
        if (activeGateDiff > 0.0) {
            h -= activeGateDiff;
        }
        NodeInst node = LayoutLib.newNodeInst(sel, this.ep, diffNodeBnd.getCenterX(), diffNodeBnd.getCenterY(), w, h, 0.0, cell);
        System.out.println(node.getParent().getName() + " Node " + node + " " + h + " cent " + diffNodeBnd.getCenterY());
    }

    public SelectFill fillSelect(Cell cell, boolean pSelect, boolean nSelect, boolean includePoly) {
        double selSurroundPoly = this.tech.getSelectSurroundOverPoly();
        if (selSurroundPoly < 0.0) {
            return null;
        }
        Rectangle2D pselectBounds = LayoutLib.getBounds(cell, Layer.Function.IMPLANTP);
        Rectangle2D nselectBounds = LayoutLib.getBounds(cell, Layer.Function.IMPLANTN);
        if (includePoly) {
            Rectangle2D polyBounds = LayoutLib.getBounds(cell, Layer.Function.POLY1);
            polyBounds.setRect(polyBounds.getX() - selSurroundPoly, polyBounds.getY() - selSurroundPoly, polyBounds.getWidth() + 2.0 * selSurroundPoly, polyBounds.getHeight() + 2.0 * selSurroundPoly);
            pselectBounds = pselectBounds.createUnion(polyBounds);
            nselectBounds = nselectBounds.createUnion(polyBounds);
        }
        pselectBounds.setRect(pselectBounds.getMinX(), 0.0, pselectBounds.getMaxX() - pselectBounds.getMinX(), pselectBounds.getMaxY());
        nselectBounds.setRect(nselectBounds.getMinX(), nselectBounds.getMinY(), nselectBounds.getMaxX() - nselectBounds.getMinX(), -nselectBounds.getMinY());
        pselectBounds = LayoutLib.roundBounds(pselectBounds);
        nselectBounds = LayoutLib.roundBounds(nselectBounds);
        NodeInst pni = null;
        NodeInst nni = null;
        if (pSelect) {
            pni = LayoutLib.newNodeInst(this.tech.pselNode(), this.ep, pselectBounds.getCenterX(), pselectBounds.getCenterY(), pselectBounds.getWidth(), pselectBounds.getHeight(), 0.0, cell);
            pni.setHardSelect();
        }
        if (nSelect) {
            nni = LayoutLib.newNodeInst(this.tech.nselNode(), this.ep, nselectBounds.getCenterX(), nselectBounds.getCenterY(), nselectBounds.getWidth(), nselectBounds.getHeight(), 0.0, cell);
            nni.setHardSelect();
        }
        return new SelectFill(nni, pni);
    }

    public boolean addWellCon(SelectFill selFill, PortInst gndPort, PortInst vddPort, Cell cell) {
        double nspace;
        double nselMaxY = Math.abs(selFill.nselNode.getYSize());
        double pselMaxY = Math.abs(selFill.pselNode.getYSize());
        boolean added = false;
        double pspace = this.getNmosWellHeight() - nselMaxY;
        double m1m1_sp = 2.4;
        double psel_sp = 4.8;
        double nsel_sp = 4.8;
        Technology techy = cell.getTechnology();
        if (pspace > this.wellConSelectHeight + m1m1_sp + 2.0 * this.gridResolution) {
            Poly[] polys;
            double pwellX = this.roundToGrid(gndPort.getBounds().getCenterX());
            double pwellY = -this.roundToGrid(nselMaxY + 0.5 * this.wellConSelectHeight + this.wellConSelectOffset) - this.gridResolution;
            SizeOffset so = this.tech.pwm1Y().getProtoSizeOffset();
            NodeInst ni = LayoutLib.newNodeInst(this.tech.pwm1Y(), this.ep, pwellX, pwellY, this.tech.pwm1Y().getDefWidth(this.ep) - so.getHighXOffset() - so.getLowXOffset(), this.tech.pwm1Y().getDefHeight(this.ep) - so.getHighYOffset() - so.getLowYOffset(), 0.0, cell);
            LayoutLib.newArcInst(this.tech.m1(), this.ep, this.getM1TrackWidth(), ni.getOnlyPortInst(), gndPort);
            added = true;
            double distFromEdge = this.getNmosWellHeight() - (Math.abs(pwellY) + 0.5 * this.wellConSelectHeight);
            if (distFromEdge < psel_sp && (polys = techy.getShapeOfNode(ni)) != null) {
                Layer.Function function = Layer.Function.IMPLANTP;
                FixpRectangle bounds = null;
                for (int i = 0; i < polys.length; ++i) {
                    if (polys[i] == null || polys[i].getLayer().getFunction() != function) continue;
                    bounds = polys[i].getBox();
                }
                if (bounds != null) {
                    double fillBot = (int)(Math.abs(pwellY) - 0.5 * this.wellConSelectHeight) + 1;
                    double fillH = this.getNmosWellHeight() - fillBot;
                    ni = LayoutLib.newNodeInst(this.tech.pselNode(), this.ep, pwellX, -1.0 * this.roundToGrid(fillH / 2.0 + fillBot), ((RectangularShape)bounds).getWidth(), this.roundToGrid(fillH), 0.0, cell);
                    ni.setHardSelect();
                }
            }
        }
        if ((nspace = this.getPmosWellHeight() - pselMaxY) > this.wellConSelectHeight + m1m1_sp + 2.0 * this.gridResolution) {
            Poly[] polys;
            double nwellX = this.roundToGrid(vddPort.getBounds().getCenterX());
            double nwellY = this.roundToGrid(pselMaxY + 0.5 * this.wellConSelectHeight + this.wellConSelectOffset) + this.gridResolution;
            SizeOffset so = this.tech.nwm1Y().getProtoSizeOffset();
            NodeInst ni = LayoutLib.newNodeInst(this.tech.nwm1Y(), this.ep, nwellX, nwellY, this.tech.nwm1Y().getDefWidth(this.ep) - so.getHighXOffset() - so.getLowXOffset(), this.tech.nwm1Y().getDefHeight(this.ep) - so.getHighYOffset() - so.getLowYOffset(), 0.0, cell);
            LayoutLib.newArcInst(this.tech.m1(), this.ep, this.getM1TrackWidth(), ni.getOnlyPortInst(), vddPort);
            added = true;
            double distFromEdge = this.getPmosWellHeight() - (Math.abs(nwellY) + 0.5 * this.wellConSelectHeight);
            if (distFromEdge < nsel_sp && (polys = techy.getShapeOfNode(ni)) != null) {
                Layer.Function function = Layer.Function.IMPLANTN;
                FixpRectangle bounds = null;
                for (int i = 0; i < polys.length; ++i) {
                    if (polys[i] == null || polys[i].getLayer().getFunction() != function) continue;
                    bounds = polys[i].getBox();
                }
                if (bounds != null) {
                    double fillBot = (int)(Math.abs(nwellY) - 0.5 * this.wellConSelectHeight) + 1;
                    double fillH = this.getPmosWellHeight() - fillBot;
                    ni = LayoutLib.newNodeInst(this.tech.nselNode(), this.ep, nwellX, this.roundToGrid(fillH / 2.0 + fillBot), ((RectangularShape)bounds).getWidth(), this.roundToGrid(fillH), 0.0, cell);
                    ni.setHardSelect();
                }
            }
        }
        return added;
    }

    public static class SelectFill {
        public final NodeInst nselNode;
        public final NodeInst pselNode;

        public SelectFill(NodeInst nselNode, NodeInst pselNode) {
            this.nselNode = nselNode;
            this.pselNode = pselNode;
        }
    }

    public static interface SelectSrcDrn {
        public boolean connectThisOne(int var1, int var2);
    }

    private static class TrackBlockages {
        private ArrayList<Blockage> blockages = new ArrayList();
        private double space;

        TrackBlockages(double s2) {
            this.space = s2;
        }

        void addBlockage(double center, double width) {
            this.blockages.add(new Blockage(center, width));
        }

        boolean isBlocked(double center, double width) {
            double top = center + width / 2.0 + this.space;
            double bot = center + width / 2.0 - this.space;
            for (int i = 0; i < this.blockages.size(); ++i) {
                Blockage b = this.blockages.get(i);
                if (!(b.bot < top) || !(b.top > bot)) continue;
                return true;
            }
            return false;
        }

        private static class Blockage {
            double bot;
            double top;

            Blockage(double center, double width) {
                this.bot = center - width / 2.0;
                this.top = center + width / 2.0;
            }
        }
    }
}

