/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.spicenetlist;

import com.sun.electric.tool.io.input.spicenetlist.SpiceInstance;
import com.sun.electric.tool.io.input.spicenetlist.SpiceModel;
import com.sun.electric.tool.io.input.spicenetlist.SpiceSubckt;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SpiceNetlistReader {
    private static final boolean STRIP_QUOTES = false;
    private static final boolean WRITE_ONLY_USED = true;
    private final boolean parseLibraries;
    private File file;
    private BufferedReader reader;
    private Iterator<String> macroReader;
    private StringBuilder lines;
    private int lineno;
    private final Map<File, SpiceLibrary> libraries = new LinkedHashMap<File, SpiceLibrary>();
    private final Map<String, String> options = new LinkedHashMap<String, String>();
    private final Map<String, String> globalParams = new LinkedHashMap<String, String>();
    private final Map<String, SpiceModel> globalModels = new LinkedHashMap<String, SpiceModel>();
    private final List<SpiceInstance> topLevelInstances = new ArrayList<SpiceInstance>();
    private final Map<String, SpiceSubckt> subckts = new LinkedHashMap<String, SpiceSubckt>();
    private final List<String> globalNets = new ArrayList<String>();
    private List<SpiceSubckt> currentSubcktStack = new ArrayList<SpiceSubckt>();

    public SpiceNetlistReader() {
        this(false);
    }

    public SpiceNetlistReader(boolean parseLibraries) {
        this.parseLibraries = parseLibraries;
        this.reader = null;
        this.lines = null;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Map<String, String> getGlobalParams() {
        return this.globalParams;
    }

    public Map<String, SpiceModel> getGlobalModels() {
        return this.globalModels;
    }

    public List<SpiceInstance> getTopLevelInstances() {
        return this.topLevelInstances;
    }

    public Collection<SpiceSubckt> getSubckts() {
        return this.subckts.values();
    }

    public List<String> getGlobalNets() {
        return this.globalNets;
    }

    public SpiceSubckt getSubckt(String name) {
        return this.subckts.get(name.toLowerCase());
    }

    public void readFile(String fileName, boolean verbose) throws FileNotFoundException {
        this.readFile(new File(fileName), verbose);
    }

    public void readFile(File file, boolean verbose) throws FileNotFoundException {
        this.file = file;
        this.reader = new BufferedReader(new FileReader(file));
        this.lines = new StringBuilder();
        String line = null;
        this.lineno = 0;
        try {
            while ((line = this.readLine()) != null) {
                this.parseLine(line, verbose);
            }
            this.reader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading file " + file.getPath() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMacro(String libFileName, String macroName, boolean verbose) {
        SpiceLibrary library;
        File libFile = this.resolveFile(libFileName);
        try {
            library = this.readLibrary(libFile, verbose);
        }
        catch (IOException e) {
            this.prErr("Can't read library file " + libFileName);
            return;
        }
        Integer macroStart = library.libIndex.get(macroName.toLowerCase());
        if (macroStart == null) {
            this.prErr("Can't file libary " + macroName + " in file " + libFileName);
            return;
        }
        File saveFile = this.file;
        BufferedReader saveReader = this.reader;
        Iterator<String> saveMacroReader = this.macroReader;
        StringBuilder saveLines = this.lines;
        int saveLine = this.lineno;
        try {
            String line;
            this.file = libFile;
            this.reader = null;
            this.macroReader = library.lines.listIterator(macroStart);
            this.lines = new StringBuilder();
            this.lineno = macroStart;
            while ((line = this.readLine()) != null) {
                if (line.length() >= 5 && line.substring(0, 5).toLowerCase().equals(".endl")) {
                    break;
                }
                this.parseLine(line, verbose);
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file " + this.file.getPath() + ": " + e.getMessage());
        }
        finally {
            this.file = saveFile;
            this.reader = saveReader;
            this.macroReader = saveMacroReader;
            this.lines = saveLines;
            this.lineno = saveLine;
        }
    }

    private void parseLine(String line, boolean verbose) {
        String[] tokens = this.getTokens(line = line.trim());
        if (tokens.length == 0) {
            return;
        }
        String keyword = tokens[0].toLowerCase();
        if (keyword.equals(".include")) {
            if (tokens.length < 2) {
                this.prErr("No file specified for .include");
                return;
            }
            String ifile = tokens[1];
            File newFile = this.resolveFile(ifile);
            File saveFile = this.file;
            BufferedReader saveReader = this.reader;
            Iterator<String> saveMacroReader = this.macroReader;
            StringBuilder saveLines = this.lines;
            int saveLine = this.lineno;
            try {
                if (verbose) {
                    System.out.println("Reading include file " + ifile);
                }
                this.readFile(newFile, verbose);
            }
            catch (FileNotFoundException e) {
                this.file = saveFile;
                this.lineno = saveLine;
                this.prErr("Include file does not exist: " + ifile);
            }
            this.file = saveFile;
            this.reader = saveReader;
            this.macroReader = saveMacroReader;
            this.lines = saveLines;
            this.lineno = saveLine;
        } else if (this.parseLibraries && keyword.startsWith(".lib")) {
            if (tokens.length < 3) {
                this.prErr("No library specified for .lib");
                return;
            }
            String lfile = tokens[1];
            String macroName = tokens[2];
            this.readMacro(lfile, macroName, verbose);
        } else if (keyword.startsWith(".opt")) {
            if (this.currentSubckt() != null) {
                this.prErr(".opt inside .subckt");
            }
            this.parseOptions(this.options, 1, tokens);
        } else if (keyword.equals(".param")) {
            SpiceSubckt currentSubckt = this.currentSubckt();
            this.parseParams(currentSubckt != null ? currentSubckt.getLocalParams() : this.globalParams, 1, tokens);
        } else if (keyword.equals(".subckt")) {
            SpiceSubckt oldSubckt;
            SpiceSubckt currentSubckt = this.currentSubckt();
            SpiceSubckt newSubckt = this.parseSubckt(tokens);
            SpiceSubckt spiceSubckt = oldSubckt = currentSubckt != null ? currentSubckt.addSubckt(newSubckt) : this.subckts.put(newSubckt.getName().toLowerCase(), newSubckt);
            if (oldSubckt != null) {
                this.prErr("Subckt " + currentSubckt.getName() + " already defined");
            }
            this.currentSubcktStack.add(newSubckt);
        } else if (keyword.equals(".global")) {
            if (this.currentSubckt() != null) {
                this.prErr(".global inside .subckt");
            }
            for (int i = 1; i < tokens.length; ++i) {
                if (this.globalNets.contains(tokens[i])) continue;
                this.globalNets.add(tokens[i]);
            }
        } else if (keyword.startsWith(".ends")) {
            SpiceSubckt currentSubckt = this.currentSubckt();
            if (currentSubckt != null) {
                for (SpiceInstance inst : currentSubckt.getInstances()) {
                    inst.linkModel(this, this.currentSubcktStack);
                }
                this.currentSubcktStack.remove(this.currentSubcktStack.size() - 1);
            }
        } else if (keyword.startsWith(".end")) {
            if (this.currentSubckt() != null) {
                this.prErr("Expected .ends " + this.currentSubckt().getName());
            }
        } else if (keyword.equals(".model")) {
            this.parseModel(tokens);
        } else if (keyword.equals(".ic")) {
            SpiceInstance ic = this.parseInitial(tokens);
            this.addInstance(ic);
        } else if (keyword.equals(".tran")) {
            SpiceInstance ic = this.parseTran(tokens);
            this.addInstance(ic);
        } else if (keyword.startsWith("x")) {
            SpiceInstance inst = this.parseSubcktInstance(tokens);
            this.addInstance(inst);
        } else if (keyword.startsWith("r")) {
            SpiceInstance inst = this.parseResistor(tokens);
            this.addInstance(inst);
        } else if (keyword.startsWith("c")) {
            SpiceInstance inst = this.parseCapacitor(tokens);
            this.addInstance(inst);
        } else if (keyword.startsWith("v")) {
            SpiceInstance inst = this.parseVoltageSource(tokens);
            this.addInstance(inst);
        } else if (keyword.startsWith("m")) {
            SpiceInstance inst = this.parseMosfet(tokens);
            this.addInstance(inst);
        } else if (!keyword.equals(".protect") && !keyword.equals(".unprotect")) {
            this.prWarn("Parser does not recognize: " + line);
        }
    }

    private File resolveFile(String newName) {
        if (newName.startsWith("'") && newName.endsWith("'")) {
            newName = newName.substring(1, newName.length() - 1);
        }
        if (newName.startsWith("/") || newName.startsWith("\\")) {
            return new File(newName);
        }
        return new File(this.file.getParent(), newName);
    }

    private SpiceLibrary readLibrary(File libFile, boolean verbose) throws IOException {
        SpiceLibrary theLibrary = this.libraries.get(libFile);
        if (theLibrary == null) {
            if (verbose) {
                System.out.println("Reading library file " + libFile);
            }
            theLibrary = new SpiceLibrary(libFile);
            this.libraries.put(libFile, theLibrary);
        }
        return theLibrary;
    }

    void prErr(String msg) {
        System.out.println("Error (" + this.getLocation() + "): " + msg);
    }

    private void prWarn(String msg) {
        System.out.println("Warning (" + this.getLocation() + "): " + msg);
    }

    private String getLocation() {
        return this.file.getName() + ":" + this.lineno;
    }

    private String[] getTokens(String line) {
        int i;
        ArrayList<String> tokens = new ArrayList<String>();
        int start = 0;
        boolean inquotes = false;
        int inparens = 0;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (inquotes) {
                if (c != '\'' || inparens > 0) continue;
                tokens.add(line.substring(start, i + 1));
                start = i + 1;
                inquotes = false;
                continue;
            }
            if (c == '\'') {
                assert (inparens == 0);
                if (inparens > 0) continue;
                inquotes = true;
                if (start != i) {
                    this.prErr("Improper use of open quote '");
                    break;
                }
                start = i;
                continue;
            }
            if (Character.isWhitespace(c) && inparens == 0) {
                if (start < i) {
                    tokens.add(line.substring(start, i));
                }
                start = i + 1;
                continue;
            }
            if (inquotes && c == '(') {
                ++inparens;
                continue;
            }
            if (inquotes && c == ')') {
                if (inparens == 0) {
                    this.prErr("Too many ')'s");
                    break;
                }
                --inparens;
                continue;
            }
            if (c == '=') {
                if (start < i) {
                    tokens.add(line.substring(start, i));
                }
                tokens.add("=");
                start = i + 1;
                continue;
            }
            if (c == '*') break;
        }
        if (start < i) {
            tokens.add(line.substring(start, i));
        }
        if (inparens != 0) {
            this.prErr("Unmatched parentheses");
        }
        ArrayList<Object> joined = new ArrayList<Object>();
        for (int j = 0; j < tokens.size(); ++j) {
            if (((String)tokens.get(j)).equals("=")) {
                if (j == 0) {
                    this.prErr("No right hand side to assignment");
                    continue;
                }
                if (j == tokens.size() - 1) {
                    this.prErr("No left hand side to assignment");
                    continue;
                }
                int last = joined.size() - 1;
                joined.set(last, (String)joined.get(last) + "=" + (String)tokens.get(++j));
                continue;
            }
            joined.add((String)tokens.get(j));
        }
        String[] ret = new String[joined.size()];
        for (int k = 0; k < joined.size(); ++k) {
            ret[k] = (String)joined.get(k);
        }
        return ret;
    }

    private SpiceSubckt currentSubckt() {
        return this.currentSubcktStack.isEmpty() ? null : this.currentSubcktStack.get(this.currentSubcktStack.size() - 1);
    }

    private void parseOptions(Map<String, String> map, int start, String[] tokens) {
        for (int i = start; i < tokens.length; ++i) {
            int e = tokens[i].indexOf(61);
            String pname = tokens[i];
            String value = "true";
            if (e > 0) {
                pname = tokens[i].substring(0, e);
                value = tokens[i].substring(e + 1);
            }
            if (pname == null || value == null) {
                this.prErr("Bad option value: " + tokens[i]);
                continue;
            }
            map.put(pname.toLowerCase(), value);
        }
    }

    private void parseParams(Map<String, String> map, int start, String[] tokens) {
        for (int i = start; i < tokens.length; ++i) {
            this.parseParam(map, tokens[i], null);
        }
    }

    private void parseParam(Map<String, String> map, String parval, String defaultParName) {
        int e = parval.indexOf(61);
        String pname = defaultParName;
        String value = parval;
        if (e > 0) {
            pname = parval.substring(0, e);
            value = parval.substring(e + 1);
            if (defaultParName != null && !defaultParName.equalsIgnoreCase(pname)) {
                this.prWarn("Expected param " + defaultParName + ", but got " + pname);
            }
        }
        if (pname == null || value == null) {
            this.prErr("Badly formatted param=val: " + parval);
            return;
        }
        String old = map.put(pname.toLowerCase(), value);
        if (old != null) {
            this.prWarn("Redefinition of param " + pname + " " + old + " --> " + value);
        }
    }

    private SpiceSubckt parseSubckt(String[] parts) {
        int i;
        SpiceSubckt subckt = new SpiceSubckt(parts[1]);
        for (i = 2; i < parts.length && parts[i].indexOf(61) <= 0; ++i) {
            subckt.addPort(parts[i]);
        }
        this.parseParams(subckt.getParams(), i, parts);
        return subckt;
    }

    private SpiceInstance parseSubcktInstance(String[] parts) {
        int i;
        String name = parts[0].substring(1);
        ArrayList<String> nets = new ArrayList<String>();
        for (i = 1; i < parts.length && !parts[i].contains("="); ++i) {
            nets.add(parts[i]);
        }
        String subcktName = (String)nets.remove(nets.size() - 1);
        SpiceSubckt subckt = null;
        for (int j = this.currentSubcktStack.size() - 1; subckt == null && j >= 0; --j) {
            subckt = this.currentSubcktStack.get(j).findSubckt(subcktName);
        }
        if (subckt == null) {
            subckt = this.subckts.get(subcktName.toLowerCase());
        }
        if (subckt == null) {
            this.prErr("Cannot find subckt for " + subcktName);
            return null;
        }
        SpiceInstance inst = new SpiceInstance(subckt, name);
        for (String net : nets) {
            inst.addNet(net);
        }
        Map<String, String> instParams = inst.getParams();
        this.parseParams(instParams, i, parts);
        for (String key : subckt.getParams().keySet()) {
            if (instParams.containsKey(key)) continue;
            instParams.put(key, subckt.getParams().get(key));
        }
        if (inst.getNets().size() != subckt.getPorts().size()) {
            this.prErr("Number of ports do not match: " + inst.getNets().size() + " (instance " + name + ") vs " + subckt.getPorts().size() + " (subckt " + subckt.getName() + ")");
        }
        return inst;
    }

    private void addInstance(SpiceInstance inst) {
        if (inst == null) {
            return;
        }
        SpiceSubckt currentSubckt = this.currentSubckt();
        if (currentSubckt != null) {
            currentSubckt.addInstance(inst);
        } else {
            this.topLevelInstances.add(inst);
        }
    }

    private SpiceInstance parseResistor(String[] parts) {
        if (parts.length < 4) {
            this.prErr("Not enough arguments for resistor");
            return null;
        }
        SpiceInstance inst = new SpiceInstance(parts[0]);
        for (int i = 1; i < 3; ++i) {
            inst.addNet(parts[i]);
        }
        this.parseParam(inst.getParams(), parts[3], "r");
        return inst;
    }

    private SpiceInstance parseCapacitor(String[] parts) {
        if (parts.length < 4) {
            this.prErr("Not enough arguments for capacitor");
            return null;
        }
        SpiceInstance inst = new SpiceInstance(parts[0]);
        for (int i = 1; i < 3; ++i) {
            inst.addNet(parts[i]);
        }
        this.parseParam(inst.getParams(), parts[3], "c");
        return inst;
    }

    private SpiceInstance parseVoltageSource(String[] parts) {
        if (parts.length < 4) {
            this.prErr("Not enough arguments for voltage");
            return null;
        }
        SpiceInstance inst = new SpiceInstance(parts[0]);
        for (int i = 1; i < 3; ++i) {
            inst.addNet(parts[i]);
        }
        this.parseParam(inst.getParams(), parts[3], "dc");
        return inst;
    }

    private SpiceInstance parseMosfet(String[] parts) {
        int i;
        if (parts.length < 8) {
            this.prErr("Not enough arguments for mosfet");
            return null;
        }
        SpiceInstance inst = new SpiceInstance(parts[0]);
        for (i = 1; i < 5; ++i) {
            inst.addNet(parts[i]);
        }
        String modelName = parts[i];
        inst.addModName(modelName);
        this.parseParams(inst.getParams(), ++i, parts);
        return inst;
    }

    private void parseModel(String[] parts) {
        SpiceModel model;
        SpiceSubckt currentSubckt;
        if (parts.length < 3) {
            this.prErr("Not enough arguments for token");
            return;
        }
        int i = 1;
        String modName = parts[i++];
        String modFlag = parts[i++];
        String modSuffix = "";
        int ind = modName.indexOf(46);
        if (ind >= 0) {
            modSuffix = modName.substring(ind);
            modName = modName.substring(0, ind);
        }
        if ((currentSubckt = this.currentSubckt()) != null) {
            model = currentSubckt.addModel(modName, modFlag);
        } else {
            String key = modName.toLowerCase();
            model = this.globalModels.get(key);
            if (model == null) {
                model = new SpiceModel(modName, modFlag);
                this.globalModels.put(key, model);
            }
        }
        if (!modFlag.equals(model.getFlag())) {
            this.prErr("model flag " + modFlag + " mismatches previos flag " + model.getFlag());
        }
        String[] paramTokens = parts.length >= 4 && parts[i].equals("(") && parts[parts.length - 1].equals(")") ? Arrays.copyOfRange(parts, i + 1, parts.length - 1) : Arrays.copyOfRange(parts, i, parts.length);
        this.parseParams(model.newParams(modSuffix), 0, paramTokens);
    }

    private SpiceInstance parseInitial(String[] parts) {
        SpiceInstance inst = new SpiceInstance(parts[0]);
        int i = 1;
        this.parseParams(inst.getParams(), i, parts);
        return inst;
    }

    private SpiceInstance parseTran(String[] parts) {
        if (parts.length < 3) {
            this.prErr("Not enough arguments for resistor");
            return null;
        }
        SpiceInstance inst = new SpiceInstance(parts[0] + " " + parts[1] + " " + parts[2]);
        return inst;
    }

    private void parseComment(String line) {
        SpiceSubckt currentSubckt = this.currentSubckt();
        if (currentSubckt == null) {
            return;
        }
        String[] parts = line.split("\\s+");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equalsIgnoreCase("PORT") || i + 2 >= parts.length) continue;
            String dir = parts[i + 1];
            String port = parts[i + 2];
            SpiceSubckt.PortType type = SpiceSubckt.PortType.valueOf(dir);
            if (type != null) {
                currentSubckt.setPortType(port, type);
            }
            return;
        }
    }

    private String readLine() throws IOException {
        String line;
        while (true) {
            ++this.lineno;
            line = null;
            if (this.macroReader != null && this.macroReader.hasNext()) {
                line = this.macroReader.next();
            } else if (this.reader != null) {
                line = this.reader.readLine();
            }
            if (line == null) {
                if (this.lines.length() == 0) {
                    return null;
                }
                return this.removeString();
            }
            if ((line = line.trim()).startsWith("*")) {
                this.parseComment(line);
                continue;
            }
            if (line.startsWith("+")) {
                this.lines.append(" ");
                this.lines.append(line.substring(1));
                continue;
            }
            if (this.lines.length() != 0) break;
            this.lines.append(line);
        }
        String ret = this.removeString();
        this.lines.append(line);
        return ret;
    }

    private String removeString() {
        String ret = this.lines.toString();
        this.lines.delete(0, this.lines.length());
        return ret;
    }

    public void writeFile(String fileName) {
        if (fileName == null) {
            this.write(System.out);
        } else {
            try {
                PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName)));
                this.write(out);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public void write(PrintStream out) {
        HashSet<SpiceSubckt> usedSubckts = null;
        HashSet<SpiceModel> usedModels = null;
        usedSubckts = new HashSet<SpiceSubckt>();
        usedModels = new HashSet<SpiceModel>();
        for (SpiceInstance inst : this.topLevelInstances) {
            inst.markUsed(usedSubckts, usedModels);
        }
        out.println("* Spice netlist");
        for (String key : this.options.keySet()) {
            String value = this.options.get(key);
            if (value == null) {
                out.println(".option " + key);
                continue;
            }
            out.println(".option " + key + "=" + this.options.get(key));
        }
        out.println();
        for (String key : this.globalParams.keySet()) {
            out.println(".param " + key + "=" + this.globalParams.get(key));
        }
        out.println();
        for (SpiceModel model : this.globalModels.values()) {
            model.write(out, usedModels);
        }
        out.println();
        for (String net : this.globalNets) {
            out.println(".global " + net);
        }
        out.println();
        for (String subcktName : this.subckts.keySet()) {
            SpiceSubckt subckt = this.subckts.get(subcktName);
            subckt.write(out, usedSubckts, usedModels);
            out.println();
        }
        for (SpiceInstance inst : this.topLevelInstances) {
            inst.write(out);
        }
        out.println();
        out.println(".end");
        out.flush();
        if (out != System.out) {
            out.close();
        }
    }

    static void multiLinePrint(PrintStream out, boolean isComment, String str) {
        char contChar = '+';
        if (isComment) {
            contChar = '*';
        }
        int lastSpace = -1;
        int count = 0;
        boolean insideQuotes = false;
        int lineStart = 0;
        for (int pt = 0; pt < str.length(); ++pt) {
            char chr = str.charAt(pt);
            if (chr == '\n') {
                out.print(str.substring(lineStart, pt + 1));
                count = 0;
                lastSpace = -1;
                lineStart = pt + 1;
                continue;
            }
            if (chr == ' ' && !insideQuotes) {
                lastSpace = pt;
            }
            if (chr == '\'') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (++count < 78 || insideQuotes || lastSpace <= -1) continue;
            String partial = str.substring(lineStart, lastSpace + 1);
            out.print(partial + "\n" + contChar);
            count -= partial.length();
            lineStart = lastSpace + 1;
            lastSpace = -1;
        }
        if (lineStart < str.length()) {
            String partial = str.substring(lineStart);
            out.print(partial);
        }
    }

    public static void main(String[] args) {
        SpiceNetlistReader reader = new SpiceNetlistReader();
        try {
            reader.readFile(new File("/import/async/cad/2006/bic/jkg/bic/testSims/test_clk_regen.spi"), true);
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        reader.writeFile("/tmp/output.spi");
    }

    static class SpiceLibrary {
        private final List<String> lines = new ArrayList<String>();
        private final Map<String, Integer> libIndex = new HashMap<String, Integer>();

        SpiceLibrary(File file) throws IOException {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] pieces;
                    this.lines.add(line);
                    if (line.length() < 4 || !line.substring(0, 4).toLowerCase().equals(".lib") || (pieces = line.split("[ \t]+")).length != 2) continue;
                    this.libIndex.put(pieces[1].toLowerCase(), this.lines.size());
                }
            }
        }
    }
}

