/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.netlist.Inductor;
import com.sun.electric.tool.ncc.netlist.Josephson;
import com.sun.electric.tool.ncc.netlist.Mos;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Resistor;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.result.PartReport;
import com.sun.electric.tool.ncc.trees.Circuit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public abstract class Part
extends NetObject
implements PartReport.PartReportable {
    private static final Wire[] DELETED = null;
    private static final int NUM_FUNCS = PrimitiveNode.Function.values().length;
    protected static final int TYPE_FIELD_WIDTH = (int)Math.ceil(Math.log(NUM_FUNCS) / Math.log(2.0));
    private NccNameProxy.PartNameProxy nameProxy;
    private VarContext context;
    private final PrimitiveNode.Function type;
    protected Wire[] pins;

    protected Part(NccNameProxy.PartNameProxy name, VarContext cont, PrimitiveNode.Function type, Wire[] pins) {
        this.nameProxy = name;
        this.context = cont;
        this.type = type;
        this.pins = pins;
        for (int i = 0; i < pins.length; ++i) {
            pins[i].add(this);
        }
    }

    public PrimitiveNode.Function type() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.nameProxy.getName();
    }

    public Iterator getConnected() {
        return Arrays.asList(this.pins).iterator();
    }

    @Override
    public NccNameProxy.PartNameProxy getNameProxy() {
        return this.nameProxy;
    }

    public VarContext getContext() {
        return this.context;
    }

    @Override
    public NetObject.Type getNetObjType() {
        return NetObject.Type.PART;
    }

    public int numPins() {
        return this.pins.length;
    }

    public abstract int[] getPinCoeffs();

    public abstract boolean parallelMerge(Part var1, NccOptions var2);

    public abstract Integer hashCodeForParallelMerge();

    public void setDeleted() {
        this.pins = DELETED;
    }

    @Override
    public boolean isDeleted() {
        return this.pins == DELETED;
    }

    public int numDistinctWires() {
        HashSet<Wire> wires = new HashSet<Wire>();
        for (int i = 0; i < this.pins.length; ++i) {
            wires.add(this.pins[i]);
        }
        return wires.size();
    }

    @Override
    public abstract String typeString();

    public abstract int typeCode();

    public int numPinsConnected(Wire w) {
        int numConnected = 0;
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            ++numConnected;
        }
        return numConnected;
    }

    public Integer computeHashCode() {
        int sum = 0;
        int[] codes = this.getPinCoeffs();
        for (int i = 0; i < this.pins.length; ++i) {
            Wire w = this.pins[i];
            sum += w.getCode() * codes[i];
        }
        return sum;
    }

    public int getHashFor(Wire w) {
        int sum = 0;
        int[] codes = this.getPinCoeffs();
        for (int i = 0; i < this.pins.length; ++i) {
            Wire x = this.pins[i];
            Part.error(x == null, "null wire?");
            if (x != w) continue;
            sum += codes[i] * this.getCode();
        }
        return sum;
    }

    @Override
    public void checkMe(Circuit parent) {
        Part.error(parent != this.getParent(), "wrong parent");
        for (int i = 0; i < this.pins.length; ++i) {
            Wire w = this.pins[i];
            Part.error(w == null, "Wire is null");
            Part.error(!w.touches(this), "Wire not connected to Part");
        }
    }

    public abstract PinType getPinTypeOfNthPin(int var1);

    @Override
    public String instanceDescription() {
        String inst2;
        Object cellPath = this.nameProxy.leafCell().libDescribe();
        VarContext cont = this.getContext();
        Iterator<Nodable> it = cont.getPathIterator();
        if (it.hasNext()) {
            Nodable no = it.next();
            cellPath = no.getParent().libDescribe();
        }
        if ((inst2 = cont.getInstPath(" / ")).length() > 0) {
            cellPath = (String)cellPath + " / " + inst2;
        }
        return this.typeString() + " " + this.nameProxy.leafName() + " in Cell: " + (String)cellPath;
    }

    @Override
    public abstract String valueDescription();

    public abstract String connectionDescription(Wire var1);

    @Override
    public boolean isMos() {
        return this instanceof Mos;
    }

    @Override
    public boolean isResistor() {
        return this instanceof Resistor;
    }

    @Override
    public boolean isInductor() {
        return this instanceof Inductor;
    }

    @Override
    public boolean isJosephson() {
        return this instanceof Josephson;
    }

    @Override
    public double getWidth() {
        Job.error(true, "Part has no width");
        return 0.0;
    }

    @Override
    public double getLength() {
        Job.error(true, "Part has no length");
        return 0.0;
    }
}

