/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.kawa.functions.ArithOp;
import gnu.kawa.functions.Arithmetic;
import gnu.mapping.Procedure;
import gnu.mapping.PropertySet;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MultiplyOp
extends ArithOp {
    public static final MultiplyOp $St = new MultiplyOp("*");

    public MultiplyOp(String name) {
        super(name, 3);
        this.setProperty(Procedure.validateApplyKey, "gnu.kawa.functions.CompileArith:validateApplyArithOp");
        Procedure.compilerKey.set((PropertySet)this, "*gnu.kawa.functions.CompileArith:forMul");
    }

    @Override
    public Object defaultResult() {
        return IntNum.one();
    }

    public static Object apply(Object arg1, Object arg2) {
        return ((Numeric)arg1).mul(arg2);
    }

    @Override
    public Object applyN(Object[] args) {
        int len = args.length;
        if (len == 0) {
            return IntNum.one();
        }
        Number result = (Number)args[0];
        int code = Arithmetic.classifyValue(result);
        block11: for (int i = 1; i < len; ++i) {
            Object arg2 = args[i];
            int code2 = Arithmetic.classifyValue(arg2);
            code = code < code2 ? code2 : code;
            switch (code) {
                case 1: {
                    int i1 = Arithmetic.asInt(result);
                    int i2 = Arithmetic.asInt(arg2);
                    result = new Integer(i1 * i2);
                    continue block11;
                }
                case 2: {
                    long l1 = Arithmetic.asLong(result);
                    long l2 = Arithmetic.asLong(arg2);
                    result = new Long(l1 * l2);
                    continue block11;
                }
                case 3: {
                    BigInteger bi1 = Arithmetic.asBigInteger(result);
                    BigInteger bi2 = Arithmetic.asBigInteger(arg2);
                    result = bi1.multiply(bi2);
                    continue block11;
                }
                case 4: {
                    result = IntNum.times(Arithmetic.asIntNum(result), Arithmetic.asIntNum(arg2));
                    continue block11;
                }
                case 5: {
                    BigDecimal bd1 = Arithmetic.asBigDecimal(result);
                    BigDecimal bd2 = Arithmetic.asBigDecimal(arg2);
                    result = bd1.multiply(bd2);
                    continue block11;
                }
                case 6: {
                    result = RatNum.times(Arithmetic.asRatNum(result), Arithmetic.asRatNum(arg2));
                    continue block11;
                }
                case 7: {
                    float f1 = Arithmetic.asFloat(result);
                    float f2 = Arithmetic.asFloat(arg2);
                    result = new Float(f1 * f2);
                    continue block11;
                }
                case 8: {
                    double d1 = Arithmetic.asDouble(result);
                    double d2 = Arithmetic.asDouble(arg2);
                    result = new Double(d1 * d2);
                    continue block11;
                }
                case 9: {
                    double d1 = Arithmetic.asDouble(result);
                    double d2 = Arithmetic.asDouble(arg2);
                    result = new DFloNum(d1 * d2);
                    continue block11;
                }
                default: {
                    result = Arithmetic.asNumeric(result).mul(Arithmetic.asNumeric(arg2));
                }
            }
        }
        return result;
    }
}

