/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.lists.LList;
import gnu.lists.SeqPosition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;

public class CGIServletWrapper
implements ServletConfig {
    String servletName;
    Servlet servlet;
    CGIRequest request;
    CGIResponse response;
    String characterEncoding;
    static final Enumeration nullEnumeration = new SeqPosition(LList.Empty, 0, false);
    ServletContext context;

    public static void main(String[] args) {
        try {
            CGIServletWrapper wrapper = new CGIServletWrapper();
            Class<?> servClass = Class.forName(args[0]);
            wrapper.servletName = args[0];
            HttpServlet servlet = (HttpServlet)servClass.newInstance();
            wrapper.servlet = servlet;
            servlet.init((ServletConfig)wrapper);
            CGIResponse response = wrapper.getResponse();
            servlet.service((ServletRequest)wrapper.getRequest(), (ServletResponse)response);
            response.flushBuffer();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new CGIContext();
        }
        return this.context;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return nullEnumeration;
    }

    public CGIRequest getRequest() {
        if (this.request == null) {
            this.request = new CGIRequest();
        }
        return this.request;
    }

    public CGIResponse getResponse() {
        if (this.response == null) {
            this.response = new CGIResponse();
        }
        return this.response;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CGIContext
    implements ServletContext {
        Hashtable<String, Object> attributes;

        public String getContextPath() {
            return "";
        }

        public ServletContext getContext(String path) {
            return null;
        }

        public int getMajorVersion() {
            return 3;
        }

        public int getMinorVersion() {
            return 0;
        }

        public int getEffectiveMajorVersion() {
            throw new UnsupportedOperationException();
        }

        public int getEffectiveMinorVersion() {
            throw new UnsupportedOperationException();
        }

        public String getMimeType(String file) {
            return null;
        }

        public Set getResourcePaths(String path) {
            return null;
        }

        public URL getResource(String path) {
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return null;
        }

        public RequestDispatcher getNamedDispatcher(String path) {
            return null;
        }

        public Servlet getServlet(String name) {
            return null;
        }

        public Enumeration getServlets() {
            return nullEnumeration;
        }

        public Enumeration getServletNames() {
            return nullEnumeration;
        }

        public void log(String message) {
        }

        public void log(Exception ex, String mgs) {
        }

        public void log(String msg, Throwable ex) {
        }

        public String getRealPath(String path) {
            return null;
        }

        public String getServerInfo() {
            return "Kawa CGI/servlet wrapper";
        }

        public String getInitParameter(String name) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return nullEnumeration;
        }

        public boolean setInitParameter(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public Object getAttribute(String name) {
            return this.attributes == null ? null : this.attributes.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            return this.attributes.keys();
        }

        public void setAttribute(String name, Object value) {
            if (value == null) {
                this.removeAttribute(name);
            } else {
                if (this.attributes == null) {
                    this.attributes = new Hashtable();
                }
                this.attributes.put(name, value);
            }
        }

        public void removeAttribute(String name) {
            if (this.attributes != null) {
                this.attributes.remove(name);
            }
        }

        public String getServletContextName() {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            throw new UnsupportedOperationException();
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public ServletRegistration getServletRegistration(String servletName) {
            throw new UnsupportedOperationException();
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            throw new UnsupportedOperationException();
        }

        public <T extends Filter> T createFilter(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            throw new UnsupportedOperationException();
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            throw new UnsupportedOperationException();
        }

        public SessionCookieConfig getSessionCookieConfig() {
            throw new UnsupportedOperationException();
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
            throw new UnsupportedOperationException();
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            throw new UnsupportedOperationException();
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            throw new UnsupportedOperationException();
        }

        public void addListener(String className) {
            throw new UnsupportedOperationException();
        }

        public <T extends EventListener> void addListener(T t) {
            throw new UnsupportedOperationException();
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
            throw new UnsupportedOperationException();
        }

        public <T extends EventListener> T createListener(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            throw new UnsupportedOperationException();
        }

        public ClassLoader getClassLoader() {
            return CGIServletWrapper.this.servlet.getClass().getClassLoader();
        }

        public void declareRoles(String ... roleNames) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CGIResponse
    extends ServletOutputStream
    implements HttpServletResponse {
        String sawContentType;
        byte[] buffer = null;
        int bufpos = 0;
        PrintStream out = System.out;
        ArrayList<String> headers = new ArrayList();
        int statusCode = 0;
        String statusString;
        private static final int defaultBufferSize = 2048;
        PrintWriter writer;
        boolean committed;

        public void addCookie(Cookie cookie) {
        }

        public boolean containsHeader(String str) {
            int num = this.headers.size();
            for (int i = 0; i < num; i += 2) {
                if (!this.headers.get(i).equals(str)) continue;
                return true;
            }
            return false;
        }

        public String encodeURL(String str) {
            return null;
        }

        public String encodeRedirectURL(String str) {
            return null;
        }

        public String encodeUrl(String str) {
            return null;
        }

        public String encodeRedirectUrl(String str) {
            return null;
        }

        public void sendError(int i, String str) {
            this.statusCode = i;
            this.statusString = str;
        }

        public void sendError(int i) {
            this.statusCode = i;
            this.statusString = null;
        }

        public void sendRedirect(String str) {
        }

        public void setDateHeader(String str, long l) {
        }

        public void addDateHeader(String str, long l) {
        }

        public void setHeader(String label, String value) {
            int num = this.headers.size();
            for (int i = 0; i < num; i += 2) {
                if (!this.headers.get(i).equals(label)) continue;
                if (label.equalsIgnoreCase("Content-type")) {
                    this.sawContentType = value;
                }
                this.headers.set(i + 1, value);
                break;
            }
            this.addHeader(label, value);
        }

        public void addHeader(String label, String value) {
            if (label.equalsIgnoreCase("Content-type")) {
                this.sawContentType = value;
            }
            this.headers.add(label);
            this.headers.add(value);
        }

        public void setIntHeader(String str, int i) {
            this.setHeader(str, Integer.toString(i));
        }

        public void addIntHeader(String str, int i) {
            this.addHeader(str, Integer.toString(i));
        }

        public void setStatus(int i) {
            this.statusCode = i;
            this.statusString = null;
        }

        public void setStatus(int i, String str) {
            this.statusCode = i;
            this.statusString = str;
        }

        public int getStatus() {
            return this.statusCode;
        }

        public String getContentType() {
            return this.sawContentType;
        }

        public String getHeader(String name) {
            int num = this.headers.size();
            for (int i = 0; i < num; i += 2) {
                if (!this.headers.get(i).equals(name)) continue;
                return this.headers.get(i + 1);
            }
            return null;
        }

        public Collection<String> getHeaders(String name) {
            ArrayList<String> result = new ArrayList<String>();
            int num = this.headers.size();
            for (int i = 0; i < num; i += 2) {
                if (!this.headers.get(i).equals(name)) continue;
                result.add(this.headers.get(i + 1));
            }
            return result;
        }

        public Collection<String> getHeaderNames() {
            ArrayList<String> result = new ArrayList<String>();
            int num = this.headers.size();
            for (int i = 0; i < num; i += 2) {
                result.add(this.headers.get(i));
            }
            return result;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration getLocales() {
            return null;
        }

        public void setLocale(Locale locale) {
        }

        public void resetBuffer() {
            this.bufpos = 0;
        }

        public void reset() {
            this.resetBuffer();
        }

        public boolean isCommitted() {
            return this.committed;
        }

        public void flushBuffer() throws IOException {
            this.committ();
            if (this.bufpos > 0) {
                this.out.write(this.buffer, 0, this.bufpos);
            }
            this.bufpos = 0;
        }

        public void setBufferSize(int size) {
            if (this.bufpos > 0 || this.committed) {
                throw new IllegalStateException();
            }
            this.buffer = new byte[size];
        }

        public int getBufferSize() {
            return this.buffer == null ? 2048 : this.buffer.length;
        }

        public void setContentType(String type) {
            this.setHeader("Content-Type", type);
        }

        public void setContentLength(int len) {
            this.setIntHeader("Content-Length", len);
        }

        public String getCharacterEncoding() {
            return CGIServletWrapper.this.characterEncoding;
        }

        public void setCharacterEncoding(String enc) {
            CGIServletWrapper.this.characterEncoding = enc;
        }

        private void allocateBuffer() {
            if (this.buffer == null) {
                this.buffer = new byte[2048];
            }
        }

        public void write(int c) throws IOException {
            this.allocateBuffer();
            int bufsize = this.buffer.length;
            if (this.buffer.length == 0) {
                this.committ();
                this.out.write(c);
            } else {
                if (this.bufpos >= this.buffer.length) {
                    this.flushBuffer();
                }
                this.buffer[this.bufpos++] = (byte)c;
            }
        }

        public ServletOutputStream getOutputStream() {
            return this;
        }

        public PrintWriter getWriter() {
            if (this.writer == null) {
                this.writer = new PrintWriter(this.out);
            }
            return this.writer;
        }

        private void printHeader(String label, String value) {
            this.out.print(label);
            this.out.print(": ");
            this.out.println(value);
        }

        private void printHeaders() {
            if (this.statusCode != 0) {
                this.out.print("Status: ");
                this.out.print(this.statusCode);
                if (this.statusString != null) {
                    this.out.print(' ');
                    this.out.print(this.statusString);
                }
                this.out.println();
            }
            if (this.sawContentType == null) {
                this.setContentType("text/html");
            }
            int num = this.headers.size();
            for (int i = 0; i < num; i += 2) {
                this.printHeader(this.headers.get(i).toString(), this.headers.get(i + 1).toString());
            }
            this.out.println();
        }

        private void committ() throws IOException {
            if (!this.committed) {
                this.printHeaders();
                this.committed = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CGIRequest
    implements HttpServletRequest {
        Hashtable<String, Object> attributes;

        String getCgiEnvVar(String name) {
            return System.getProperty(name);
        }

        public String getAuthType() {
            return this.getCgiEnvVar("AUTH_TYPE");
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String str) {
            return -1L;
        }

        public String getHeader(String str) {
            return null;
        }

        public Enumeration<String> getHeaders(String str) {
            return null;
        }

        public Enumeration getHeaderNames() {
            return null;
        }

        public int getIntHeader(String str) {
            return -1;
        }

        public String getMethod() {
            String method = this.getCgiEnvVar("REQUEST_METHOD");
            return method == null ? "GET" : method;
        }

        public String getPathInfo() {
            return this.getCgiEnvVar("PATH_INFO");
        }

        public String getPathTranslated() {
            return this.getCgiEnvVar("PATH_TRANSLATED");
        }

        public String getContextPath() {
            return "";
        }

        public String getQueryString() {
            return this.getCgiEnvVar("QUERY_STRING");
        }

        public String getRemoteUser() {
            return this.getCgiEnvVar("REMOTE_USER");
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public Part getPart(String name) {
            return null;
        }

        public Collection<Part> getParts() {
            return null;
        }

        public void login(String username, String password) throws ServletException {
            throw new ServletException();
        }

        public void logout() {
        }

        public boolean authenticate(HttpServletResponse response) throws ServletException {
            throw new ServletException();
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public HttpSession getSession(boolean b) {
            return null;
        }

        public HttpSession getSession() {
            return null;
        }

        public String getServletPath() {
            return this.getCgiEnvVar("SCRIPT_NAME");
        }

        public String getRequestURI() {
            String script = this.getServletPath();
            String path = this.getPathInfo();
            if (script == null) {
                return path;
            }
            if (path == null) {
                return script;
            }
            return script + '/' + path;
        }

        public StringBuffer getRequestURL() {
            StringBuffer url = new StringBuffer(100);
            String scheme = this.getScheme();
            int port = this.getServerPort();
            if (port < 0) {
                port = 80;
            }
            url.append(scheme);
            url.append("://");
            url.append(this.getServerName());
            if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                url.append(':');
                url.append(port);
            }
            url.append('/');
            url.append(this.getRequestURI());
            return url;
        }

        public String getScheme() {
            return this.getServerPort() == 443 ? "https" : "http";
        }

        public String getRemoteAddr() {
            return this.getCgiEnvVar("REMOTE_ADDR");
        }

        public String getRemoteHost() {
            String host = this.getCgiEnvVar("REMOTE_HOST");
            return host != null ? host : this.getRemoteAddr();
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration getLocales() {
            return null;
        }

        public boolean isSecure() {
            return this.getServerPort() == 443;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return this.getServletContext().getRequestDispatcher(path);
        }

        public String getRealPath(String path) {
            return this.getServletContext().getRealPath(path);
        }

        public String getProtocol() {
            return this.getCgiEnvVar("SERVER_PROTOCOL");
        }

        public int getRemotePort() {
            return -1;
        }

        public String getLocalName() {
            return this.getServerName();
        }

        public String getLocalAddr() {
            try {
                return InetAddress.getByName(this.getLocalName()).getHostAddress();
            }
            catch (UnknownHostException ex) {
                return "127.0.0.1";
            }
        }

        public int getLocalPort() {
            return this.getServerPort();
        }

        public int getServerPort() {
            String port = this.getCgiEnvVar("SERVER_PORT");
            if (port != null) {
                try {
                    return Integer.parseInt(port);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return -1;
        }

        public String getServerName() {
            return this.getCgiEnvVar("SERVER_NAME");
        }

        public String getParameter(String name) {
            return null;
        }

        public Enumeration getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String name) {
            return null;
        }

        public Map getParameterMap() {
            return null;
        }

        public BufferedReader getReader() {
            return null;
        }

        public ServletInputStream getInputStream() {
            return null;
        }

        public ServletContext getServletContext() {
            return CGIServletWrapper.this.getServletContext();
        }

        public AsyncContext startAsync() {
            throw new IllegalStateException();
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
            throw new IllegalStateException();
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public boolean isAsyncSupported() {
            return false;
        }

        public AsyncContext getAsyncContext() {
            throw new IllegalStateException();
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.REQUEST;
        }

        public Object getAttribute(String name) {
            return this.attributes == null ? null : this.attributes.get(name);
        }

        public Enumeration<String> getAttributeNames() {
            return this.attributes.keys();
        }

        public void setAttribute(String name, Object value) {
            if (value == null) {
                this.removeAttribute(name);
            } else {
                if (this.attributes == null) {
                    this.attributes = new Hashtable();
                }
                this.attributes.put(name, value);
            }
        }

        public void removeAttribute(String name) {
            if (this.attributes != null) {
                this.attributes.remove(name);
            }
        }

        public String getContentType() {
            return this.getCgiEnvVar("CONTENT_TYPE");
        }

        public int getContentLength() {
            String length = this.getCgiEnvVar("CONTENT_LENGTH");
            if (length != null) {
                try {
                    return Integer.parseInt(length);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return 0;
        }

        public String getCharacterEncoding() {
            return CGIServletWrapper.this.characterEncoding;
        }

        public void setCharacterEncoding(String enc) {
            CGIServletWrapper.this.characterEncoding = enc;
        }
    }
}

