/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;

public class BeginExp
extends Expression {
    Expression[] exps;
    int length;

    public BeginExp() {
    }

    public BeginExp(Expression[] expressionArray) {
        this.exps = expressionArray;
        this.length = expressionArray.length;
    }

    public BeginExp(Expression expression, Expression expression2) {
        this.exps = new Expression[2];
        this.exps[0] = expression;
        this.exps[1] = expression2;
        this.length = 2;
    }

    public static final Expression canonicalize(Expression expression) {
        if (expression instanceof BeginExp) {
            BeginExp beginExp = (BeginExp)expression;
            int n = beginExp.length;
            if (n == 0) {
                return QuoteExp.voidExp;
            }
            if (n == 1) {
                return BeginExp.canonicalize(beginExp.exps[0]);
            }
        }
        return expression;
    }

    public final void add(Expression expression) {
        if (this.exps == null) {
            this.exps = new Expression[8];
        }
        if (this.length == this.exps.length) {
            Expression[] expressionArray = new Expression[2 * this.length];
            System.arraycopy(this.exps, 0, expressionArray, 0, this.length);
            this.exps = expressionArray;
        }
        this.exps[this.length++] = expression;
    }

    public final Expression[] getExpressions() {
        return this.exps;
    }

    public final void setExpressions(Expression[] expressionArray) {
        this.exps = expressionArray;
        this.length = expressionArray.length;
    }

    public Object eval(Environment environment) throws Throwable {
        int n = this.length;
        int n2 = 0;
        while (n2 < n - 1) {
            this.exps[n2].eval(environment);
            ++n2;
        }
        return this.exps[n2].eval(environment);
    }

    public void compile(Compilation compilation, Target target) {
        int n = this.length;
        int n2 = 0;
        while (n2 < n - 1) {
            this.exps[n2].compileWithPosition(compilation, Target.Ignore);
            ++n2;
        }
        this.exps[n2].compileWithPosition(compilation, target);
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkBeginExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.exps = expWalker.walkExps(this.exps, this.length);
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Begin", ")", 2);
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        int n = this.length;
        int n2 = 0;
        while (n2 < n) {
            outPort.writeSpaceLinear();
            this.exps[n2].print(outPort);
            ++n2;
        }
        outPort.endLogicalBlock(")");
    }

    public Type getType() {
        return this.exps[this.length - 1].getType();
    }
}

