/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class F64Vector
extends SimpleVector
implements Externalizable {
    double[] data;
    protected static double[] empty = new double[0];

    public F64Vector() {
        this.data = empty;
    }

    public F64Vector(int n, double d) {
        double[] dArray = new double[n];
        this.data = dArray;
        this.size = n;
        while (--n >= 0) {
            dArray[n] = d;
        }
    }

    public F64Vector(int n) {
        this.data = new double[n];
        this.size = n;
    }

    public F64Vector(double[] dArray) {
        this.data = dArray;
        this.size = dArray.length;
    }

    public F64Vector(Sequence sequence) {
        this.data = new double[sequence.size()];
        this.addAll((Collection)sequence);
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            double[] dArray = new double[n];
            System.arraycopy(this.data, 0, dArray, 0, n2 < n ? n2 : n);
            this.data = dArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final double doubleAt(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[n];
    }

    public final double doubleAtBuffer(int n) {
        return this.data[n];
    }

    public final Object get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[n]);
    }

    public final Object getBuffer(int n) {
        return Convert.toObject(this.data[n]);
    }

    public final int intAtBuffer(int n) {
        return (int)this.data[n];
    }

    public final void setDoubleAt(int n, double d) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[n] = d;
    }

    public final void setDoubleAtBuffer(int n, double d) {
        this.data[n] = d;
    }

    public final Object setBuffer(int n, Object object2) {
        Object object3 = Convert.toObject(this.data[n]);
        this.data[n] = Convert.toDouble(object2);
        return object3;
    }

    protected void clearBuffer(int n, int n2) {
        while (--n2 >= 0) {
            this.data[n++] = 0.0;
        }
    }

    public int getElementKind() {
        return 26;
    }

    public String getTag() {
        return "f64";
    }

    public boolean consumeNext(int n, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeDouble(this.data[n2]);
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        while (n3 < n4) {
            consumer.writeDouble(this.data[n3]);
            ++n3;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeDouble(this.data[n2]);
            ++n2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = objectInput.readDouble();
            ++n2;
        }
        this.data = dArray;
        this.size = n;
    }
}

