/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.Type;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ResolveNames;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.lists.Consumer;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.XMLPrinter;
import gnu.xquery.lang.Prompter;
import gnu.xquery.lang.XQParser;
import gnu.xquery.util.BooleanValue;
import gnu.xquery.util.XMLFormat;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import kawa.standard.Scheme;

public class XQuery
extends Interpreter {
    public static final String XQUERY_FUNCTION_NAMESPACE = "http://www.w3.org/2002/08/xquery-functions";
    static boolean charIsInt = false;
    static XQuery instance;
    static int envCounter;
    public static final XMLFormat writeFormat;
    LangPrimType booleanType;

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        return (Numeric)object2;
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : -1;
        if (n < 0 || n > 65535) {
            throw new ClassCastException("not a character value");
        }
        return (char)n;
    }

    public boolean isTrue(Object object2) {
        return BooleanValue.booleanValue(object2);
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        XQParser xQParser = new XQParser(inPort, sourceMessages);
        xQParser.interpreter = this;
        return xQParser;
    }

    public Compilation parse(Environment environment, Lexer lexer) throws IOException, SyntaxException {
        Compilation.usingTailCalls = true;
        SourceMessages sourceMessages = lexer.getMessages();
        Compilation compilation = new Compilation(sourceMessages);
        ModuleExp moduleExp = new ModuleExp();
        compilation.push(moduleExp);
        compilation.mustCompileHere();
        compilation.immediate = true;
        lexer.clearErrors();
        Expression expression = ((XQParser)lexer).parse(compilation);
        if (expression == null) {
            return null;
        }
        moduleExp.body = expression;
        compilation.pop(moduleExp);
        ResolveNames.resolveNames(moduleExp, compilation.lexical);
        return compilation;
    }

    public Compilation parseFile(InPort inPort, boolean bl, SourceMessages sourceMessages) throws IOException, SyntaxException {
        Expression expression;
        Compilation.usingTailCalls = true;
        Compilation compilation = new Compilation(sourceMessages);
        compilation.immediate = bl;
        ModuleExp moduleExp = new ModuleExp();
        moduleExp.setFile(inPort.getName());
        compilation.push(moduleExp);
        XQParser xQParser = (XQParser)this.getLexer(inPort, sourceMessages);
        xQParser.nesting = 1;
        Vector<Expression> vector = new Vector<Expression>(10);
        while ((expression = xQParser.parse(compilation)) != null) {
            vector.addElement(expression);
        }
        int n = vector.size();
        if (n == 0) {
            moduleExp.body = QuoteExp.voidExp;
        } else if (n == 1) {
            moduleExp.body = (Expression)vector.elementAt(0);
        } else {
            Object[] objectArray = new Expression[n];
            vector.copyInto(objectArray);
            moduleExp.body = new BeginExp((Expression[])objectArray);
        }
        compilation.pop(moduleExp);
        ResolveNames.resolveNames(moduleExp, compilation.lexical);
        return compilation;
    }

    public int getNamespaceOf(Declaration declaration) {
        return declaration.isProcedureDecl() ? 2 : 1;
    }

    public String getName() {
        return "XQuery";
    }

    public XQuery() {
        Environment environment = Scheme.builtin();
        this.environ = new Environment(environment);
        this.environ.setName("interaction-environment." + ++envCounter);
        ModuleBody.setMainPrintValues(true);
        if (instance == null) {
            instance = this;
        }
        Environment environment2 = Environment.getCurrent();
        Environment.setCurrent(this.environ);
        try {
            this.loadClass("kawa.lib.std_syntax");
            this.loadClass("kawa.lib.lists");
            this.loadClass("kawa.lib.strings");
            this.loadClass("gnu.commonlisp.lisp.PrimOps");
            this.loadClass("gnu.kawa.slib.HTTP");
            this.loadClass("gnu.kawa.slib.XStrings");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Environment.setCurrent(environment2);
            throw throwable;
        }
    }

    public static XQuery getInstance() {
        if (instance == null) {
            instance = new XQuery();
        }
        return instance;
    }

    public static void registerEnvironment() {
        XQuery xQuery = new XQuery();
        Interpreter.defaultInterpreter = xQuery;
        Environment.setCurrent(xQuery.getEnvironment());
    }

    public Object read(InPort inPort) throws IOException, SyntaxException {
        return XQParser.readObject(inPort);
    }

    public FormatToConsumer getFormat(boolean bl) {
        return writeFormat;
    }

    public Consumer getOutputConsumer(Writer writer) {
        return new XMLPrinter(writer, false);
    }

    public Type getTypeFor(String string) {
        if (string == "t") {
            string = "java.lang.Object";
        }
        if (string.equals("string")) {
            return Type.string_type;
        }
        return Scheme.string2Type(string);
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        return Type.make(clazz);
    }

    public Procedure getPrompter() {
        return new Prompter();
    }

    static {
        envCounter = 0;
        writeFormat = new XMLFormat();
    }
}

